/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.DefaultConnectionPoolStrategy;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestBuilderBase<T extends RequestBuilderBase<T>> {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilderBase.class);
    private static final URI DEFAULT_REQUEST_URL = URI.create("http://localhost");
    private final Class<T> derived;
    protected final RequestImpl request;
    protected boolean useRawUrl = false;
    protected String baseURL;
    protected SignatureCalculator signatureCalculator;

    protected RequestBuilderBase(Class<T> derived, String method, boolean rawUrls) {
        this.derived = derived;
        this.request = new RequestImpl(rawUrls);
        this.request.method = method;
        this.useRawUrl = rawUrls;
    }

    protected RequestBuilderBase(Class<T> derived, Request prototype) {
        this.derived = derived;
        this.request = new RequestImpl(prototype);
        this.useRawUrl = prototype.isUseRawUrl();
    }

    public T setUrl(String url) {
        this.baseURL = url;
        return this.setURI(URI.create(url));
    }

    public T setURI(URI uri) {
        if (uri.getHost() == null) {
            throw new NullPointerException("uri.host");
        }
        if (uri.getPath() == null) {
            throw new NullPointerException("uri.path");
        }
        this.request.originalUri = uri;
        this.addQueryParameters(this.request.originalUri);
        this.request.uri = null;
        this.request.rawUri = null;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setInetAddress(InetAddress address) {
        this.request.address = address;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setLocalInetAddress(InetAddress address) {
        this.request.localAddress = address;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private void addQueryParameters(URI uri) {
        if (MiscUtil.isNonEmpty(uri.getRawQuery())) {
            String[] queries;
            for (String query : queries = uri.getRawQuery().split("&")) {
                int pos = query.indexOf("=");
                if (pos <= 0) {
                    this.addQueryParameter(query, null);
                    continue;
                }
                try {
                    if (this.useRawUrl) {
                        this.addQueryParameter(query.substring(0, pos), query.substring(pos + 1));
                        continue;
                    }
                    this.addQueryParameter(URLDecoder.decode(query.substring(0, pos), "UTF-8"), URLDecoder.decode(query.substring(pos + 1), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public T setVirtualHost(String virtualHost) {
        this.request.virtualHost = virtualHost;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeader(String name, String value) {
        this.request.headers.replace(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addHeader(String name, String value) {
        if (value == null) {
            logger.warn("Value was null, set to \"\"");
            value = "";
        }
        this.request.headers.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(FluentCaseInsensitiveStringsMap headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(Map<String, Collection<String>> headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setContentLength(int length) {
        this.request.length = length;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addCookie(Cookie cookie) {
        this.request.cookies.add(cookie);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public void resetQueryParameters() {
        this.request.queryParams = null;
    }

    public void resetCookies() {
        this.request.cookies.clear();
    }

    public void resetParameters() {
        this.request.params = null;
    }

    public void resetNonMultipartData() {
        RequestImpl.access$1302(this.request, null);
        this.request.stringData = null;
        this.request.streamData = null;
        this.request.entityWriter = null;
        this.request.length = -1L;
    }

    public void resetMultipartData() {
        this.request.parts = null;
    }

    public T setBody(File file) {
        this.request.file = file;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(byte[] data) {
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        RequestImpl.access$1302(this.request, data);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(String data) {
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.stringData = data;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(InputStream stream) {
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.streamData = stream;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(Request.EntityWriter dataWriter) {
        return this.setBody(dataWriter, -1L);
    }

    public T setBody(Request.EntityWriter dataWriter, long length) {
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.entityWriter = dataWriter;
        this.request.length = length;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(BodyGenerator bodyGenerator) {
        this.request.bodyGenerator = bodyGenerator;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addQueryParameter(String name, String value) {
        if (this.request.queryParams == null) {
            this.request.queryParams = new FluentStringsMap();
        }
        this.request.queryParams.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setQueryParameters(FluentStringsMap parameters) {
        this.request.queryParams = parameters == null ? null : new FluentStringsMap(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addParameter(String key, String value) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        if (this.request.params == null) {
            this.request.params = new FluentStringsMap();
        }
        this.request.params.add(key, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(FluentStringsMap parameters) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = new FluentStringsMap(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(Map<String, Collection<String>> parameters) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = new FluentStringsMap(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addBodyPart(Part part) {
        this.resetParameters();
        this.resetNonMultipartData();
        if (this.request.parts == null) {
            this.request.parts = new ArrayList();
        }
        this.request.parts.add(part);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setProxyServer(ProxyServer proxyServer) {
        this.request.proxyServer = proxyServer;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRealm(Realm realm) {
        this.request.realm = realm;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setFollowRedirects(boolean followRedirects) {
        this.request.followRedirects = followRedirects;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setPerRequestConfig(PerRequestConfig perRequestConfig) {
        this.request.perRequestConfig = perRequestConfig;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRangeOffset(long rangeOffset) {
        this.request.rangeOffset = rangeOffset;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setMethod(String method) {
        this.request.method = method;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBodyEncoding(String charset) {
        this.request.charset = charset;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setConnectionPoolKeyStrategy(ConnectionPoolKeyStrategy connectionPoolKeyStrategy) {
        this.request.connectionPoolKeyStrategy = connectionPoolKeyStrategy;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public Request build() {
        String contentLength;
        if (this.signatureCalculator != null) {
            String url = this.baseURL != null ? this.baseURL : this.request.originalUri.toString();
            int i = url.indexOf(63);
            if (i != -1) {
                url = url.substring(0, i);
            }
            this.signatureCalculator.calculateAndAddSignature(url, this.request, this);
        }
        try {
            String charset;
            String contentType = this.request.headers.getFirstValue("Content-Type");
            if (contentType != null && (charset = AsyncHttpProviderUtils.parseCharset(contentType)) != null) {
                this.request.charset = charset;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.request.length < 0L && this.request.streamData == null && (contentLength = this.request.headers.getFirstValue("Content-Length")) != null) {
            try {
                this.request.length = Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.request;
    }

    public T addOrReplaceCookie(Cookie cookie) {
        String cookieKey = cookie.getName();
        boolean replace = false;
        int index = 0;
        for (Cookie c : this.request.cookies) {
            if (c.getName().equals(cookieKey)) {
                replace = true;
                break;
            }
            ++index;
        }
        if (replace) {
            ((ArrayList)this.request.cookies).set(index, cookie);
        } else {
            this.request.cookies.add(cookie);
        }
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestImpl
    implements Request {
        private String method;
        private URI originalUri;
        private URI uri;
        private URI rawUri;
        private InetAddress address;
        private InetAddress localAddress;
        private FluentCaseInsensitiveStringsMap headers = new FluentCaseInsensitiveStringsMap();
        private Collection<Cookie> cookies = new ArrayList<Cookie>();
        private byte[] byteData;
        private String stringData;
        private InputStream streamData;
        private Request.EntityWriter entityWriter;
        private BodyGenerator bodyGenerator;
        private FluentStringsMap params;
        private List<Part> parts;
        private String virtualHost;
        private long length = -1L;
        public FluentStringsMap queryParams;
        public ProxyServer proxyServer;
        private Realm realm;
        private File file;
        private Boolean followRedirects;
        private PerRequestConfig perRequestConfig;
        private long rangeOffset;
        public String charset;
        private boolean useRawUrl;
        private ConnectionPoolKeyStrategy connectionPoolKeyStrategy = DefaultConnectionPoolStrategy.INSTANCE;

        public RequestImpl(boolean useRawUrl) {
            this.useRawUrl = useRawUrl;
        }

        public RequestImpl(Request prototype) {
            if (prototype != null) {
                this.method = prototype.getMethod();
                this.originalUri = prototype.getOriginalURI();
                this.address = prototype.getInetAddress();
                this.localAddress = prototype.getLocalAddress();
                this.headers = new FluentCaseInsensitiveStringsMap(prototype.getHeaders());
                this.cookies = new ArrayList<Cookie>(prototype.getCookies());
                this.byteData = prototype.getByteData();
                this.stringData = prototype.getStringData();
                this.streamData = prototype.getStreamData();
                this.entityWriter = prototype.getEntityWriter();
                this.bodyGenerator = prototype.getBodyGenerator();
                this.params = prototype.getParams() == null ? null : new FluentStringsMap(prototype.getParams());
                this.queryParams = prototype.getQueryParams() == null ? null : new FluentStringsMap(prototype.getQueryParams());
                this.parts = prototype.getParts() == null ? null : new ArrayList<Part>(prototype.getParts());
                this.virtualHost = prototype.getVirtualHost();
                this.length = prototype.getContentLength();
                this.proxyServer = prototype.getProxyServer();
                this.realm = prototype.getRealm();
                this.file = prototype.getFile();
                this.followRedirects = prototype.isRedirectOverrideSet() ? Boolean.valueOf(prototype.isRedirectEnabled()) : null;
                this.perRequestConfig = prototype.getPerRequestConfig();
                this.rangeOffset = prototype.getRangeOffset();
                this.charset = prototype.getBodyEncoding();
                this.useRawUrl = prototype.isUseRawUrl();
                this.connectionPoolKeyStrategy = prototype.getConnectionPoolKeyStrategy();
            }
        }

        @Override
        public String getReqType() {
            return this.getMethod();
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.address;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        private String removeTrailingSlash(URI uri) {
            String uriString = uri.toString();
            if (uriString.endsWith("/")) {
                return uriString.substring(0, uriString.length() - 1);
            }
            return uriString;
        }

        @Override
        public String getUrl() {
            return this.removeTrailingSlash(this.getURI());
        }

        @Override
        public String getRawUrl() {
            return this.removeTrailingSlash(this.getRawURI());
        }

        @Override
        public URI getOriginalURI() {
            return this.originalUri;
        }

        @Override
        public URI getURI() {
            if (this.uri == null) {
                this.uri = this.toURI(true);
            }
            return this.uri;
        }

        @Override
        public URI getRawURI() {
            if (this.rawUri == null) {
                this.rawUri = this.toURI(false);
            }
            return this.rawUri;
        }

        private URI toURI(boolean encode) {
            if (this.originalUri == null) {
                logger.debug("setUrl hasn't been invoked. Using http://localhost");
                this.originalUri = DEFAULT_REQUEST_URL;
            }
            AsyncHttpProviderUtils.validateSupportedScheme(this.originalUri);
            StringBuilder builder = new StringBuilder();
            builder.append(this.originalUri.getScheme()).append("://").append(this.originalUri.getRawAuthority());
            if (MiscUtil.isNonEmpty(this.originalUri.getRawPath())) {
                builder.append(this.originalUri.getRawPath());
            } else {
                builder.append("/");
            }
            if (MiscUtil.isNonEmpty(this.queryParams)) {
                builder.append("?");
                Iterator<Map.Entry<String, List<String>>> i = this.queryParams.iterator();
                while (i.hasNext()) {
                    Map.Entry<String, List<String>> param = i.next();
                    String name = param.getKey();
                    Iterator<String> j = param.getValue().iterator();
                    while (j.hasNext()) {
                        String value = j.next();
                        if (encode) {
                            UTF8UrlEncoder.appendEncoded(builder, name);
                        } else {
                            builder.append(name);
                        }
                        if (value != null) {
                            builder.append('=');
                            if (encode) {
                                UTF8UrlEncoder.appendEncoded(builder, value);
                            } else {
                                builder.append(value);
                            }
                        }
                        if (!j.hasNext()) continue;
                        builder.append('&');
                    }
                    if (!i.hasNext()) continue;
                    builder.append('&');
                }
            }
            return URI.create(builder.toString());
        }

        @Override
        public FluentCaseInsensitiveStringsMap getHeaders() {
            return this.headers;
        }

        @Override
        public Collection<Cookie> getCookies() {
            return Collections.unmodifiableCollection(this.cookies);
        }

        @Override
        public byte[] getByteData() {
            return this.byteData;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public InputStream getStreamData() {
            return this.streamData;
        }

        @Override
        public Request.EntityWriter getEntityWriter() {
            return this.entityWriter;
        }

        @Override
        public BodyGenerator getBodyGenerator() {
            return this.bodyGenerator;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public FluentStringsMap getParams() {
            return this.params;
        }

        @Override
        public List<Part> getParts() {
            return this.parts;
        }

        @Override
        public String getVirtualHost() {
            return this.virtualHost;
        }

        @Override
        public FluentStringsMap getQueryParams() {
            return this.queryParams;
        }

        @Override
        public ProxyServer getProxyServer() {
            return this.proxyServer;
        }

        @Override
        public Realm getRealm() {
            return this.realm;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isRedirectEnabled() {
            return this.followRedirects != null && this.followRedirects != false;
        }

        @Override
        public boolean isRedirectOverrideSet() {
            return this.followRedirects != null;
        }

        @Override
        public PerRequestConfig getPerRequestConfig() {
            return this.perRequestConfig;
        }

        @Override
        public long getRangeOffset() {
            return this.rangeOffset;
        }

        @Override
        public String getBodyEncoding() {
            return this.charset;
        }

        @Override
        public ConnectionPoolKeyStrategy getConnectionPoolKeyStrategy() {
            return this.connectionPoolKeyStrategy;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getURI().toString());
            sb.append("\t");
            sb.append(this.method);
            sb.append("\theaders:");
            if (MiscUtil.isNonEmpty(this.headers)) {
                for (String name : this.headers.keySet()) {
                    sb.append("\t");
                    sb.append(name);
                    sb.append(":");
                    sb.append(this.headers.getJoinedValue(name, ", "));
                }
            }
            if (MiscUtil.isNonEmpty(this.params)) {
                sb.append("\tparams:");
                for (String name : this.params.keySet()) {
                    sb.append("\t");
                    sb.append(name);
                    sb.append(":");
                    sb.append(this.params.getJoinedValue(name, ", "));
                }
            }
            return sb.toString();
        }

        @Override
        public boolean isUseRawUrl() {
            return this.useRawUrl;
        }

        static /* synthetic */ byte[] access$1302(RequestImpl x0, byte[] x1) {
            x0.byteData = x1;
            return x1;
        }
    }
}

