/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import java.util.ArrayList;
import java.util.List;
import oneapi.client.CustomerProfileClient;
import oneapi.client.impl.OneAPIBaseClientImpl;
import oneapi.config.Configuration;
import oneapi.listener.LoginListener;
import oneapi.listener.LogoutListener;
import oneapi.model.LoginRequest;
import oneapi.model.RequestData;
import oneapi.model.common.AccountBalance;
import oneapi.model.common.CustomerProfile;
import oneapi.model.common.LoginResponse;

public class CustomerProfileClientImpl
extends OneAPIBaseClientImpl
implements CustomerProfileClient {
    private static final String CUSTOMER_PROFILE_URL_BASE = "/customerProfile";
    private List<LoginListener> loginListenersList = null;
    private List<LogoutListener> logoutListenerList = null;

    public CustomerProfileClientImpl(Configuration configuration, LoginListener loginListner, LogoutListener logoutListener) {
        super(configuration);
        this.addLoginListener(loginListner);
        this.addLogoutListener(logoutListener);
    }

    @Override
    public LoginResponse login() {
        LoginRequest loginRequest = new LoginRequest(this.getConfiguration().getAuthentication().getUsername(), this.getConfiguration().getAuthentication().getPassword());
        RequestData requestData = new RequestData("/customerProfile/login", RequestData.Method.POST, "login", loginRequest, "application/json");
        LoginResponse response = this.executeMethod(requestData, LoginResponse.class);
        this.fireOnLogin(response);
        return response;
    }

    @Override
    public void logout() {
        RequestData requestData = new RequestData("/customerProfile/logout", RequestData.Method.POST);
        this.executeMethod(requestData);
        this.fireOnLogout();
    }

    @Override
    public CustomerProfile getCustomerProfile() {
        RequestData requestData = new RequestData(CUSTOMER_PROFILE_URL_BASE, RequestData.Method.GET);
        return this.executeMethod(requestData, CustomerProfile.class);
    }

    @Override
    public CustomerProfile[] getCustomerProfiles() {
        RequestData requestData = new RequestData("/customerProfile/list", RequestData.Method.GET);
        return this.executeMethod(requestData, CustomerProfile[].class);
    }

    @Override
    public CustomerProfile getCustomerProfileByUserId(int id) {
        RequestData requestData = new RequestData("/customerProfile/" + this.encodeURLParam(String.valueOf(id)), RequestData.Method.GET);
        return this.executeMethod(requestData, CustomerProfile.class);
    }

    @Override
    public AccountBalance getAccountBalance() {
        RequestData requestData = new RequestData("/customerProfile/balance", RequestData.Method.GET);
        return this.executeMethod(requestData, AccountBalance.class);
    }

    private void addLoginListener(LoginListener listener) {
        if (listener == null) {
            return;
        }
        if (this.loginListenersList == null) {
            this.loginListenersList = new ArrayList<LoginListener>();
        }
        this.loginListenersList.add(listener);
    }

    private void addLogoutListener(LogoutListener listener) {
        if (listener == null) {
            return;
        }
        if (this.logoutListenerList == null) {
            this.logoutListenerList = new ArrayList<LogoutListener>();
        }
        this.logoutListenerList.add(listener);
    }

    private void fireOnLogin(LoginResponse response) {
        if (this.loginListenersList != null) {
            for (LoginListener listener : this.loginListenersList) {
                listener.onLogin(response);
            }
        }
    }

    private void fireOnLogout() {
        if (this.logoutListenerList != null) {
            for (LogoutListener listener : this.logoutListenerList) {
                listener.onLogout();
            }
        }
    }
}

