/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import oneapi.config.Configuration;
import oneapi.exception.RequestException;
import oneapi.listener.ResponseListener;
import oneapi.model.Authentication;
import oneapi.model.RequestData;
import oneapi.model.common.RequestError;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneAPIBaseClientImpl {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OneAPIBaseClientImpl.class);
    protected static final String CHARSET = "UTF-8";
    protected static final String URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private Configuration configuration = null;
    private ObjectMapper objectMapper = null;
    private AsyncHttpClient asyncHttpClient = null;

    protected OneAPIBaseClientImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    private AsyncHttpClient getAsyncHttpClient() {
        if (this.asyncHttpClient == null) {
            this.asyncHttpClient = new AsyncHttpClient();
        }
        return this.asyncHttpClient;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return this.objectMapper;
    }

    protected <T> T executeMethod(RequestData requestData, Class<T> clazz) {
        HttpURLConnection connection = this.sendOneAPIRequest(requestData);
        return this.deserialize(connection, clazz, requestData.getRootElement());
    }

    protected void executeMethod(RequestData requestData) {
        HttpURLConnection connection = this.sendOneAPIRequest(requestData);
        this.validateResponse(connection);
    }

    protected <T> void executeMethodAsync(RequestData requestData, Class<T> clazz, ResponseListener<T> responseListener) {
        this.sendOneAPIRequestAsync(requestData, clazz, responseListener);
    }

    protected <T> T convertJSONToObject(byte[] jsonBytes, Class<T> clazz) {
        return this.convertJSONToObject(jsonBytes, clazz, null);
    }

    protected <T> T convertJSONToObject(byte[] jsonBytes, Class<T> clazz, String rootElement) {
        try {
            if (null != rootElement && !"".equals(rootElement)) {
                JsonNode node = this.getObjectMapper().reader().readTree(new ByteArrayInputStream(jsonBytes)).get(rootElement);
                return this.getObjectMapper().readValue(node.toString(), clazz);
            }
            return this.getObjectMapper().readValue(jsonBytes, clazz);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    protected String getIdFromResourceUrl(String resourceUrl) {
        String[] arrResourceUrl;
        String id = "";
        if (resourceUrl.contains("/") && (arrResourceUrl = resourceUrl.split("/")).length > 0) {
            id = arrResourceUrl[arrResourceUrl.length - 1];
        }
        return id;
    }

    protected String encodeURLParam(String param) {
        try {
            return URLEncoder.encode(param, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestException(e);
        }
    }

    private HttpURLConnection sendOneAPIRequest(RequestData requestData) {
        HttpURLConnection connection = null;
        try {
            String apiUrl = this.appendMessagingBaseUrl(requestData.getResourcePath());
            Authentication authentication = this.configuration.getAuthentication();
            if (authentication.getType().equals((Object)Authentication.AuthType.BASIC)) {
                connection = this.setupConnectionWithCustomAuthorization(apiUrl, "Basic", new String(Base64.encodeBase64((authentication.getUsername() + ":" + authentication.getPassword()).getBytes(CHARSET)), CHARSET));
            } else if (authentication.getType().equals((Object)Authentication.AuthType.OAUTH)) {
                connection = this.setupConnectionWithCustomAuthorization(apiUrl, "OAuth", authentication.getAccessToken());
            } else if (authentication.getType().equals((Object)Authentication.AuthType.IBSSO)) {
                String ibssoToken = authentication.getIbssoToken();
                connection = this.setupConnectionWithCustomAuthorization(apiUrl, "IBSSO", ibssoToken);
            }
            if (requestData.getContentType() != null && requestData.getContentType().length() != 0 && connection != null) {
                connection.setRequestProperty("Content-Type", requestData.getContentType());
            }
            if (connection != null) {
                connection.setRequestProperty("accept", "*/*");
                connection.setRequestProperty("User-Agent", "OneApi-Java-".concat("1.0.0"));
            }
            connection.setRequestMethod(requestData.getRequestMethod().toString());
            if (requestData.getFormParams() != null) {
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                if (requestData.getContentType().equals(URL_ENCODED_CONTENT_TYPE)) {
                    out.write(this.formEncodeParams(requestData.getFormParams()));
                } else if (requestData.getContentType().equals(JSON_CONTENT_TYPE)) {
                    String json = this.getObjectMapper().writeValueAsString(requestData.getFormParams());
                    out.write(json);
                }
                out.close();
            }
            return connection;
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private <T> void sendOneAPIRequestAsync(final RequestData requestData, final Class<T> clazz, final ResponseListener<T> responseListener) {
        String apiUrl = this.appendMessagingBaseUrl(requestData.getResourcePath());
        RequestBuilder requestBuilder = new RequestBuilder().setUrl(apiUrl).setMethod(requestData.getRequestMethod().toString()).addHeader("accept", "*/*").addHeader("User-Agent", "OneApi-Java-".concat("1.0.0"));
        if (requestData.getContentType().length() != 0) {
            requestBuilder.addHeader("Content-Type", requestData.getContentType());
        }
        try {
            Authentication authentication = this.configuration.getAuthentication();
            if (authentication.getType().equals((Object)Authentication.AuthType.BASIC)) {
                String basicCredentials = new String(Base64.encodeBase64((authentication.getUsername() + ":" + authentication.getPassword()).getBytes(CHARSET)), CHARSET);
                requestBuilder.addHeader("Authorization", "Basic " + basicCredentials);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Authorization type Basic using " + basicCredentials);
                }
            } else if (authentication.getType().equals((Object)Authentication.AuthType.OAUTH)) {
                String accessToken = authentication.getAccessToken();
                requestBuilder.addHeader("Authorization", "OAuth " + authentication.getAccessToken());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Authorization type OAuth using " + accessToken);
                }
            } else if (authentication.getType().equals((Object)Authentication.AuthType.IBSSO)) {
                String ibssoToken = authentication.getIbssoToken();
                requestBuilder.addHeader("Authorization", "IBSSO " + ibssoToken);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Authorization type IBSSO using " + ibssoToken);
                }
            }
            if (requestData.getFormParams() != null) {
                if (requestData.getContentType().equals(URL_ENCODED_CONTENT_TYPE)) {
                    requestBuilder.setBody(this.formEncodeParams(requestData.getFormParams()));
                } else if (requestData.getContentType().equals(JSON_CONTENT_TYPE)) {
                    String json = this.getObjectMapper().writeValueAsString(requestData.getFormParams());
                    requestBuilder.setBody(JsonStringEncoder.getInstance().encodeAsUTF8(json));
                }
            }
            this.getAsyncHttpClient().executeRequest(requestBuilder.build(), new AsyncCompletionHandler(){

                public Response onCompleted(Response response) {
                    try {
                        Object jsonObject = OneAPIBaseClientImpl.this.deserialize(response, clazz, requestData.getRootElement());
                        responseListener.onGotResponse(jsonObject, null);
                    }
                    catch (Exception e) {
                        responseListener.onGotResponse(null, e);
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    responseListener.onGotResponse(null, t);
                }
            });
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private HttpURLConnection setupConnectionWithCustomAuthorization(String url, String authorizationScheme, String authHeaderValue) throws MalformedURLException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Intitiating connection to URL: " + url);
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        if (authHeaderValue != null) {
            con.setRequestProperty("Authorization", authorizationScheme + " " + authHeaderValue);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authorization type " + authorizationScheme + " using " + authHeaderValue);
            }
        }
        return con;
    }

    private <T> T deserialize(HttpURLConnection connection, Class<T> clazz, String rootElement) {
        int responseCode = this.getResponseCode(connection);
        String contentEncoding = this.getContentEncoding(connection.getContentType());
        if (responseCode >= 200 && responseCode < 300) {
            try {
                return this.deserializeStream(connection.getInputStream(), contentEncoding, clazz, rootElement);
            }
            catch (Exception e) {
                throw new RequestException(e);
            }
        }
        throw this.readRequestException(connection.getErrorStream(), responseCode, contentEncoding);
    }

    private <T> T deserialize(Response response, Class<T> clazz, String rootElement) throws IOException {
        int responseCode = response.getStatusCode();
        InputStream inputStream = response.getResponseBodyAsStream();
        if (responseCode >= 200 && responseCode < 300) {
            T jsonObject = this.deserializeStream(inputStream, CHARSET, clazz, rootElement);
            return jsonObject;
        }
        throw this.readRequestException(inputStream, responseCode, CHARSET);
    }

    private <T> T deserializeStream(InputStream inputStream, String contentEncoding, Class<T> clazz, String rootElement) throws IOException {
        LOGGER.debug("Processing JSON Response");
        byte[] bytes = this.read(inputStream, contentEncoding);
        return this.convertJSONToObject(bytes, clazz, rootElement);
    }

    private byte[] read(InputStream inputStream, String contentEncoding) throws IOException {
        byte i;
        if (inputStream == null) {
            throw new RequestException("Unexpected error occured. Response is empty.");
        }
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        while ((i = (byte)inputStream.read()) != -1) {
            baOutputStream.write(i);
        }
        byte[] bytes = baOutputStream.toByteArray();
        LOGGER.debug("Response data: " + new String(baOutputStream.toByteArray(), contentEncoding));
        return bytes;
    }

    private RequestException readRequestException(InputStream errorStream, int responseCode, String contentEncoding) {
        LOGGER.debug("Processing RequestError JSON Response");
        String errorText = "Unexpected error occured.";
        String messageId = "";
        try {
            byte[] bytes = this.read(errorStream, contentEncoding);
            RequestError errorResponse = this.convertJSONToObject(bytes, RequestError.class, "requestError");
            if (errorResponse != null) {
                if (errorResponse.getPolicyException() != null) {
                    errorText = errorResponse.getPolicyException().getText();
                    messageId = errorResponse.getPolicyException().getMessageId();
                } else if (errorResponse.getServiceException() != null) {
                    errorText = errorResponse.getServiceException().getText();
                    messageId = errorResponse.getServiceException().getMessageId();
                }
            }
        }
        catch (Exception e) {
            return new RequestException(e, responseCode);
        }
        return new RequestException(errorText, messageId, responseCode);
    }

    private void validateResponse(HttpURLConnection connection) {
        int responseCode = this.getResponseCode(connection);
        if (responseCode < 200 || responseCode >= 300) {
            String contentEncoding = this.getContentEncoding(connection.getContentType());
            throw this.readRequestException(connection.getErrorStream(), responseCode, contentEncoding);
        }
    }

    private String formEncodeParams(Object formParams) throws IOException {
        Map formParamsMap = this.getObjectMapper().convertValue(formParams, Map.class);
        if (formParamsMap == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No request form parameters!");
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry entry : formParamsMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof ArrayList) {
                ArrayList list = (ArrayList)entry.getValue();
                for (String listItem : list) {
                    if (listItem == null) continue;
                    this.appendEncodedParam(sb, (String)entry.getKey(), listItem, i++);
                }
                continue;
            }
            this.appendEncodedParam(sb, (String)entry.getKey(), entry.getValue(), i++);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request form parameters: " + sb.toString());
        }
        return sb.toString();
    }

    private void appendEncodedParam(StringBuilder sb, String key, Object value, int paramCounter) throws UnsupportedEncodingException {
        if (paramCounter > 0) {
            sb.append("&");
        }
        sb.append(URLEncoder.encode(key, CHARSET));
        sb.append("=");
        sb.append(URLEncoder.encode(String.valueOf(value), CHARSET));
    }

    private String appendMessagingBaseUrl(String resourcePath) {
        StringBuilder urlBuilder = new StringBuilder(this.configuration.getApiUrl());
        if (!this.configuration.getApiUrl().endsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append(this.encodeURLParam(this.configuration.getVersionOneAPISMS()));
        if (!resourcePath.startsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append(resourcePath);
        return urlBuilder.toString();
    }

    private int getResponseCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    private String getContentEncoding(String contentType) {
        String contentEncoding = "";
        if (contentType != null) {
            String[] contentTypeSplited;
            for (String splitedItem : contentTypeSplited = contentType.split(";")) {
                if (!splitedItem.toLowerCase().startsWith("charset=")) continue;
                contentEncoding = splitedItem.substring("charset=".length());
            }
        }
        if (contentEncoding.length() == 0) {
            contentEncoding = CHARSET;
        }
        return contentEncoding;
    }
}

