/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import oneapi.client.USSDClient;
import oneapi.client.impl.OneAPIBaseClientImpl;
import oneapi.config.Configuration;
import oneapi.model.RequestData;
import oneapi.model.USSDRequest;
import oneapi.model.common.InboundSMSMessage;

public class USSDClientImpl
extends OneAPIBaseClientImpl
implements USSDClient {
    private static final String USSD_URL_BASE = "/ussd/outbound";

    public USSDClientImpl(Configuration configuration) {
        super(configuration);
    }

    @Override
    public InboundSMSMessage sendMessage(String address, String message) {
        RequestData requestData = new RequestData(USSD_URL_BASE, RequestData.Method.POST);
        requestData.setFormParams(new USSDRequest(address, message));
        requestData.setContentType("application/json");
        return this.executeMethod(requestData, InboundSMSMessage.class);
    }

    @Override
    public void stopSession(String address, String message) {
        RequestData requestData = new RequestData(USSD_URL_BASE, RequestData.Method.POST);
        requestData.setFormParams(new USSDRequest(address, message, true));
        requestData.setContentType("application/json");
        this.executeMethod(requestData);
    }
}

