/*
 * Decompiled with CFR 0.152.
 */
package oneapi.model.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import oneapi.model.common.PolicyException;
import oneapi.model.common.ServiceException;

public class RequestError
implements Serializable {
    private static final long serialVersionUID = -4594109872052136844L;
    public static final int SERVICEEXCEPTION = 1;
    public static final int POLICYEXCEPTION = 2;
    private String clientCorrelator = null;
    private ServiceException serviceException = null;
    private PolicyException policyException = null;
    private int exceptionType = 0;
    private int httpResponseCode = 400;

    public String getClientCorrelator() {
        return this.clientCorrelator;
    }

    public ServiceException getServiceException() {
        return this.serviceException;
    }

    public void setServiceException(ServiceException serviceException) {
        this.serviceException = serviceException;
        this.exceptionType = 1;
    }

    @JsonIgnore
    public int getExceptionType() {
        return this.exceptionType;
    }

    @JsonIgnore
    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public PolicyException getPolicyException() {
        return this.policyException;
    }

    public void setPolicyException(PolicyException policyException) {
        this.policyException = policyException;
        this.exceptionType = 2;
    }

    @JsonIgnore
    public void setExceptionType(int n) {
        this.exceptionType = n;
    }

    @JsonIgnore
    public void setHttpResponseCode(int n) {
        this.httpResponseCode = n;
    }

    public RequestError(int type, int httpResponseCode, String messageId, String clientCorrelator, String text, String ... variables) {
        if (type == 1) {
            this.serviceException = new ServiceException();
            this.serviceException.setMessageId(messageId);
            this.serviceException.setText(text);
            this.serviceException.setVariables(variables);
        } else if (type == 2) {
            this.policyException = new PolicyException();
            this.policyException.setMessageId(messageId);
            this.policyException.setText(text);
            this.policyException.setVariables(variables);
        }
        this.exceptionType = type;
        this.clientCorrelator = clientCorrelator;
        this.httpResponseCode = httpResponseCode;
    }

    public RequestError() {
    }

    public String toString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.clientCorrelator != null) {
            stringBuilder.append("clientCorrelator=");
            stringBuilder.append(this.clientCorrelator);
        }
        if (this.serviceException != null) {
            stringBuilder.append("serviceException = {");
            stringBuilder.append("messageId = ");
            stringBuilder.append(this.serviceException.getMessageId());
            stringBuilder.append(", text = ");
            stringBuilder.append(this.serviceException.getText());
            stringBuilder.append(", variables = ");
            if (this.serviceException.getVariables() != null) {
                stringBuilder.append("{");
                for (i = 0; i < this.serviceException.getVariables().length; ++i) {
                    stringBuilder.append("[");
                    stringBuilder.append(i);
                    stringBuilder.append("] = ");
                    stringBuilder.append(this.serviceException.getVariables()[i]);
                }
                stringBuilder.append("}");
            }
            stringBuilder.append("}");
        }
        if (this.policyException != null) {
            stringBuilder.append("policyException = {");
            stringBuilder.append("messageId = ");
            stringBuilder.append(this.policyException.getMessageId());
            stringBuilder.append(", text = ");
            stringBuilder.append(this.policyException.getText());
            stringBuilder.append(", variables = ");
            if (this.policyException.getVariables() != null) {
                stringBuilder.append("{");
                for (i = 0; i < this.policyException.getVariables().length; ++i) {
                    stringBuilder.append("[");
                    stringBuilder.append(i);
                    stringBuilder.append("] = ");
                    stringBuilder.append(this.policyException.getVariables()[i]);
                }
                stringBuilder.append("}");
            }
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }
}

