/*
 * Decompiled with CFR 0.152.
 */
package oneapi.model.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import oneapi.model.common.HlrResponseData;
import oneapi.model.common.RoamingType;
import oneapi.util.RoamingTypeConverter;

public class Roaming
implements Serializable {
    private static final long serialVersionUID = 6670681002831841088L;
    private String address = null;
    private String currentRoaming = null;
    private ServingMccMnc servingMccMnc = null;
    private String resourceURL = null;
    private String retrievalStatus = "Retrieved";
    private HlrResponseData extendedData;
    private String callbackData = null;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCurrentRoaming() {
        return this.currentRoaming;
    }

    public void setCurrentRoaming(String currentRoaming) {
        this.currentRoaming = currentRoaming;
    }

    @JsonIgnore
    public void setCurrentRoaming(HlrResponseData extendedData) {
        RoamingTypeConverter roamingTypeConverter = new RoamingTypeConverter(extendedData);
        RoamingType roamingType = roamingTypeConverter.convert();
        this.setCurrentRoaming(roamingType.getDescription());
        if (roamingType == RoamingType.UNKNOWN) {
            this.setRetrievalStatus("Error");
        }
    }

    public ServingMccMnc getServingMccMnc() {
        return this.servingMccMnc;
    }

    public void setServingMccMnc(ServingMccMnc servingMccMnc) {
        this.servingMccMnc = servingMccMnc;
    }

    @JsonIgnore
    public void setServingMccMnc(String mccMnc) {
        if (mccMnc != null && mccMnc.length() > 2) {
            this.servingMccMnc = new ServingMccMnc(mccMnc.substring(0, 3), mccMnc.substring(3));
        }
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    public String getRetrievalStatus() {
        return this.retrievalStatus;
    }

    public void setRetrievalStatus(String retrievalStatus) {
        this.retrievalStatus = retrievalStatus;
    }

    public HlrResponseData getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(HlrResponseData extendedData) {
        this.extendedData = extendedData;
    }

    public String getCallbackData() {
        return this.callbackData;
    }

    public void setCallbackData(String callbackData) {
        this.callbackData = callbackData;
    }

    public String toString() {
        return "Roaming {address=" + this.address + ", currentRoaming=" + this.currentRoaming + ", servingMccMnc=" + this.servingMccMnc + ", resourceURL=" + this.resourceURL + ", retrievalStatus=" + this.retrievalStatus + ", extendedData=" + this.extendedData + ", callbackData=" + this.callbackData + "}";
    }

    public static class ServingMccMnc {
        private String mcc = null;
        private String mnc = null;

        public String getMcc() {
            return this.mcc;
        }

        public String getMnc() {
            return this.mnc;
        }

        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        public void setMnc(String mnc) {
            this.mnc = mnc;
        }

        public ServingMccMnc(String mcc, String mnc) {
            this.mcc = mcc;
            this.mnc = mnc;
        }
    }
}

