/*
 * Decompiled with CFR 0.152.
 */
package oneapi.retriever;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import oneapi.client.impl.SMSMessagingClientImpl;
import oneapi.exception.RequestException;
import oneapi.listener.InboundMessageListener;
import oneapi.model.common.InboundSMSMessageList;

public class InboundMessageRetriever {
    private ScheduledExecutorService fScheduler;

    public void start(long interval, SMSMessagingClientImpl smsMessagingImpl) {
        this.stop();
        if (interval <= 0L) {
            return;
        }
        this.fScheduler = Executors.newScheduledThreadPool(1);
        PollerTask poller = new PollerTask(smsMessagingImpl);
        this.fScheduler.scheduleWithFixedDelay(poller, 2000L, interval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.fScheduler != null) {
            this.fScheduler.shutdown();
        }
    }

    private static final class PollerTask
    implements Runnable {
        private SMSMessagingClientImpl smsMessagingImpl;

        public PollerTask(SMSMessagingClientImpl smsMessagingImpl) {
            this.smsMessagingImpl = smsMessagingImpl;
        }

        @Override
        public void run() {
            List<InboundMessageListener> inboundMsglisteners = this.smsMessagingImpl.getInboundMessagePullListeners();
            if (inboundMsglisteners != null && inboundMsglisteners.size() > 0) {
                InboundSMSMessageList smsMessageList = new InboundSMSMessageList();
                Throwable error = null;
                try {
                    smsMessageList = this.smsMessagingImpl.getInboundMessages();
                }
                catch (RequestException e) {
                    error = e.getCause();
                }
                if (smsMessageList != null && smsMessageList.getInboundSMSMessage() != null && smsMessageList.getInboundSMSMessage().length > 0 || error != null) {
                    this.fireMessageRetrieved(smsMessageList, inboundMsglisteners, error);
                }
            }
        }

        private void fireMessageRetrieved(InboundSMSMessageList smsMessageList, List<InboundMessageListener> listeners, Throwable error) {
            for (InboundMessageListener listener : listeners) {
                listener.onMessageRetrieved(smsMessageList, error);
            }
        }
    }
}

