/*
 * Decompiled with CFR 0.152.
 */
package oneapi.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class EnumUtil
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static <T extends IEnumIntValue> int valueFor(T enumValue) {
        return enumValue.getValue();
    }

    public static <T extends IEnumIntValue> T enumFor(Class<T> enumClass, int i) throws IllegalArgumentException {
        IEnumIntValue[] enums;
        for (IEnumIntValue en : enums = EnumUtil.getEnumConstants(enumClass)) {
            if (en.getValue() != i) continue;
            return (T)en;
        }
        return null;
    }

    protected static <T extends IEnumIntValue> T[] getEnumConstants(Class<T> enumClass) throws IllegalArgumentException {
        IEnumIntValue[] enums = (IEnumIntValue[])enumClass.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException("enum class must be specified");
        }
        return enums;
    }

    public static <T extends IEnumIntValue> EnumMapper<T> enumMapper(Class<T> enumClass) {
        return new EnumMapper(enumClass);
    }

    public static class EnumMapper<T extends IEnumIntValue> {
        private Map<Integer, T> valueToEnumMap = new HashMap<Integer, T>();

        private EnumMapper(Class<T> enumClass) {
            for (IEnumIntValue en : EnumUtil.getEnumConstants(enumClass)) {
                int enumValue = en.getValue();
                IEnumIntValue enumInMap = (IEnumIntValue)this.valueToEnumMap.get(enumValue);
                if (enumInMap != null) continue;
                this.valueToEnumMap.put(enumValue, en);
            }
        }

        public List<T> getList() {
            return new LinkedList<T>(this.valueToEnumMap.values());
        }

        public T enumFor(int value) {
            return (T)((IEnumIntValue)this.valueToEnumMap.get(value));
        }

        public int valueFor(T enumValue) {
            return enumValue.getValue();
        }
    }

    public static interface IEnumIntValue {
        public int getValue();
    }
}

