/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import java.util.ArrayList;
import java.util.List;
import oneapi.client.HLRClient;
import oneapi.client.impl.OneAPIBaseClientImpl;
import oneapi.config.Configuration;
import oneapi.exception.RequestException;
import oneapi.listener.HLRNotificationsListener;
import oneapi.listener.ResponseListener;
import oneapi.model.RequestData;
import oneapi.model.RoamingNotification;
import oneapi.model.SubscribeToHLRDeliveryNotificationsRequest;
import oneapi.model.common.DeliveryReceiptSubscription;
import oneapi.model.common.DeliveryReportSubscription;
import oneapi.model.common.Roaming;
import oneapi.pushserver.PushServerSimulator;

public class HLRClientImpl
extends OneAPIBaseClientImpl
implements HLRClient {
    private static final String HLR_URL_BASE = "/terminalstatus/queries";
    private static final String HLR_SUBSCRIPTION_URL_BASE = "/smsmessaging/hlr/subscriptions";
    private volatile List<HLRNotificationsListener> hlrPushListenerList = null;
    private PushServerSimulator hlrPushServerSimulator;

    public HLRClientImpl(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void queryHLR(String address, String notifyURL, String clientCorrelator, String callbackData) {
        if (notifyURL == null || notifyURL.length() == 0) {
            throw new RequestException("'notifyURL' parameter is mandatory.");
        }
        StringBuilder urlBuilder = new StringBuilder(HLR_URL_BASE);
        urlBuilder.append("/roamingStatus?address=");
        urlBuilder.append(this.encodeURLParam(address));
        urlBuilder.append("&includeExtendedData=true");
        urlBuilder.append("&notifyURL=");
        urlBuilder.append(this.encodeURLParam(notifyURL));
        if (clientCorrelator != null && clientCorrelator.length() > 0) {
            urlBuilder.append("&clientCorrelator=");
            urlBuilder.append(this.encodeURLParam(clientCorrelator));
        }
        if (callbackData != null && callbackData.length() > 0) {
            urlBuilder.append("&callbackData=");
            urlBuilder.append(this.encodeURLParam(callbackData));
        }
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET);
        this.executeMethod(requestData);
    }

    @Override
    public void queryHLR(String address, String notifyURL) {
        this.queryHLR(address, notifyURL, null, null);
    }

    @Override
    public Roaming queryHLR(String address) {
        RequestData requestData = new RequestData("/terminalstatus/queries/roamingStatus?address=" + this.encodeURLParam(address) + "&includeExtendedData=true", RequestData.Method.GET, "roaming");
        return this.executeMethod(requestData, Roaming.class);
    }

    @Override
    public void queryHLRAsync(String address, ResponseListener<Roaming> responseListener) {
        RequestData requestData = new RequestData("/terminalstatus/queries/roamingStatus?address=" + this.encodeURLParam(address) + "&includeExtendedData=true", RequestData.Method.GET, "roaming");
        this.executeMethodAsync(requestData, Roaming.class, responseListener);
    }

    @Override
    public RoamingNotification convertJsonToHLRNotificationExample(String json) {
        return this.convertJSONToObject(json.getBytes(), RoamingNotification.class, "terminalRoamingStatusList");
    }

    @Override
    public String subscribeToHLRDeliveryNotifications(SubscribeToHLRDeliveryNotificationsRequest subscribeToHLRDeliveryNotificationsRequest) {
        RequestData requestData = new RequestData(HLR_SUBSCRIPTION_URL_BASE, RequestData.Method.POST, "deliveryReceiptSubscription", subscribeToHLRDeliveryNotificationsRequest, "application/json");
        DeliveryReceiptSubscription deliveryReceiptSubscription = this.executeMethod(requestData, DeliveryReceiptSubscription.class);
        return this.getIdFromResourceUrl(deliveryReceiptSubscription.getResourceURL());
    }

    @Override
    public DeliveryReportSubscription[] getHLRDeliveryNotificationsSubscriptionsById(String subscriptionId) {
        RequestData requestData = new RequestData("/smsmessaging/hlr/subscriptions/" + this.encodeURLParam(subscriptionId), RequestData.Method.GET, "deliveryReceiptSubscriptions");
        return this.executeMethod(requestData, DeliveryReportSubscription[].class);
    }

    @Override
    public void removeHLRDeliveryNotificationsSubscription(String subscriptionId) {
        RequestData requestData = new RequestData("/smsmessaging/hlr/subscriptions/" + this.encodeURLParam(subscriptionId), RequestData.Method.DELETE);
        this.executeMethod(requestData);
    }

    @Override
    public void addPushHLRNotificationsListener(HLRNotificationsListener listener) {
        if (listener == null) {
            return;
        }
        if (this.hlrPushListenerList == null) {
            this.hlrPushListenerList = new ArrayList<HLRNotificationsListener>();
        }
        this.hlrPushListenerList.add(listener);
        this.startHLRPushServerSimulator();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Listener is successfully added, push server is started and is waiting for HLR Notifications");
        }
    }

    @Override
    public List<HLRNotificationsListener> getHLRPushNotificationListeners() {
        return this.hlrPushListenerList;
    }

    @Override
    public void removePushHLRNotificationsListeners() {
        this.stopHLRPushServerSimulator();
        this.hlrPushListenerList = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("HLR Listeners are successfully removed.");
        }
    }

    private void startHLRPushServerSimulator() {
        if (this.hlrPushServerSimulator == null) {
            this.hlrPushServerSimulator = new PushServerSimulator(this, this.getConfiguration().getHlrPushServerSimulatorPort());
            this.hlrPushServerSimulator.start();
        }
    }

    private void stopHLRPushServerSimulator() {
        if (this.hlrPushServerSimulator != null) {
            this.hlrPushServerSimulator.stop();
        }
    }
}

