/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import oneapi.client.CustomerProfileClient;
import oneapi.client.HLRClient;
import oneapi.client.SMSMessagingClient;
import oneapi.client.USSDClient;
import oneapi.client.impl.CustomerProfileClientImpl;
import oneapi.client.impl.HLRClientImpl;
import oneapi.client.impl.SMSMessagingClientImpl;
import oneapi.client.impl.USSDClientImpl;
import oneapi.config.Configuration;
import oneapi.listener.LoginListener;
import oneapi.listener.LogoutListener;
import oneapi.model.Authentication;
import oneapi.model.common.LoginResponse;

public class SMSClient {
    protected static final String VERSION = "1.0.0";
    private CustomerProfileClient customerProfileClient = null;
    private SMSMessagingClient smsMessagingClient = null;
    private HLRClient hlrClient = null;
    private USSDClient ussdClient = null;
    private LoginListener loginListener = null;
    private LogoutListener logoutListener = null;
    private Configuration configuration = null;

    public SMSClient(Configuration configuration) {
        this.configuration = configuration;
        this.setLoginListener();
        this.setLogoutListener();
        this.customerProfileClient = new CustomerProfileClientImpl(configuration, this.loginListener, this.logoutListener);
        this.smsMessagingClient = new SMSMessagingClientImpl(configuration);
        this.hlrClient = new HLRClientImpl(configuration);
        this.ussdClient = new USSDClientImpl(configuration);
    }

    public CustomerProfileClient getCustomerProfileClient() {
        return this.customerProfileClient;
    }

    public SMSMessagingClient getSMSMessagingClient() {
        return this.smsMessagingClient;
    }

    public HLRClient getHLRClient() {
        return this.hlrClient;
    }

    public USSDClient getUSSDClient() {
        return this.ussdClient;
    }

    private void setLoginListener() {
        this.loginListener = new LoginListener(){

            @Override
            public void onLogin(LoginResponse response) {
                if (response != null && response.getIbAuthCookie().length() != 0) {
                    SMSClient.this.configuration.getAuthentication().setType(Authentication.AuthType.IBSSO);
                    SMSClient.this.configuration.getAuthentication().setIbssoToken(response.getIbAuthCookie());
                }
            }
        };
    }

    private void setLogoutListener() {
        this.logoutListener = new LogoutListener(){

            @Override
            public void onLogout() {
                SMSClient.this.configuration.getAuthentication().setIbssoToken("");
            }
        };
    }
}

