/*
 * Decompiled with CFR 0.152.
 */
package oneapi.client.impl;

import java.util.ArrayList;
import java.util.List;
import oneapi.client.SMSMessagingClient;
import oneapi.client.impl.OneAPIBaseClientImpl;
import oneapi.config.Configuration;
import oneapi.listener.DeliveryReportListener;
import oneapi.listener.DeliveryStatusNotificationsListener;
import oneapi.listener.InboundMessageListener;
import oneapi.listener.InboundMessageNotificationsListener;
import oneapi.listener.ResponseListener;
import oneapi.model.DeliveryInfoNotification;
import oneapi.model.DeliveryReportList;
import oneapi.model.MoNumberType;
import oneapi.model.RequestData;
import oneapi.model.SMSRequest;
import oneapi.model.SendMessageResult;
import oneapi.model.SubscribeToDeliveryNotificationsRequest;
import oneapi.model.SubscribeToInboundMessagesRequest;
import oneapi.model.common.DeliveryInfoList;
import oneapi.model.common.DeliveryReceiptSubscription;
import oneapi.model.common.DeliveryReportSubscription;
import oneapi.model.common.InboundSMSMessageList;
import oneapi.model.common.MoSubscription;
import oneapi.model.common.ResourceReference;
import oneapi.pushserver.PushServerSimulator;
import oneapi.retriever.DeliveryReportRetriever;
import oneapi.retriever.InboundMessageRetriever;

public class SMSMessagingClientImpl
extends OneAPIBaseClientImpl
implements SMSMessagingClient {
    private static final String SMS_MESSAGING_OUTBOUND_URL_BASE = "/smsmessaging/outbound";
    private static final String SMS_MESSAGING_INBOUND_URL_BASE = "/smsmessaging/inbound";
    private DeliveryReportRetriever deliveryReportRetriever = null;
    private InboundMessageRetriever inboundMessageRetriever = null;
    private volatile List<DeliveryReportListener> deliveryReportPullListenerList = null;
    private volatile List<InboundMessageListener> inboundMessagePullListenerList = null;
    private volatile List<DeliveryStatusNotificationsListener> deliveryStatusNotificationPushListenerList = null;
    private volatile List<InboundMessageNotificationsListener> inboundMessagePushListenerList = null;
    private PushServerSimulator dlrStatusPushServerSimulator;
    private PushServerSimulator inboundMessagesPushServerSimulator;

    public SMSMessagingClientImpl(Configuration configuration) {
        super(configuration);
    }

    @Override
    public SendMessageResult sendSMS(SMSRequest smsRequest) {
        RequestData requestData = new RequestData("/smsmessaging/outbound/" + this.encodeURLParam(smsRequest.getSenderAddress()) + "/requests", RequestData.Method.POST, null, smsRequest, "application/json");
        return this.executeMethod(requestData, SendMessageResult.class);
    }

    @Override
    public void sendSMSAsync(SMSRequest smsRequest, ResponseListener<SendMessageResult> responseListener) {
        RequestData requestData = new RequestData("/smsmessaging/outbound/" + this.encodeURLParam(smsRequest.getSenderAddress()) + "/requests", RequestData.Method.POST, null, smsRequest, "application/json");
        this.executeMethodAsync(requestData, SendMessageResult.class, responseListener);
    }

    @Override
    public DeliveryInfoList queryDeliveryStatus(String senderAddress, String requestId) {
        RequestData requestData = new RequestData("/smsmessaging/outbound/" + this.encodeURLParam(senderAddress) + "/requests/" + this.encodeURLParam(requestId) + "/deliveryInfos", RequestData.Method.GET, "deliveryInfoList");
        return this.executeMethod(requestData, DeliveryInfoList.class);
    }

    @Override
    public void queryDeliveryStatusAsync(String senderAddress, String requestId, ResponseListener<DeliveryInfoList> responseListener) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/");
        urlBuilder.append(this.encodeURLParam(senderAddress));
        urlBuilder.append("/requests/");
        urlBuilder.append(this.encodeURLParam(requestId));
        urlBuilder.append("/deliveryInfos");
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET, "deliveryInfoList");
        this.executeMethodAsync(requestData, DeliveryInfoList.class, responseListener);
    }

    @Override
    public DeliveryInfoNotification convertJsonToDeliveryInfoNotification(String json) {
        return this.convertJSONToObject(json.getBytes(), DeliveryInfoNotification.class, "deliveryInfoNotification");
    }

    @Override
    public String subscribeToDeliveryStatusNotifications(SubscribeToDeliveryNotificationsRequest subscribeToDeliveryNotificationsRequest) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/");
        if (null != subscribeToDeliveryNotificationsRequest.getSenderAddress()) {
            urlBuilder.append(this.encodeURLParam(subscribeToDeliveryNotificationsRequest.getSenderAddress())).append("/");
        }
        urlBuilder.append("subscriptions");
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.POST, "deliveryReceiptSubscription", subscribeToDeliveryNotificationsRequest, "application/json");
        DeliveryReceiptSubscription deliveryReceiptSubscription = this.executeMethod(requestData, DeliveryReceiptSubscription.class);
        return this.getIdFromResourceUrl(deliveryReceiptSubscription.getResourceURL());
    }

    @Override
    public DeliveryReportSubscription[] getDeliveryNotificationsSubscriptionsBySender(String senderAddress) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/");
        urlBuilder.append(this.encodeURLParam(senderAddress));
        urlBuilder.append("/subscriptions");
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET, "deliveryReceiptSubscriptions");
        return this.executeMethod(requestData, DeliveryReportSubscription[].class);
    }

    @Override
    public DeliveryReportSubscription getDeliveryNotificationsSubscriptionById(String subscriptionId) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/subscriptions/");
        urlBuilder.append(this.encodeURLParam(subscriptionId));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET, "deliveryReceiptSubscription");
        return this.executeMethod(requestData, DeliveryReportSubscription.class);
    }

    @Override
    public DeliveryReportSubscription[] getDeliveryNotificationsSubscriptions() {
        RequestData requestData = new RequestData("/smsmessaging/outbound/subscriptions", RequestData.Method.GET, "deliveryReceiptSubscriptions");
        return this.executeMethod(requestData, DeliveryReportSubscription[].class);
    }

    @Override
    public void removeDeliveryNotificationsSubscription(String subscriptionId) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/subscriptions/");
        urlBuilder.append(this.encodeURLParam(subscriptionId));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.DELETE);
        this.executeMethod(requestData);
    }

    @Override
    public InboundSMSMessageList getInboundMessages() {
        return this.getInboundMessages(100);
    }

    @Override
    public InboundSMSMessageList getInboundMessages(int maxBatchSize) {
        RequestData requestData = new RequestData("/smsmessaging/inbound/registrations/INBOUND/messages?maxBatchSize=" + this.encodeURLParam(String.valueOf(maxBatchSize)), RequestData.Method.GET, "inboundSMSMessageList");
        return this.executeMethod(requestData, InboundSMSMessageList.class);
    }

    @Override
    public void getInboundMessagesAsync(ResponseListener<InboundSMSMessageList> responseListener) {
        this.getInboundMessagesAsync(100, responseListener);
    }

    @Override
    public void getInboundMessagesAsync(int maxBatchSize, ResponseListener<InboundSMSMessageList> responseListener) {
        RequestData requestData = new RequestData("/smsmessaging/inbound/registrations/INBOUND/messages?maxBatchSize=" + this.encodeURLParam(String.valueOf(maxBatchSize)), RequestData.Method.GET, "inboundSMSMessageList");
        this.executeMethodAsync(requestData, InboundSMSMessageList.class, responseListener);
    }

    @Override
    public InboundSMSMessageList convertJsonToInboundSMSMessageNotificationExample(String json) {
        return this.convertJSONToObject(json.getBytes(), InboundSMSMessageList.class);
    }

    @Override
    public String subscribeToInboundMessagesNotifications(SubscribeToInboundMessagesRequest subscribeToInboundMessagesRequest) {
        RequestData requestData = new RequestData("/smsmessaging/inbound/subscriptions", RequestData.Method.POST, "resourceReference", subscribeToInboundMessagesRequest, "application/json");
        ResourceReference resourceReference = this.executeMethod(requestData, ResourceReference.class);
        return this.getIdFromResourceUrl(resourceReference.getResourceURL());
    }

    @Override
    public MoSubscription[] getInboundMessagesNotificationsSubscriptions(int page, int pageSize) {
        RequestData requestData = new RequestData("/smsmessaging/inbound/subscriptions?page=" + this.encodeURLParam(String.valueOf(page)) + "&pageSize=" + this.encodeURLParam(String.valueOf(pageSize)), RequestData.Method.GET, "subscriptions");
        return this.executeMethod(requestData, MoSubscription[].class);
    }

    @Override
    public MoSubscription[] getInboundMessagesNotificationsSubscriptions() {
        return this.getInboundMessagesNotificationsSubscriptions(1, 10);
    }

    @Override
    public void removeInboundMessagesSubscription(String subscriptionId) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_INBOUND_URL_BASE).append("/subscriptions/");
        urlBuilder.append(this.encodeURLParam(subscriptionId));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.DELETE);
        this.executeMethod(requestData);
    }

    @Override
    public MoNumberType[] getMoNumberTypes() {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_INBOUND_URL_BASE).append("/numberTypes");
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET, "moNoTypes");
        return this.executeMethod(requestData, MoNumberType[].class);
    }

    @Override
    public DeliveryReportList getDeliveryReports(int limit) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/requests/deliveryReports");
        urlBuilder.append("?limit=");
        urlBuilder.append(this.encodeURLParam(String.valueOf(limit)));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET);
        return this.executeMethod(requestData, DeliveryReportList.class);
    }

    @Override
    public void getDeliveryReportsAsync(int limit, ResponseListener<DeliveryReportList> responseListener) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/requests/deliveryReports");
        urlBuilder.append("?limit=");
        urlBuilder.append(this.encodeURLParam(String.valueOf(limit)));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET);
        this.executeMethodAsync(requestData, DeliveryReportList.class, responseListener);
    }

    @Override
    public DeliveryReportList getDeliveryReports() {
        return this.getDeliveryReports(0);
    }

    @Override
    public void getDeliveryReportsAsync(ResponseListener<DeliveryReportList> responseListener) {
        this.getDeliveryReportsAsync(0, responseListener);
    }

    @Override
    public DeliveryReportList getDeliveryReportsByRequestId(String requestId, int limit) {
        StringBuilder urlBuilder = new StringBuilder(SMS_MESSAGING_OUTBOUND_URL_BASE).append("/requests/");
        urlBuilder.append(this.encodeURLParam(requestId));
        urlBuilder.append("/deliveryReports");
        urlBuilder.append("?limit=");
        urlBuilder.append(this.encodeURLParam(String.valueOf(limit)));
        RequestData requestData = new RequestData(urlBuilder.toString(), RequestData.Method.GET);
        return this.executeMethod(requestData, DeliveryReportList.class);
    }

    @Override
    public DeliveryReportList getDeliveryReportsByRequestId(String requestId) {
        return this.getDeliveryReportsByRequestId(requestId, 0);
    }

    @Override
    public void addPullDeliveryReportListener(DeliveryReportListener listener) {
        if (listener == null) {
            return;
        }
        if (this.deliveryReportPullListenerList == null) {
            this.deliveryReportPullListenerList = new ArrayList<DeliveryReportListener>();
        }
        this.deliveryReportPullListenerList.add(listener);
        this.startDeliveryReportRetriever();
    }

    @Override
    public void addPullInboundMessageListener(InboundMessageListener listener) {
        if (listener == null) {
            return;
        }
        if (this.inboundMessagePullListenerList == null) {
            this.inboundMessagePullListenerList = new ArrayList<InboundMessageListener>();
        }
        this.inboundMessagePullListenerList.add(listener);
        this.startInboundMessageRetriever();
    }

    @Override
    public List<InboundMessageListener> getInboundMessagePullListeners() {
        return this.inboundMessagePullListenerList;
    }

    @Override
    public List<DeliveryReportListener> getDeliveryReportPullListeners() {
        return this.deliveryReportPullListenerList;
    }

    @Override
    public void removePullDeliveryReportListeners() {
        this.stopDeliveryReportRetriever();
        this.deliveryReportPullListenerList = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("PULL Delivery Report Listeners are successfully released.");
        }
    }

    @Override
    public void removePullInboundMessageListeners() {
        this.stopInboundMessagesRetriever();
        this.inboundMessagePullListenerList = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("PULL Inbound Message Listeners are successfully released.");
        }
    }

    @Override
    public void addPushDeliveryStatusNotificationListener(DeliveryStatusNotificationsListener listener) {
        if (listener == null) {
            return;
        }
        if (this.deliveryStatusNotificationPushListenerList == null) {
            this.deliveryStatusNotificationPushListenerList = new ArrayList<DeliveryStatusNotificationsListener>();
        }
        this.deliveryStatusNotificationPushListenerList.add(listener);
        this.StartDlrStatusPushServerSimulator();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Listener is successfully added, push server is started and is waiting for Delivery Status Notifications");
        }
    }

    @Override
    public void addPushInboundMessageListener(InboundMessageNotificationsListener listener) {
        if (listener == null) {
            return;
        }
        if (this.inboundMessagePushListenerList == null) {
            this.inboundMessagePushListenerList = new ArrayList<InboundMessageNotificationsListener>();
        }
        this.inboundMessagePushListenerList.add(listener);
        this.startInboundMessagesPushServerSimulator();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Listener is successfully added, push server is started and is waiting for Inbound Messages Notifications");
        }
    }

    @Override
    public List<DeliveryStatusNotificationsListener> getDeliveryStatusNotificationPushListeners() {
        return this.deliveryStatusNotificationPushListenerList;
    }

    @Override
    public List<InboundMessageNotificationsListener> getInboundMessagePushListeners() {
        return this.inboundMessagePushListenerList;
    }

    @Override
    public void removePushDeliveryStatusNotificationListeners() {
        this.stopDlrStatusPushServerSimulator();
        this.deliveryStatusNotificationPushListenerList = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Delivery Status Notification Listeners are successfully removed.");
        }
    }

    @Override
    public void removePushInboundMessageListeners() {
        this.stopInboundMessagesPushServerSimulator();
        this.inboundMessagePushListenerList = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Inbound Message Listeners are successfully removed.");
        }
    }

    private void startDeliveryReportRetriever() {
        if (this.deliveryReportRetriever != null) {
            return;
        }
        this.deliveryReportRetriever = new DeliveryReportRetriever();
        int intervalMs = this.getConfiguration().getDlrRetrievingInterval();
        this.deliveryReportRetriever.start(intervalMs, this);
    }

    private void stopDeliveryReportRetriever() {
        if (this.deliveryReportRetriever == null) {
            return;
        }
        this.deliveryReportRetriever.stop();
        this.deliveryReportRetriever = null;
    }

    private void startInboundMessageRetriever() {
        if (this.inboundMessageRetriever != null) {
            return;
        }
        this.inboundMessageRetriever = new InboundMessageRetriever();
        int intervalMs = this.getConfiguration().getInboundMessagesRetrievingInterval();
        this.inboundMessageRetriever.start(intervalMs, this);
    }

    private void stopInboundMessagesRetriever() {
        if (this.inboundMessageRetriever == null) {
            return;
        }
        this.inboundMessageRetriever.stop();
        this.inboundMessageRetriever = null;
    }

    private void StartDlrStatusPushServerSimulator() {
        if (this.dlrStatusPushServerSimulator == null) {
            this.dlrStatusPushServerSimulator = new PushServerSimulator(this, this.getConfiguration().getDlrStatusPushServerSimulatorPort());
            this.dlrStatusPushServerSimulator.start();
        }
    }

    private void stopDlrStatusPushServerSimulator() {
        if (this.dlrStatusPushServerSimulator != null) {
            this.dlrStatusPushServerSimulator.stop();
        }
    }

    private void startInboundMessagesPushServerSimulator() {
        if (this.inboundMessagesPushServerSimulator == null) {
            this.inboundMessagesPushServerSimulator = new PushServerSimulator(this, this.getConfiguration().getInboundMessagesPushServerSimulatorPort());
            this.inboundMessagesPushServerSimulator.start();
        }
    }

    private void stopInboundMessagesPushServerSimulator() {
        if (this.inboundMessagesPushServerSimulator != null) {
            this.inboundMessagesPushServerSimulator.stop();
        }
    }
}

