/*
 * Decompiled with CFR 0.152.
 */
package oneapi.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import oneapi.exception.ConfigurationException;
import oneapi.model.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static final String DEFAULT_CONFIG_FILE = "etc/client.cfg";
    private static final String CONFIG_FILE_SYSTEM_PROPERTY = "sms.client.config";
    private Authentication authentication = new Authentication();
    private String apiUrl = "https://oneapi.infobip.com";
    private String versionOneAPISMS = "1";
    private int inboundMessagesRetrievingInterval = 5000;
    private int dlrRetrievingInterval = 5000;
    private int dlrStatusPushServerSimulatorPort = 3000;
    private int inboundMessagesPushServerSimulatorPort = 3001;
    private int hlrPushServerSimulatorPort = 3002;

    public Configuration() {
    }

    public Configuration(boolean loadFromFile) {
        if (loadFromFile) {
            this.load();
        }
    }

    public Configuration(String username, String password) {
        this.authentication.setUsername(username);
        this.authentication.setPassword(password);
        this.authentication.setType(Authentication.AuthType.BASIC);
    }

    public Configuration(String accessToken) {
        this.authentication.setAccessToken(accessToken);
        this.authentication.setType(Authentication.AuthType.OAUTH);
    }

    public Configuration(String messagingBaseUrl, String versionOneAPISMS, String username, String password) {
        this(username, password);
        this.apiUrl = messagingBaseUrl;
        this.versionOneAPISMS = versionOneAPISMS;
    }

    public Configuration(String messagingBaseUrl, String versionOneAPISMS, String accessToken) {
        this(accessToken);
        this.apiUrl = messagingBaseUrl;
        this.versionOneAPISMS = versionOneAPISMS;
    }

    public void load() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            String configFileName = System.getProperty(CONFIG_FILE_SYSTEM_PROPERTY, DEFAULT_CONFIG_FILE);
            Configuration tmpConfig = (Configuration)mapper.readValue(new File(configFileName), Configuration.class);
            this.authentication = tmpConfig.authentication;
            this.apiUrl = tmpConfig.apiUrl;
            this.versionOneAPISMS = tmpConfig.versionOneAPISMS;
            this.inboundMessagesRetrievingInterval = tmpConfig.inboundMessagesRetrievingInterval;
            this.dlrRetrievingInterval = tmpConfig.dlrRetrievingInterval;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Data successfully loaded from '{}' configuration file.", (Object)configFileName);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void save() {
        try {
            String configFileName = System.getProperty(CONFIG_FILE_SYSTEM_PROPERTY, "client.cfg");
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(new File(configFileName), (Object)this);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Data successfully saved to '{}' configuration file.", (Object)configFileName);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication value) {
        this.authentication = value;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getVersionOneAPISMS() {
        return this.versionOneAPISMS;
    }

    public void setVersionOneAPISMS(String versionOneAPISMS) {
        this.versionOneAPISMS = versionOneAPISMS;
    }

    public int getInboundMessagesRetrievingInterval() {
        return this.inboundMessagesRetrievingInterval;
    }

    public void setInboundMessagesRetrievingInterval(int inboundMessagesRetrievingInterval) {
        this.inboundMessagesRetrievingInterval = inboundMessagesRetrievingInterval;
    }

    public int getDlrRetrievingInterval() {
        return this.dlrRetrievingInterval;
    }

    public void setDlrRetrievingInterval(int dlrRetrievingInterval) {
        this.dlrRetrievingInterval = dlrRetrievingInterval;
    }

    public int getDlrStatusPushServerSimulatorPort() {
        return this.dlrStatusPushServerSimulatorPort;
    }

    public void setDlrStatusPushServerSimulatorPort(int dlrStatusPushServerSimulatorPort) {
        this.dlrStatusPushServerSimulatorPort = dlrStatusPushServerSimulatorPort;
    }

    public int getInboundMessagesPushServerSimulatorPort() {
        return this.inboundMessagesPushServerSimulatorPort;
    }

    public void setInboundMessagesPushServerSimulatorPort(int inboundMessagesPushServerSimulatorPort) {
        this.inboundMessagesPushServerSimulatorPort = inboundMessagesPushServerSimulatorPort;
    }

    public int getHlrPushServerSimulatorPort() {
        return this.hlrPushServerSimulatorPort;
    }

    public void setHlrPushServerSimulatorPort(int hlrPushServerSimulatorPort) {
        this.hlrPushServerSimulatorPort = hlrPushServerSimulatorPort;
    }
}

