/*
 * Decompiled with CFR 0.152.
 */
package oneapi.pushserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import oneapi.client.impl.HLRClientImpl;
import oneapi.client.impl.SMSMessagingClientImpl;
import oneapi.model.DeliveryInfoNotification;
import oneapi.model.RoamingNotification;
import oneapi.model.common.InboundSMSMessageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushServerSimulator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PushServerSimulator.class);
    private ServerSocket server;
    private SMSMessagingClientImpl smsMessagingImpl = null;
    private HLRClientImpl hlrClientImpl = null;
    protected int port;
    private boolean running = false;

    public PushServerSimulator(SMSMessagingClientImpl smsMessagingImpl, int port) {
        this.smsMessagingImpl = smsMessagingImpl;
        this.port = port;
    }

    public PushServerSimulator(HLRClientImpl hlrClientImpl, int port) {
        this.hlrClientImpl = hlrClientImpl;
        this.port = port;
    }

    public void start() {
        if (!this.running) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block21: {
                        try {
                            if (PushServerSimulator.this.server == null) {
                                PushServerSimulator.this.server = new ServerSocket(PushServerSimulator.this.port);
                                PushServerSimulator.this.running = true;
                                if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info("Push Server Simulator is successfully started on port " + PushServerSimulator.this.port);
                                }
                            }
                        }
                        catch (IOException e) {
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.error("Error occured while trying to start Push Server Simulator on port " + String.valueOf(PushServerSimulator.this.port) + ". Message: " + e.getMessage());
                            }
                            PushServerSimulator.this.running = false;
                        }
                        while (PushServerSimulator.this.running) {
                            Socket connection = null;
                            try {
                                connection = PushServerSimulator.this.server.accept();
                                String request = PushServerSimulator.this.getRequest(connection);
                                int postlen = PushServerSimulator.this.parseContentLength(request);
                                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                                char[] posted = new char[postlen];
                                in.read(posted, 0, postlen);
                                String postRequest = new String(posted);
                                in.close();
                                PushServerSimulator.this.processRequestData(postRequest);
                            }
                            catch (IOException ex) {
                                if (!LOGGER.isErrorEnabled()) continue;
                                LOGGER.error("Error occured. Message: " + ex.getMessage());
                            }
                            finally {
                                if (connection == null) continue;
                                try {
                                    connection.close();
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isErrorEnabled()) continue;
                                    LOGGER.error("Error occured while trying to close Push Server Simulator connection on port " + String.valueOf(PushServerSimulator.this.port) + ". Message: " + e.getMessage());
                                }
                            }
                        }
                        try {
                            if (PushServerSimulator.this.server != null && !PushServerSimulator.this.server.isClosed()) {
                                PushServerSimulator.this.server.close();
                                if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info("Push Server Simulator on port " + String.valueOf(PushServerSimulator.this.port) + " is successfully stopped.");
                                }
                            }
                        }
                        catch (IOException e) {
                            if (!LOGGER.isErrorEnabled()) break block21;
                            LOGGER.error("Error occured while trying to stop Push Server Simulator on port " + String.valueOf(PushServerSimulator.this.port) + ". Message: " + e.getMessage());
                        }
                    }
                }
            });
            t.start();
        }
    }

    private void processRequestData(String json) {
        block4: {
            block5: {
                block6: {
                    if (json.trim().length() == 0) break block4;
                    if (this.smsMessagingImpl == null) break block5;
                    if (!json.contains("deliveryInfoNotification")) break block6;
                    DeliveryInfoNotification deliveryInfoNotification = this.smsMessagingImpl.convertJsonToDeliveryInfoNotification(json);
                    if (this.smsMessagingImpl.getDeliveryStatusNotificationPushListeners() == null) break block4;
                    for (int i = 0; i < this.smsMessagingImpl.getDeliveryStatusNotificationPushListeners().size(); ++i) {
                        this.smsMessagingImpl.getDeliveryStatusNotificationPushListeners().get(i).onDeliveryStatusNotificationReceived(deliveryInfoNotification);
                    }
                    break block4;
                }
                if (!json.contains("inboundSMSMessage") || this.smsMessagingImpl == null || this.smsMessagingImpl.getInboundMessagePushListeners() == null) break block4;
                InboundSMSMessageList smsMessagesList = this.smsMessagingImpl.convertJsonToInboundSMSMessageNotificationExample(json);
                for (int i = 0; i < this.smsMessagingImpl.getInboundMessagePushListeners().size(); ++i) {
                    this.smsMessagingImpl.getInboundMessagePushListeners().get(i).onMessageReceived(smsMessagesList);
                }
                break block4;
            }
            if (this.hlrClientImpl != null && json.contains("terminalRoamingStatusList") && this.hlrClientImpl.getHLRPushNotificationListeners() != null) {
                RoamingNotification roamingNotification = this.hlrClientImpl.convertJsonToHLRNotificationExample(json);
                for (int i = 0; i < this.hlrClientImpl.getHLRPushNotificationListeners().size(); ++i) {
                    this.hlrClientImpl.getHLRPushNotificationListeners().get(i).OnHLRReceived(roamingNotification);
                }
            }
        }
    }

    private int parseContentLength(String request) {
        int position = request.indexOf("Content-Length:");
        if (position == -1) {
            return 0;
        }
        String contentLength = request.substring(position);
        contentLength = contentLength.split(" ")[1];
        contentLength = contentLength.split("\r\n")[0];
        return Integer.valueOf(contentLength);
    }

    private String getRequest(Socket connection) throws IOException {
        int i;
        InputStream in = connection.getInputStream();
        StringBuilder request = new StringBuilder();
        while ((i = in.read()) != -1) {
            request.append((char)i);
            if (!request.toString().endsWith("\r\n\r\n") && !request.toString().endsWith("\n\n")) continue;
            return request.toString();
        }
        return request.toString();
    }

    public void stop() {
        this.running = false;
    }
}

