/*
 * Decompiled with CFR 0.152.
 */
package oneapi.retriever;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import oneapi.client.impl.SMSMessagingClientImpl;
import oneapi.exception.RequestException;
import oneapi.listener.DeliveryReportListener;
import oneapi.model.DeliveryReportList;

public class DeliveryReportRetriever {
    private ScheduledExecutorService fScheduler;

    public void start(long interval, SMSMessagingClientImpl smsMessagingImpl) {
        this.stop();
        if (interval <= 0L) {
            return;
        }
        this.fScheduler = Executors.newScheduledThreadPool(1);
        PollerTask poller = new PollerTask(smsMessagingImpl);
        this.fScheduler.scheduleWithFixedDelay(poller, 2000L, interval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.fScheduler != null) {
            this.fScheduler.shutdown();
        }
    }

    private static final class PollerTask
    implements Runnable {
        private SMSMessagingClientImpl smsMessagingImpl;

        public PollerTask(SMSMessagingClientImpl smsMessagingImpl) {
            this.smsMessagingImpl = smsMessagingImpl;
        }

        @Override
        public void run() {
            List<DeliveryReportListener> dlrStatusListeners = this.smsMessagingImpl.getDeliveryReportPullListeners();
            if (dlrStatusListeners != null && dlrStatusListeners.size() > 0) {
                DeliveryReportList deliveryReportList = null;
                Throwable error = null;
                try {
                    deliveryReportList = this.smsMessagingImpl.getDeliveryReports();
                }
                catch (RequestException e) {
                    error = e.getCause();
                }
                if (deliveryReportList != null && deliveryReportList.getDeliveryReports() != null && deliveryReportList.getDeliveryReports().length > 0 || error != null) {
                    this.fireReportRetrieved(deliveryReportList, dlrStatusListeners, error);
                }
            }
        }

        private void fireReportRetrieved(DeliveryReportList deliveryReportList, List<DeliveryReportListener> listeners, Throwable error) {
            for (DeliveryReportListener listener : listeners) {
                listener.onDeliveryReportReceived(deliveryReportList, error);
            }
        }
    }
}

