/*
 * Decompiled with CFR 0.152.
 */
package oneapi.util;

import oneapi.model.common.HlrResponseData;
import oneapi.model.common.RoamingType;

public class RoamingTypeConverter {
    private HlrResponseData hlrData;

    public RoamingTypeConverter(HlrResponseData hlrData) {
        this.hlrData = hlrData;
    }

    public RoamingType convert() {
        if (this.hlrData.getNumberInRoaming() != null) {
            if (!this.hlrData.getNumberInRoaming().booleanValue()) {
                return RoamingType.NOT_ROAMING;
            }
            return RoamingType.INTERNATIONAL_ROAMING;
        }
        Boolean isInternationalRoaming = this.isInternationalRoaming();
        if (isInternationalRoaming == null) {
            return RoamingType.UNKNOWN;
        }
        if (isInternationalRoaming.booleanValue()) {
            return RoamingType.INTERNATIONAL_ROAMING;
        }
        Boolean isDomesticRoaming = this.isDomesticRoaming();
        RoamingType ret = RoamingType.UNKNOWN;
        if (isDomesticRoaming == null) {
            ret = RoamingType.UNKNOWN;
        } else if (isDomesticRoaming.booleanValue()) {
            ret = RoamingType.DOMESTIC_ROAMING;
        } else if (!isDomesticRoaming.booleanValue()) {
            ret = RoamingType.NOT_ROAMING;
        }
        return ret;
    }

    private Boolean isInternationalRoaming() {
        Boolean ret = this.compare(this.hlrData.getRoamingCountryCode(), this.hlrData.getPortedCountryCode());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingCountryPrefix(), this.hlrData.getPortedCountryPrefix());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingCountryName(), this.hlrData.getPortedCountryName());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingCountryCode(), this.hlrData.getOriginalCountryCode());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingCountryPrefix(), this.hlrData.getOriginalCountryPrefix());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingMcc(), this.hlrData.getMcc());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingCountryName(), this.hlrData.getOriginalCountryName());
        if (ret != null) {
            return ret == false;
        }
        return null;
    }

    private Boolean isDomesticRoaming() {
        Boolean ret = this.compare(this.hlrData.getRoamingNetworkPrefix(), this.hlrData.getPortedNetworkPrefix());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingNetworkName(), this.hlrData.getPortedNetworkName());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingNetworkServiceProviderId(), this.hlrData.getPortedNetworkServiceProviderId());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingMnc(), this.hlrData.getMnc());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingNetworkPrefix(), this.hlrData.getOriginalNetworkPrefix());
        if (ret != null) {
            return ret == false;
        }
        ret = this.compare(this.hlrData.getRoamingNetworkName(), this.hlrData.getOriginalNetworkName());
        if (ret != null) {
            return ret == false;
        }
        return null;
    }

    private Boolean compare(String a, String b) {
        if (a == null || b == null) {
            return null;
        }
        return a.equalsIgnoreCase(b);
    }

    private Boolean compare(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a.equals(b);
    }
}

