/*
 * Decompiled with CFR 0.152.
 */
package oneapi.examples.smsmessaging;

import oneapi.PropertyLoader;
import oneapi.client.impl.SMSClient;
import oneapi.config.Configuration;
import oneapi.listener.DeliveryReportListener;
import oneapi.model.DeliveryReportList;
import oneapi.model.SMSRequest;
import org.apache.log4j.BasicConfigurator;

public class SendSMS_GetDeliveryReportsUsingRetriever {
    private static final String USERNAME = PropertyLoader.loadProperty("example.properties", "username");
    private static final String PASSWORD = PropertyLoader.loadProperty("example.properties", "password");
    private static String SENDER = PropertyLoader.loadProperty("example.properties", "sender");
    private static final String DESTINATION = PropertyLoader.loadProperty("example.properties", "destination");
    private static final String MESSAGE = PropertyLoader.loadProperty("example.properties", "message");

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Configuration configuration = new Configuration(USERNAME, PASSWORD);
        SMSClient smsClient = new SMSClient(configuration);
        smsClient.getSMSMessagingClient().addPullDeliveryReportListener(new DeliveryReportListener(){

            public void onDeliveryReportReceived(DeliveryReportList deliveryReportList, Throwable error) {
                if (error == null) {
                    System.out.println(deliveryReportList);
                } else {
                    System.out.println(error.getMessage());
                }
            }
        });
        smsClient.getSMSMessagingClient().sendSMS(new SMSRequest(SENDER, MESSAGE, new String[]{DESTINATION}));
        Thread.sleep(30000L);
        smsClient.getSMSMessagingClient().removePullDeliveryReportListeners();
    }
}

