/*
 * Decompiled with CFR 0.152.
 */
package org.infodancer.sitemap;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.infodancer.sitemap.ChangeFreq;

public class SitemapEntry {
    Long id;
    String url;
    Float priority;
    Date modified;
    ChangeFreq changeFreq;

    public SitemapEntry(String url) {
        this.url = url;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Float getPriority() {
        return this.priority;
    }

    public void setPriority(Float priority) {
        this.priority = priority;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public ChangeFreq getChangeFreq() {
        return this.changeFreq;
    }

    public void setChangeFreq(ChangeFreq freq) {
        this.changeFreq = freq;
    }

    public void calculateChangeFreq() {
        if (this.modified != null) {
            long updated;
            long current = System.currentTimeMillis();
            long hours = (current - (updated = this.modified.getTime())) / 1000L / 60L / 60L;
            this.changeFreq = hours < 2L ? ChangeFreq.HOURLY : (hours < 24L ? ChangeFreq.DAILY : (hours < 168L ? ChangeFreq.WEEKLY : (hours < 720L ? ChangeFreq.MONTHLY : ChangeFreq.YEARLY)));
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<url>\n");
        s.append("<loc>");
        s.append(this.url);
        s.append("</loc>\n");
        if (this.modified != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            s.append("<lastmod>");
            s.append(format.format(this.modified));
            s.append("</lastmod>\n");
        }
        if (this.changeFreq != null) {
            s.append("<changefreq>");
            switch (this.changeFreq) {
                case ALWAYS: {
                    s.append("always");
                    break;
                }
                case HOURLY: {
                    s.append("hourly");
                    break;
                }
                case DAILY: {
                    s.append("daily");
                    break;
                }
                case WEEKLY: {
                    s.append("weekly");
                    break;
                }
                case MONTHLY: {
                    s.append("monthly");
                    break;
                }
                case YEARLY: {
                    s.append("yearly");
                    break;
                }
                case NEVER: {
                    s.append("never");
                }
            }
            s.append("</changefreq>\n");
        }
        if (this.priority != null) {
            s.append("<priority>");
            s.append(Float.toString(this.priority.floatValue()));
            s.append("</priority>\n");
        }
        s.append("</url>\n");
        return s.toString();
    }
}

