/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.cdi;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.cdi.Injectors;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;

public class InjectorsTest {

    public static class InstanceSupport {
        private final Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);

        @Test
        void shouldSupportInstanceProvider() throws Exception {
            Instance numbers = (Instance)this.injector.getInstance((Type)Types.parameterize(Instance.class, (Type[])new Type[]{Number.class}), new Object[0]);
            Assertions.assertThatThrownBy(() -> numbers.destroy(null)).isExactlyInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> numbers.getHandle()).isExactlyInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> numbers.handles()).isExactlyInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThat((boolean)numbers.isAmbiguous()).isFalse();
            Assertions.assertThat((boolean)numbers.isResolvable()).isFalse();
            Assertions.assertThat((boolean)numbers.isUnsatisfied()).isTrue();
            Assertions.assertThatThrownBy(() -> numbers.get()).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
            Assertions.assertThat((Iterator)numbers.iterator()).isExhausted();
            this.injector.registerInstance((Object)42, new Annotation[0]);
            Assertions.assertThat((boolean)numbers.isAmbiguous()).isFalse();
            Assertions.assertThat((boolean)numbers.isResolvable()).isTrue();
            Assertions.assertThat((boolean)numbers.isUnsatisfied()).isFalse();
            Assertions.assertThat((Object)((Number)numbers.get())).isEqualTo((Object)42);
            Assertions.assertThat((Iterator)numbers.iterator()).toIterable().containsExactlyInAnyOrder((Object[])new Number[]{42});
            this.injector.registerInstance((Object)84, new Annotation[0]);
            Assertions.assertThat((boolean)numbers.isAmbiguous()).isTrue();
            Assertions.assertThat((boolean)numbers.isResolvable()).isFalse();
            Assertions.assertThat((boolean)numbers.isUnsatisfied()).isFalse();
            Assertions.assertThatThrownBy(() -> numbers.get()).isExactlyInstanceOf(AmbiguousResolutionException.class);
            Assertions.assertThat((Iterator)numbers.iterator()).toIterable().containsExactlyInAnyOrder((Object[])new Number[]{42, 84});
        }

        @Test
        void shouldSupportSelectWithInstanceProvider() throws Exception {
            Instance numbers = (Instance)this.injector.getInstance((Type)Types.parameterize(Instance.class, (Type[])new Type[]{Number.class}), new Object[0]);
            this.injector.registerInstance((Object)1, new Annotation[0]);
            this.injector.registerInstance((Object)2, new Annotation[]{Annotations.of(Red.class)});
            this.injector.registerInstance((Object)3, new Annotation[]{Annotations.of(Green.class)});
            this.injector.registerInstance((Object)0.0, new Annotation[0]);
            this.injector.registerInstance((Object)0.1, new Annotation[]{Annotations.of(Red.class)});
            this.injector.registerInstance((Object)0.2, new Annotation[0]);
            Instance redNumbers = numbers.select(new Annotation[]{Annotations.of(Red.class)});
            Assertions.assertThat((boolean)redNumbers.isAmbiguous()).isTrue();
            Assertions.assertThat((boolean)redNumbers.isResolvable()).isFalse();
            Assertions.assertThat((boolean)redNumbers.isUnsatisfied()).isFalse();
            Assertions.assertThatThrownBy(() -> redNumbers.get()).isExactlyInstanceOf(AmbiguousResolutionException.class);
            Assertions.assertThat((Iterator)redNumbers.iterator()).toIterable().containsExactlyInAnyOrder((Object[])new Number[]{2, 0.1});
            Instance redIntegers = redNumbers.select(Integer.TYPE, new Annotation[0]);
            Assertions.assertThat((boolean)redIntegers.isAmbiguous()).isFalse();
            Assertions.assertThat((boolean)redIntegers.isResolvable()).isTrue();
            Assertions.assertThat((boolean)redIntegers.isUnsatisfied()).isFalse();
            Assertions.assertThat((Integer)((Integer)redIntegers.get())).isEqualTo(2);
            Assertions.assertThat((Iterator)redIntegers.iterator()).toIterable().containsExactlyInAnyOrder((Object[])new Integer[]{2});
            Instance doubles = numbers.select((TypeLiteral)new TypeLiteral<Double>(){}, new Annotation[0]);
            Assertions.assertThat((boolean)doubles.isAmbiguous()).isTrue();
            Assertions.assertThat((boolean)doubles.isResolvable()).isFalse();
            Assertions.assertThat((boolean)doubles.isUnsatisfied()).isFalse();
            Assertions.assertThatThrownBy(() -> doubles.get()).isExactlyInstanceOf(AmbiguousResolutionException.class);
            Assertions.assertThat((Iterator)doubles.iterator()).toIterable().containsExactlyInAnyOrder((Object[])new Double[]{0.0, 0.1, 0.2});
            Instance greenDoubles = doubles.select(new Annotation[]{Annotations.of(Green.class)});
            Assertions.assertThat((boolean)greenDoubles.isAmbiguous()).isFalse();
            Assertions.assertThat((boolean)greenDoubles.isResolvable()).isFalse();
            Assertions.assertThat((boolean)greenDoubles.isUnsatisfied()).isTrue();
            Assertions.assertThatThrownBy(() -> greenDoubles.get()).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
            Assertions.assertThat((Iterator)greenDoubles.iterator()).isExhausted();
        }

        @Test
        void shouldRejectIllegalSelects() throws Exception {
            Instance numbers = (Instance)this.injector.getInstance((Type)Types.parameterize(Instance.class, (Type[])new Type[]{Number.class}), new Object[0]);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> numbers.select(new Annotation[]{Annotations.of(Singleton.class)})).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("@jakarta.inject.Singleton() is not a qualifier annotation").hasNoSuppressedExceptions().hasNoCause();
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        static @interface Green {
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        static @interface Red {
        }
    }

    public static class ScopeAnnotationSupport {
        private static String currentRequestScope;
        private final Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[]{new AbstractScopeResolver<String>(){

            public Annotation getAnnotation() {
                return Annotations.of(RequestScoped.class);
            }

            protected String getCurrentScope() {
                return currentRequestScope;
            }
        }});

        @Test
        void shouldInjectProxyIntoDependentTargetForNormalScopeSource() throws Exception {
            this.injector.register(A.class);
            this.injector.register(B.class);
            B b = (B)this.injector.getInstance(B.class, new Object[0]);
            Assertions.assertThatThrownBy(() -> this.injector.getInstance(A.class, new Object[0])).isExactlyInstanceOf(ScopeNotActiveException.class);
            Assertions.assertThat((Object)b.a).isNotNull();
            Assertions.assertThatThrownBy(() -> b.a.getScopeNameAtCreation()).isExactlyInstanceOf(ScopeNotActiveException.class);
            currentRequestScope = "1";
            Assertions.assertThat((String)b.a.getScopeNameAtCreation()).isEqualTo("1");
            currentRequestScope = "2";
            Assertions.assertThat((String)b.a.getScopeNameAtCreation()).isEqualTo("2");
        }

        public static class B {
            @Inject
            A a;
        }

        @RequestScoped
        public static class A {
            private final String scopeNameAtCreation = currentRequestScope;

            public String getScopeNameAtCreation() {
                return this.scopeNameAtCreation;
            }
        }
    }

    public static class ProducesAnnotationSupport {
        private final Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);

        @Test
        void shouldSupportProducesAnnotation() throws Exception {
            this.injector.register(A.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(B.class, new Object[0]));
        }

        public static class B {
        }

        public static class A {
            @Produces
            B b = new B();
        }
    }

    public static class AnnotationsSupport {
        private final Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);

        @Test
        void shouldAddStandardAnnotationsToUnannotatedSource() throws Exception {
            this.injector.registerInstance((Object)"A", new Annotation[0]);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Default.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Any.class})).hasSize(1);
            this.injector.removeInstance((Object)"A", new Annotation[0]);
        }

        @Test
        void shouldAddStandardAnnotationToSourceAnnotatedOnlyWithDefault() throws Exception {
            this.injector.registerInstance((Object)"A", new Annotation[]{Annotations.of(Default.class)});
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Default.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Any.class})).hasSize(1);
            this.injector.removeInstance((Object)"A", new Annotation[]{Annotations.of(Default.class)});
        }

        @Test
        void shouldAddStandardAnnotationToSourceAnnotatedOnlyWithAny() throws Exception {
            this.injector.registerInstance((Object)"A", new Annotation[]{Annotations.of(Any.class)});
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Default.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Any.class})).hasSize(1);
            this.injector.removeInstance((Object)"A", new Annotation[]{Annotations.of(Any.class)});
        }

        @Test
        void shouldAddStandardAnnotationToSourceAnnotatedOnlyWithNamed() throws Exception {
            Named namedAnnotation = (Named)Annotations.of(Named.class, Map.of("value", "ord"));
            this.injector.registerInstance((Object)"A", new Annotation[]{namedAnnotation});
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Default.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Any.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{namedAnnotation})).hasSize(1);
            this.injector.removeInstance((Object)"A", new Annotation[]{namedAnnotation});
        }

        @Test
        void shouldAddStandardAnnotationToSourceAnnotateWithNamedAndAny() throws Exception {
            Named namedAnnotation = (Named)Annotations.of(Named.class, Map.of("value", "ord"));
            this.injector.registerInstance((Object)"A", new Annotation[]{namedAnnotation, Annotations.of(Any.class)});
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Default.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{Any.class})).hasSize(1);
            Assertions.assertThat((List)this.injector.getInstances(Object.class, new Object[]{namedAnnotation})).hasSize(1);
            this.injector.removeInstance((Object)"A", new Annotation[]{namedAnnotation, Annotations.of(Any.class)});
        }

        @Test
        void shouldAutomaticallyAddDefaultAnnotationsForFields() throws Exception {
            this.injector.register(B.class);
            this.injector.register(C.class);
            this.injector.register(A.class);
            A a = (A)this.injector.getInstance(A.class, new Object[0]);
            Assertions.assertThat((Object)a.defaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)a.explicitDefaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)a.explicitAnyDefaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)a.redImplementation).isInstanceOf(C.class);
            Assertions.assertThat((Object)a.anyRedImplementation).isInstanceOf(C.class);
            this.injector.remove(A.class);
            this.injector.remove(B.class);
            this.injector.remove(C.class);
        }

        @Test
        void shouldAutomaticallyAddDefaultAnnotationsForParameters() throws Exception {
            this.injector.register(B.class);
            this.injector.register(C.class);
            this.injector.register(D.class);
            D d = (D)this.injector.getInstance(D.class, new Object[0]);
            Assertions.assertThat((Object)d.defaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)d.explicitDefaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)d.explicitAnyDefaultImplementation).isInstanceOf(B.class);
            Assertions.assertThat((Object)d.redImplementation).isInstanceOf(C.class);
            Assertions.assertThat((Object)d.anyRedImplementation).isInstanceOf(C.class);
            this.injector.remove(D.class);
            this.injector.remove(B.class);
            this.injector.remove(C.class);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        static @interface Red {
        }

        @Red
        public static class C
        implements I {
        }

        public static class B
        implements I {
        }

        static interface I {
        }

        public static class D {
            I defaultImplementation;
            I explicitDefaultImplementation;
            I explicitAnyDefaultImplementation;
            I redImplementation;
            I anyRedImplementation;

            @Inject
            void setStuff(I defaultImplementation, @Default I explicitDefaultImplementation, @Default @Any I explicitAnyDefaultImplementation, @Red I redImplementation, @Any @Red I anyRedImplementation) {
                this.defaultImplementation = defaultImplementation;
                this.explicitDefaultImplementation = explicitDefaultImplementation;
                this.explicitAnyDefaultImplementation = explicitAnyDefaultImplementation;
                this.redImplementation = redImplementation;
                this.anyRedImplementation = anyRedImplementation;
            }
        }

        public static class A {
            @Inject
            I defaultImplementation;
            @Inject
            @Default
            I explicitDefaultImplementation;
            @Inject
            @Default
            @Any
            I explicitAnyDefaultImplementation;
            @Inject
            @Red
            I redImplementation;
            @Inject
            @Any
            @Red
            I anyRedImplementation;
        }
    }
}

