/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.cdi;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.instantiation.InstantiationContext;
import org.int4.dirk.spi.instantiation.TypeTrait;
import org.int4.dirk.util.Types;

public class InstanceInjectionTargetExtension<T>
implements InjectionTargetExtension<Instance<T>, T> {
    private static final TypeVariable<?> TYPE_VARIABLE = Instance.class.getTypeParameters()[0];
    private static final Set<TypeTrait> LAZY = Collections.unmodifiableSet(EnumSet.of(TypeTrait.LAZY));

    public Class<?> getTargetClass() {
        return Instance.class;
    }

    public Type getElementType(Type type) {
        return Types.getTypeParameter((Type)type, Instance.class, TYPE_VARIABLE);
    }

    public Set<TypeTrait> getTypeTraits() {
        return LAZY;
    }

    public Instance<T> getInstance(InstantiationContext<T> context) {
        return new DefaultInstance<T>(context);
    }

    private static final class DefaultInstance<T>
    implements Instance<T> {
        final InstantiationContext<T> context;

        DefaultInstance(InstantiationContext<T> context) {
            this.context = context;
        }

        public T get() {
            return (T)this.context.create();
        }

        public Iterator<T> iterator() {
            return this.context.createAll().iterator();
        }

        public Instance<T> select(Annotation ... qualifiers) {
            return new DefaultInstance<T>(this.context.select(qualifiers));
        }

        public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return this.selectByType(subtype, qualifiers);
        }

        public <U extends T> Instance<U> select(TypeLiteral<U> literal, Annotation ... qualifiers) {
            return this.selectByType(literal.getType(), qualifiers);
        }

        private <U extends T> Instance<U> selectByType(Type subtype, Annotation ... qualifiers) {
            return new DefaultInstance<T>(this.context.select(subtype, qualifiers));
        }

        public boolean isUnsatisfied() {
            try {
                this.context.create();
                return false;
            }
            catch (UnsatisfiedResolutionException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean isAmbiguous() {
            try {
                this.context.create();
                return false;
            }
            catch (AmbiguousResolutionException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean isResolvable() {
            try {
                this.context.create();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public void destroy(T instance) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Instance.Handle<T> getHandle() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Iterable<? extends Instance.Handle<T>> handles() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

