/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.DefaultDiscovererFactory;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.FieldInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.int4.dirk.core.discovery.Discoverer;
import org.int4.dirk.core.store.QualifiedTypeStore;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.library.ProducesTypeRegistrationExtension;
import org.int4.dirk.test.util.ReplaceCamelCaseDisplayNameGenerator;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=ReplaceCamelCaseDisplayNameGenerator.class)
public class DefaultDiscovererFactoryTest {
    private final QualifiedTypeStore<Injectable<?>> store = new QualifiedTypeStore(i -> new Key(i.getType(), (Collection)i.getQualifiers()), Injectable::getTypes);
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final FieldInjectableFactory fieldInjectableFactory = this.injectableFactories.forField();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();

    static interface M {
        @Produces
        public static final M m = new M(){};
    }

    public static class J {
    }

    static interface I {
        public void createJ();
    }

    public static class Bad_F {
        @Inject
        Bad_E badE;
    }

    public static class Bad_E {
        @Produces
        void bla() {
        }
    }

    public static class Bad_D {
        @Inject
        Bad_A a;
    }

    public static class Bad_C {
        @Inject
        @Red
        J j;
    }

    public static class Bad_B {
        @Inject
        E e;
        @Inject
        C c;
    }

    public static class Bad_A {
        @Inject
        C c;
    }

    public static class Z {
        public Z(String important) {
        }
    }

    public static class Y {
        @Inject
        W w;
    }

    public static class X {
        public X(String important) {
        }
    }

    public static class W {
        @Produces
        static W w = new W(2);
        @Produces
        X x = new X("hello");
        @Produces
        Z z = new Z("world");

        private W(int i) {
        }
    }

    public static class P {
        @Produces
        static P p = new P();
    }

    public static class L {
        @Inject
        Provider<G> g;
    }

    public static class K {
        @Inject
        H h;
    }

    public static class H {
        @Produces
        static H h = new H(2);
        int i;

        private H(int i) {
            this.i = i;
        }
    }

    public static class G {
    }

    public static class F {
        @Produces
        G takes(B b, A a) {
            return null;
        }
    }

    public static class E {
        final String important;

        public E(String important) {
            this.important = important;
        }
    }

    public static class D {
    }

    public static class C {
        final D d;
        final E e;

        public C(D d, E e) {
            this.d = d;
            this.e = e;
        }
    }

    public static class B {
        @Produces
        static E e = new E("!");
    }

    public static class A {
        @Produces
        B b = new B();

        @Produces
        C createC(D d, E e) {
            return new C(d, e);
        }
    }

    @Nested
    class When_autoDiscovery_isEnabled {
        private final DefaultDiscovererFactory factory;

        When_autoDiscovery_isEnabled() {
            this.factory = new DefaultDiscovererFactory(true, List.of(new ProducesTypeRegistrationExtension(Produces.class)), DefaultDiscovererFactoryTest.this.classInjectableFactory, DefaultDiscovererFactoryTest.this.methodInjectableFactory, DefaultDiscovererFactoryTest.this.fieldInjectableFactory);
        }

        @Nested
        class And_gather_With_Types_IsCalled {
            And_gather_With_Types_IsCalled() {
            }

            @Test
            void shouldDiscoverTypesAndFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }

            @Test
            void shouldDiscoverThroughBindingsOfProducerMethod() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(F.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(F.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(F.class.getDeclaredMethod("takes", B.class, A.class), F.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class)});
            }

            @Test
            void shouldDiscoverClassWhichProducesItself() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(H.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(H.class.getDeclaredField("h"), H.class)});
            }

            @Test
            void shouldDiscoverThroughBindingsClassesWhichProduceThemselves() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(K.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(K.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(H.class.getDeclaredField("h"), H.class)});
            }

            @Test
            void shouldDiscoverThroughBindingClassesWrappedInProvider() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(L.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(L.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(G.class)});
            }

            @Test
            void shouldRejectTypeThatIsAbstract() {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(I.class)).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface org.int4.dirk.core.DefaultDiscovererFactoryTest$I] cannot be abstract").hasNoSuppressedExceptions().hasNoCause();
            }

            @Test
            void shouldDiscoverAbstractTypeThatProducesItself() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(M.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(M.class.getDeclaredField("m"), M.class)});
            }

            @Test
            void shouldNotIncludeTypeThatHasQualifiers() throws DefinitionException {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_C.class));
                Assertions.assertThat((Iterable)discoverer.discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_C.class)});
                Assertions.assertThat((List)discoverer.getProblems()).containsExactlyInAnyOrder((Object[])new String[]{"[@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.DefaultDiscovererFactoryTest$J] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_C], via Field [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.DefaultDiscovererFactoryTest$J org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_C.j], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$J] is missing the required qualifiers: [@org.int4.dirk.core.test.qualifiers.Red()])"});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependency() throws DefinitionException {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_A.class));
                Assertions.assertThat((Iterable)discoverer.discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_A.class)});
                Assertions.assertThat((List)discoverer.getProblems()).containsExactlyInAnyOrder((Object[])new String[]{"[org.int4.dirk.core.DefaultDiscovererFactoryTest$C] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A], via Field [org.int4.dirk.core.DefaultDiscovererFactoryTest$C org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A.c], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$C] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)"});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependencyInDependency() throws DefinitionException {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_D.class));
                Assertions.assertThat((Iterable)discoverer.discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_D.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_A.class)});
                Assertions.assertThat((List)discoverer.getProblems()).containsExactlyInAnyOrder((Object[])new String[]{"[org.int4.dirk.core.DefaultDiscovererFactoryTest$C] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_D], via Field [org.int4.dirk.core.DefaultDiscovererFactoryTest$C org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A.c], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$C] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)"});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependencies() throws DefinitionException {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_B.class));
                Assertions.assertThat((Iterable)discoverer.discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_B.class)});
                Assertions.assertThat((List)discoverer.getProblems()).containsExactlyInAnyOrder((Object[])new String[]{"[org.int4.dirk.core.DefaultDiscovererFactoryTest$E] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_B], via Field [org.int4.dirk.core.DefaultDiscovererFactoryTest$E org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_B.e], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$E] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)", "[org.int4.dirk.core.DefaultDiscovererFactoryTest$C] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_B], via Field [org.int4.dirk.core.DefaultDiscovererFactoryTest$C org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_B.c], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$C] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)"});
            }

            @Test
            void shouldReturnAllWaysTypeCanBeCreated() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(P.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(P.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(P.class.getDeclaredField("p"), P.class)});
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Y.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Y.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("w"), W.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("x"), W.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("z"), W.class)});
            }

            @Test
            void shouldThrowDefinitionExceptionWhenContainingBadProducer() {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_E.class));
                ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Discoverer)discoverer).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [void org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_E.bla()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.lang.Void] cannot be void or Void").hasNoCause();
                Assertions.assertThat((List)discoverer.getProblems()).isEmpty();
            }

            @Test
            void shouldFindAsManyTypesAsPossibleAndReturnProblems() throws DefinitionException {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(Bad_A.class));
                Assertions.assertThat((Iterable)discoverer.discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_A.class)});
                Assertions.assertThat((List)discoverer.getProblems()).containsExactlyInAnyOrder((Object[])new String[]{"[org.int4.dirk.core.DefaultDiscovererFactoryTest$C] required by [org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A], via Field [org.int4.dirk.core.DefaultDiscovererFactoryTest$C org.int4.dirk.core.DefaultDiscovererFactoryTest$Bad_A.c], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.DefaultDiscovererFactoryTest$C] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)"});
            }

            @Test
            void shouldRejectTypesThatCannotBeCreatedWithoutBindingDiscovery() {
                Discoverer discoverer = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(X.class, Y.class, Z.class));
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> discoverer.discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.DefaultDiscovererFactoryTest$X] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").satisfies(throwable -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.DefaultDiscovererFactoryTest$Z] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoSuppressedExceptions().hasNoCause())).hasNoCause();
                Assertions.assertThat((List)discoverer.getProblems()).isEmpty();
                Discoverer discoverer2 = When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(X.class, Y.class));
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> discoverer2.discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.DefaultDiscovererFactoryTest$X] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoSuppressedExceptions().hasNoCause();
                Assertions.assertThat((List)discoverer2.getProblems()).isEmpty();
            }
        }

        @Nested
        class And_gather_With_Injectable_IsCalled {
            And_gather_With_Injectable_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }
        }
    }

    @Nested
    class When_autoDiscovery_isDisabled {
        private final DefaultDiscovererFactory factory;

        When_autoDiscovery_isDisabled() {
            this.factory = new DefaultDiscovererFactory(false, List.of(new ProducesTypeRegistrationExtension(Produces.class)), DefaultDiscovererFactoryTest.this.classInjectableFactory, DefaultDiscovererFactoryTest.this.methodInjectableFactory, DefaultDiscovererFactoryTest.this.fieldInjectableFactory);
        }

        @Nested
        class And_gather_With_Types_IsCalled {
            And_gather_With_Types_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, List.of(A.class, D.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class)});
            }
        }

        @Nested
        class And_gather_With_Injectable_IsCalled {
            And_gather_With_Injectable_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.factory.create(DefaultDiscovererFactoryTest.this.store, DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }
        }
    }
}

