/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.DefaultInjectableFactory;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.ScopeResolverManager;
import org.int4.dirk.core.ScopeResolverManagers;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.test.qualifiers.Green;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.core.test.scope.Dependent;
import org.int4.dirk.core.test.scope.TestScope;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DefaultInjectableFactoryTest {
    private final ScopeResolverManager manager = ScopeResolverManagers.create(new ScopeResolver[0]);
    private final DefaultInjectableFactory factory = new DefaultInjectableFactory(this.manager, InjectableFactories.ANNOTATION_STRATEGY, InjectableFactories.SCOPE_STRATEGY, Set.of(Provider.class, List.class, Set.class));
    private final Constructable<BookShop> constructable = new Constructable<BookShop>(){

        public BookShop create(List<Injection> injections) {
            return null;
        }

        public void destroy(BookShop instance) {
        }
    };

    @Test
    void constructorShouldRejectInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectableFactory(null, InjectableFactories.ANNOTATION_STRATEGY, InjectableFactories.SCOPE_STRATEGY, Set.of())).isExactlyInstanceOf(NullPointerException.class)).hasMessage("scopeResolverManager cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectableFactory(this.manager, null, InjectableFactories.SCOPE_STRATEGY, Set.of())).isExactlyInstanceOf(NullPointerException.class)).hasMessage("annotationStrategy cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectableFactory(this.manager, InjectableFactories.ANNOTATION_STRATEGY, null, Set.of())).isExactlyInstanceOf(NullPointerException.class)).hasMessage("scopeStrategy cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectableFactory(this.manager, InjectableFactories.ANNOTATION_STRATEGY, InjectableFactories.SCOPE_STRATEGY, null)).isExactlyInstanceOf(NullPointerException.class)).hasMessage("extendedTypes cannot be null").hasNoCause();
    }

    @Test
    void createShouldCreateClassBasedInjectable() throws DefinitionException {
        Injectable injectable = this.factory.create(BookShop.class, null, BookShop.class, List.of(), this.constructable);
        Assertions.assertThat((Object)injectable).isNotNull();
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(BookShop.class);
        Assertions.assertThat((Iterable)injectable.getTypes()).containsExactlyInAnyOrder((Object[])new Type[]{BookShop.class, Business.class, Types.parameterize(Shop.class, (Type[])new Type[]{Book.class}), Object.class});
        Assertions.assertThat((List)injectable.getBindings()).isEqualTo(List.of());
        Assertions.assertThat((Object)injectable.getScopeResolver().getAnnotation()).isEqualTo((Object)Annotations.of(Dependent.class));
        Assertions.assertThat((Iterable)injectable.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class)});
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Class [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.DefaultInjectableFactoryTest$BookShop]");
    }

    @Test
    void createShouldCreateMethodBasedInjectable() throws Exception {
        Method method = BookShopFactory.class.getDeclaredMethod("createBookShop", new Class[0]);
        Injectable injectable = this.factory.create(BookShopFactory.class, (Member)method, (AnnotatedElement)method, List.of(), this.constructable);
        Assertions.assertThat((Object)injectable).isNotNull();
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(BookShop.class);
        Assertions.assertThat((Iterable)injectable.getTypes()).containsExactlyInAnyOrder((Object[])new Type[]{BookShop.class, Business.class, Types.parameterize(Shop.class, (Type[])new Type[]{Book.class}), Object.class});
        Assertions.assertThat((List)injectable.getBindings()).isEqualTo(List.of());
        Assertions.assertThat((Object)injectable.getScopeResolver().getAnnotation()).isEqualTo((Object)Annotations.of(Singleton.class));
        Assertions.assertThat((Iterable)injectable.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Green.class)});
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Producer [@org.int4.dirk.core.test.qualifiers.Green() public org.int4.dirk.core.DefaultInjectableFactoryTest$BookShop org.int4.dirk.core.DefaultInjectableFactoryTest$BookShopFactory.createBookShop()]");
    }

    @Test
    void createShouldCreateFieldBasedInjectable() throws Exception {
        Field field = BookShopFactory.class.getDeclaredField("bookShop");
        Injectable injectable = this.factory.create(BookShopFactory.class, (Member)field, (AnnotatedElement)field, List.of(), this.constructable);
        Assertions.assertThat((Object)injectable).isNotNull();
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(BookShop.class);
        Assertions.assertThat((Iterable)injectable.getTypes()).containsExactlyInAnyOrder((Object[])new Type[]{BookShop.class, Business.class, Types.parameterize(Shop.class, (Type[])new Type[]{Book.class}), Object.class});
        Assertions.assertThat((List)injectable.getBindings()).isEqualTo(List.of());
        Assertions.assertThat((Object)injectable.getScopeResolver().getAnnotation()).isEqualTo((Object)Annotations.of(Singleton.class));
        Assertions.assertThat((Iterable)injectable.getQualifiers()).isEmpty();
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Producer [org.int4.dirk.core.DefaultInjectableFactoryTest$BookShop org.int4.dirk.core.DefaultInjectableFactoryTest$BookShopFactory.bookShop]");
    }

    @Test
    void createShouldCreateInstanceBasedInjectable() throws Exception {
        final String instance = "Hello";
        Annotation[] qualifiers = new Annotation[]{Annotations.of(Singleton.class), Annotations.of(Red.class)};
        Injectable injectable = this.factory.create(instance.getClass(), null, (AnnotatedElement)new FakeAnnotatedElement(instance, qualifiers), List.of(), (Constructable)new Constructable<String>(){

            public String create(List<Injection> injections) {
                return instance;
            }

            public void destroy(String instance2) {
            }
        });
        Assertions.assertThat((Object)injectable).isNotNull();
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(String.class);
        Assertions.assertThat((Iterable)injectable.getTypes()).contains((Object[])new Type[]{CharSequence.class, Serializable.class, Types.parameterize(Comparable.class, (Type[])new Type[]{String.class}), String.class, Object.class});
        Assertions.assertThat((List)injectable.getBindings()).isEqualTo(List.of());
        Assertions.assertThat((Object)injectable.getScopeResolver().getAnnotation()).isEqualTo((Object)Annotations.of(Singleton.class));
        Assertions.assertThat((Iterable)injectable.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class)});
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Instance of [@org.int4.dirk.core.test.qualifiers.Red() java.lang.String -> Hello]");
    }

    @Test
    void createShouldRejectBadParameters() throws NoSuchMethodException, SecurityException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(null, null, BookShop.class, List.of(), this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(BookShop.class, null, null, List.of(), this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("element cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(BookShop.class, null, BookShop.class, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("bindings cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(BookShop.class, null, BookShop.class, List.of(), null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("constructable cannot be null").hasNoCause();
        Method factoryMethod = BookShopFactory.class.getDeclaredMethod("createBookShop", new Class[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(BookShop.class, (Member)factoryMethod, (AnnotatedElement)factoryMethod, List.of(), this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType must be assignable to member's declaring class: class org.int4.dirk.core.DefaultInjectableFactoryTest$BookShop; declaring class: class org.int4.dirk.core.DefaultInjectableFactoryTest$BookShopFactory").hasNoCause();
    }

    @Test
    void createShouldRejectTypesWithMultipleScopeAnnotations() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(OverScoped.class, null, OverScoped.class, List.of(), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.DefaultInjectableFactoryTest$OverScoped] cannot have multiple scope annotations, but found: [@jakarta.inject.Singleton(), @org.int4.dirk.core.test.scope.TestScope()]").hasNoCause();
    }

    @Test
    void createShouldRejectProducersWithInjectAnnotation() throws NoSuchMethodException, SecurityException {
        Method method = IllegallyInjectAnnotated.class.getDeclaredMethod("producerMethod", new Class[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(IllegallyInjectAnnotated.class, (Member)method, (AnnotatedElement)method, List.of(), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [java.lang.String org.int4.dirk.core.DefaultInjectableFactoryTest$IllegallyInjectAnnotated.producerMethod()] should not have an inject annotation, but found: [@jakarta.inject.Inject()]").hasNoCause();
    }

    @Test
    void createShouldRejectBindingsWithScopeAnnotation() throws Exception {
        Binding binding1 = (Binding)Mockito.mock(Binding.class);
        Binding binding2 = (Binding)Mockito.mock(Binding.class);
        Mockito.when((Object)binding1.getAnnotatedElement()).thenReturn((Object)IllegallyScopeAnnotated.class.getDeclaredField("test"));
        Mockito.when((Object)binding2.getAnnotatedElement()).thenReturn((Object)IllegallyScopeAnnotated.class.getDeclaredField("test2"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(IllegallyScopeAnnotated.class, null, IllegallyScopeAnnotated.class, List.of(binding1, binding2), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [private java.lang.String org.int4.dirk.core.DefaultInjectableFactoryTest$IllegallyScopeAnnotated.test2] should not have a scope annotation, but found: @jakarta.inject.Singleton()").hasNoCause();
    }

    @Test
    void createShouldRejectBaseTypesWhichAreProvidedByInjectionTargetExtensions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(Provider.class, null, Provider.class, List.of(), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface jakarta.inject.Provider] cannot be registered as it conflicts with an InjectionTargetExtension for type: interface jakarta.inject.Provider").hasNoCause();
    }

    @Test
    void createShouldRejectProducerWithUnresolvableTypeVariables() throws NoSuchFieldException, SecurityException {
        Field field = UnresolvableProducer.class.getDeclaredField("shop");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(UnresolvableProducer.class, (Member)field, (AnnotatedElement)field, List.of(), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [org.int4.dirk.core.DefaultInjectableFactoryTest$Shop org.int4.dirk.core.DefaultInjectableFactoryTest$UnresolvableProducer.shop] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[org.int4.dirk.core.DefaultInjectableFactoryTest.Shop<T>] cannot have unresolvable type variables or wild cards").hasNoCause();
    }

    @Test
    void createShouldRejectProducerWithUnknownType() throws NoSuchFieldException, SecurityException {
        Field field = UnknownProducer.class.getDeclaredField("shop");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(UnknownProducer.class, (Member)field, (AnnotatedElement)field, List.of(), this.constructable)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [java.lang.Object org.int4.dirk.core.DefaultInjectableFactoryTest$UnknownProducer.shop] has unresolvable return type").hasNoCause();
    }

    private static class FakeAnnotatedElement
    implements AnnotatedElement {
        private final Object instance;
        private final Annotation[] qualifiers;

        FakeAnnotatedElement(Object instance, Annotation ... qualifiers) {
            this.instance = instance;
            this.qualifiers = qualifiers;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)Arrays.stream(this.qualifiers).filter(q -> q.annotationType().equals(annotationClass)).findFirst().orElse(null));
        }

        @Override
        public Annotation[] getAnnotations() {
            return (Annotation[])this.qualifiers.clone();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.qualifiers.clone();
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FakeAnnotatedElement other = (FakeAnnotatedElement)obj;
            return Objects.equals(this.instance, other.instance);
        }

        public String toString() {
            return this.instance.toString();
        }
    }

    static class UnknownProducer<T> {
        T shop;

        UnknownProducer() {
        }
    }

    static class UnresolvableProducer<T> {
        Shop<T> shop;

        UnresolvableProducer() {
        }
    }

    static class IllegallyScopeAnnotated {
        @Inject
        private String test;
        @Inject
        @Singleton
        private String test2;

        IllegallyScopeAnnotated() {
        }
    }

    static class IllegallyInjectAnnotated {
        IllegallyInjectAnnotated() {
        }

        @Inject
        String producerMethod() {
            return "";
        }
    }

    @Singleton
    @TestScope
    static class OverScoped {
        OverScoped() {
        }
    }

    static class BookShopFactory {
        @Singleton
        BookShop bookShop = new BookShop();

        BookShopFactory() {
        }

        @Green
        @Singleton
        public BookShop createBookShop() {
            return null;
        }
    }

    @Red
    static class BookShop
    extends Business
    implements Shop<Book>,
    Provider<String> {
        BookShop() {
        }

        public String get() {
            return "My BookShop";
        }
    }

    @Green
    static class Business {
        Business() {
        }
    }

    static class Book {
        Book() {
        }
    }

    static interface Shop<T> {
        default public T shopStuff(T t) {
            return t;
        }
    }
}

