/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.core.DefaultInjectable;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.QualifiedType;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.test.qualifiers.Green;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DefaultInjectableTest {
    private static final ExtendedScopeResolver SCOPE_RESOLVER = (ExtendedScopeResolver)Mockito.mock(ExtendedScopeResolver.class);
    private final Binding binding1 = (Binding)Mockito.mock(Binding.class);
    private final Binding binding2 = (Binding)Mockito.mock(Binding.class);
    private final Binding binding3 = (Binding)Mockito.mock(Binding.class);
    private final Constructable<String> constructable = new Constructable<String>(){

        public void destroy(String instance) {
        }

        public String create(List<Injection> injections) {
            return "5";
        }
    };

    @Test
    void constructorShouldAcceptValidParameters() throws CreationException, BadQualifiedTypeException {
        DefaultInjectable injectable = new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class), List.of(), SCOPE_RESOLVER, String.class, this.constructable);
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("5");
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(String.class);
        Assertions.assertThat((Object)injectable.getScopeResolver()).isEqualTo((Object)SCOPE_RESOLVER);
        Assertions.assertThat((Iterable)injectable.getQualifiers()).isEmpty();
        Assertions.assertThat((List)injectable.getBindings()).isEmpty();
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Class [java.lang.String]");
        injectable = new DefaultInjectable(String.class, Set.of(Types.parameterize(Supplier.class, (Type[])new Type[]{String.class})), new QualifiedType((Type)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class))), List.of(this.binding1, this.binding2, this.binding3), SCOPE_RESOLVER, String.class, this.constructable);
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("5");
        Assertions.assertThat((Object)injectable.getType()).isEqualTo((Object)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Object)injectable.getScopeResolver()).isEqualTo((Object)SCOPE_RESOLVER);
        Assertions.assertThat((Iterable)injectable.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((List)injectable.getBindings()).containsExactly((Object[])new Binding[]{this.binding1, this.binding2, this.binding3});
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Class [@org.int4.dirk.core.test.qualifiers.Green(), @org.int4.dirk.core.test.qualifiers.Red() java.lang.String]");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(null, Set.of(String.class), new QualifiedType(String.class), List.of(), SCOPE_RESOLVER, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, null, null, List.of(), SCOPE_RESOLVER, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("types cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(Integer.class), null, List.of(), SCOPE_RESOLVER, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiedType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(String.class), null, List.of(), SCOPE_RESOLVER, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiedType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), null, SCOPE_RESOLVER, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("bindings cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), null, String.class, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("scopeResolver cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), SCOPE_RESOLVER, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("discriminator cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), SCOPE_RESOLVER, String.class, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("constructable cannot be null").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() throws BadQualifiedTypeException {
        EqualsVerifier.forClass(DefaultInjectable.class).withNonnullFields(new String[]{"qualifiedType", "ownerType", "discriminator"}).withCachedHashCode("hashCode", "calculateHash", (Object)new DefaultInjectable(String.class, Set.of(String.class), new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), SCOPE_RESOLVER, String.class, this.constructable)).withIgnoredFields(new String[]{"bindings", "types", "scopeResolver", "constructable"}).verify();
    }
}

