/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.InstanceResolver;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.DefaultInstanceResolver;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.InstantiationContextFactory;
import org.int4.dirk.core.ScopeResolverManager;
import org.int4.dirk.core.ScopeResolverManagers;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.InjectionTargetExtensionStore;
import org.int4.dirk.core.definition.InstanceInjectableFactory;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.int4.dirk.core.store.InjectableStore;
import org.int4.dirk.core.store.Resolver;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class DefaultInstanceResolverTest {
    private final AbstractScopeResolver<String> scopeResolver = new AbstractScopeResolver<String>(){

        public Annotation getAnnotation() {
            return Annotations.of(TestScoped.class);
        }

        public String getCurrentScope() {
            return DefaultInstanceResolverTest.this.currentScope;
        }
    };
    private final ScopeResolverManager scopeResolverManager = ScopeResolverManagers.create(new ScopeResolver[]{this.scopeResolver});
    private final InjectableFactories injectableFactories = new InjectableFactories(this.scopeResolverManager);
    private final InjectionTargetExtensionStore injectionTargetExtensionStore = this.injectableFactories.getInjectionTargetExtensionStore();
    private final InjectableStore store = new InjectableStore(InjectableFactories.PROXY_STRATEGY);
    private final InstantiationContextFactory instantiationContextFactory = new InstantiationContextFactory((Resolver)this.store, InjectableFactories.ANNOTATION_STRATEGY, InjectableFactories.PROXY_STRATEGY, this.injectionTargetExtensionStore);
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();
    private final InstanceInjectableFactory instanceInjectableFactory = this.injectableFactories.forInstance();
    private String currentScope;

    static class M {
        M() {
        }
    }

    public static class L {
        @Inject
        K k;
        @Inject
        M m;
    }

    public static class K {
    }

    public static abstract class J {
    }

    public static class I {
    }

    public static class H {
    }

    public static class G
    extends E {
    }

    @TestScoped
    public static class F
    extends E {
    }

    public static class E {
    }

    @TestScoped
    public static class D {
    }

    @Singleton
    public static class C {
    }

    @Singleton
    public static class B {
        @Produces
        H createH() {
            throw new RuntimeException("can't create H");
        }

        @Produces
        I createI() {
            return null;
        }
    }

    public static class A {
    }

    @Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UnknownScoped {
    }

    @Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestScoped {
    }

    @Nested
    class WhenStoreNotEmpty {
        private final InstanceResolver instanceResolver;

        WhenStoreNotEmpty() {
            this.instanceResolver = new DefaultInstanceResolver(DefaultInstanceResolverTest.this.instantiationContextFactory);
        }

        @BeforeEach
        void beforeEach() throws DependencyException {
            try {
                DefaultInstanceResolverTest.this.store.putAll(List.of(DefaultInstanceResolverTest.this.classInjectableFactory.create(A.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(B.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(C.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(D.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(F.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(G.class), DefaultInstanceResolverTest.this.instanceInjectableFactory.create((Object)"red", new Annotation[]{Annotations.of(Red.class)}), DefaultInstanceResolverTest.this.instanceInjectableFactory.create((Object)"green", new Annotation[]{Annotations.of(Named.class, Map.of("value", "green"))}), DefaultInstanceResolverTest.this.methodInjectableFactory.create(B.class.getDeclaredMethod("createH", new Class[0]), B.class), DefaultInstanceResolverTest.this.methodInjectableFactory.create(B.class.getDeclaredMethod("createI", new Class[0]), B.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(K.class)));
            }
            catch (NoSuchMethodException | SecurityException | DefinitionException e) {
                throw new IllegalStateException();
            }
        }

        @Test
        void getInstanceShouldReturnInstancesOfKnownTypes() throws Exception {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.instanceResolver.getInstance(A.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.instanceResolver.getInstance(String.class, new Object[]{Red.class}));
        }

        @Test
        void getInstancesShouldReturnInstancesOfKnownTypes() throws CreationException {
            Assertions.assertThat((List)this.instanceResolver.getInstances(String.class, new Object[0])).hasSize(2);
        }

        @Test
        void shouldFollowScopeRules() throws Exception {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((A)this.instanceResolver.getInstance(A.class, new Object[0])).equals(this.instanceResolver.getInstance(A.class, new Object[0])));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((B)this.instanceResolver.getInstance(B.class, new Object[0])).equals(this.instanceResolver.getInstance(B.class, new Object[0])));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((C)this.instanceResolver.getInstance(C.class, new Object[0])).equals(this.instanceResolver.getInstance(C.class, new Object[0])));
        }

        @Test
        void shouldThrowScopeNotActiveExceptionWhenScopeNotActive() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(D.class, new Object[0])).isExactlyInstanceOf(ScopeNotActiveException.class)).hasMessage("Scope not active: @org.int4.dirk.core.DefaultInstanceResolverTest$TestScoped() for: Class [org.int4.dirk.core.DefaultInstanceResolverTest$D]").hasNoCause();
        }

        @Test
        void shouldThrowExceptionWhenNotSingular() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(String.class, new Object[0])).isExactlyInstanceOf(AmbiguousResolutionException.class)).hasNoCause();
        }

        @Test
        void getInstancesShouldRetrieveScopedInstancesOnlyWhenActive() throws CreationException {
            Assertions.assertThat((List)this.instanceResolver.getInstances(E.class, new Object[0])).hasSize(1);
            DefaultInstanceResolverTest.this.currentScope = "Active!";
            Assertions.assertThat((List)this.instanceResolver.getInstances(E.class, new Object[0])).hasSize(2);
        }

        @Test
        void getInstancesShouldThrowExceptionWhenInstantiationFails() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstances(H.class, new Object[0])).isExactlyInstanceOf(CreationException.class)).hasMessage("Method [org.int4.dirk.core.DefaultInstanceResolverTest$H org.int4.dirk.core.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(RuntimeException.class)).hasMessage("can't create H").hasNoCause();
        }

        @Test
        void getInstancesShouldRetrieveSingletons() throws CreationException {
            ((ListAssert)Assertions.assertThat((List)this.instanceResolver.getInstances(B.class, new Object[0])).hasSize(1)).containsExactlyInAnyOrderElementsOf((Iterable)this.instanceResolver.getInstances(B.class, new Object[0]));
        }

        @Test
        void getInstancesShouldIgnoreNullInstancesFromProducers() throws CreationException {
            Assertions.assertThat((List)this.instanceResolver.getInstances(I.class, new Object[0])).isEmpty();
        }

        @Test
        void getInstanceShouldRejectNullInstancesFromProducers() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(I.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasMessage("No such instance: [org.int4.dirk.core.DefaultInstanceResolverTest$I]").hasNoCause();
        }

        @Test
        void getInstanceShouldThrowExceptionWhenInstantiationFails() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(H.class, new Object[0])).isExactlyInstanceOf(CreationException.class)).hasMessage("Method [org.int4.dirk.core.DefaultInstanceResolverTest$H org.int4.dirk.core.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(RuntimeException.class)).hasMessage("can't create H").hasNoCause();
        }
    }

    @Nested
    class WhenStoreIsEmpty {
        private final InstanceResolver instanceResolver;

        WhenStoreIsEmpty() {
            this.instanceResolver = new DefaultInstanceResolver(DefaultInstanceResolverTest.this.instantiationContextFactory);
        }

        @Test
        void shouldThrowExceptionWhenGettingSingleInstance() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(A.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasNoCause();
        }

        @Test
        void shouldReturnEmptySetWhenGettingMultipleInstances() throws CreationException {
            Assertions.assertThat((List)this.instanceResolver.getInstances(A.class, new Object[0])).isEmpty();
        }
    }
}

