/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.core.Injectors;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;

public class InjectionTargetExtensionTest {
    Injector injector = Injectors.manual(new ScopeResolver[0]);

    @Test
    void shouldGetInstancesForNestedTypes() throws Exception {
        this.injector.registerInstance((Object)"A", new Annotation[0]);
        Assertions.assertThat((String)((String)((Provider)this.injector.getInstance((Type)Types.parameterize(Provider.class, (Type[])new Type[]{String.class}), new Object[0])).get())).isEqualTo("A");
        Assertions.assertThat((String)((String)((Provider)((Provider)this.injector.getInstance((Type)Types.parameterize(Provider.class, (Type[])new Type[]{Types.parameterize(Provider.class, (Type[])new Type[]{String.class})}), new Object[0])).get()).get())).isEqualTo("A");
        Provider integerProvider = (Provider)this.injector.getInstance((Type)Types.parameterize(Provider.class, (Type[])new Type[]{Integer.class}), new Object[0]);
        Assertions.assertThat((Object)integerProvider).isInstanceOf(Provider.class);
        Assertions.assertThatThrownBy(() -> integerProvider.get()).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
        Provider integerProviderProvider = (Provider)this.injector.getInstance((Type)Types.parameterize(Provider.class, (Type[])new Type[]{Types.parameterize(Provider.class, (Type[])new Type[]{Integer.class})}), new Object[0]);
        Assertions.assertThat((Object)integerProviderProvider).isInstanceOf(Provider.class);
        Assertions.assertThat((Object)((Provider)integerProviderProvider.get())).isInstanceOf(Provider.class);
        Assertions.assertThatThrownBy(() -> ((Provider)integerProviderProvider.get()).get()).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
    }

    public void shouldInjectAvailableTypeInVariousNestedTargets() throws Exception {
        this.injector.register(IntegerProviderInjected.class);
        IntegerProviderInjected instance = (IntegerProviderInjected)this.injector.getInstance(IntegerProviderInjected.class, new Object[0]);
        Assertions.assertThat((Integer)((Integer)instance.b.get())).isNull();
        Assertions.assertThat((List)((List)instance.c.get())).isEmpty();
        Assertions.assertThat((List)((List)instance.d.get())).isNull();
        Assertions.assertThat((Iterable)((Iterable)instance.e.get())).isEmpty();
        Assertions.assertThat((Iterable)((Iterable)instance.f.get())).isNull();
        Assertions.assertThat((Integer)((Integer)((Provider)instance.h.get()).get())).isNull();
    }

    public void shouldInjectDefaultsInVariousTargets() throws Exception {
        this.injector.registerInstance((Object)"A", new Annotation[0]);
        this.injector.register(IntegerProviderInjected.class);
        StringProviderInjected instance = (StringProviderInjected)this.injector.getInstance(StringProviderInjected.class, new Object[0]);
        Assertions.assertThat((String)((String)instance.a.get())).isEqualTo("A");
        Assertions.assertThat((String)((String)instance.b.get())).isEqualTo("A");
        Assertions.assertThat((List)((List)instance.c.get())).containsExactly((Object[])new String[]{"A"});
        Assertions.assertThat((List)((List)instance.d.get())).containsExactly((Object[])new String[]{"A"});
        Assertions.assertThat((Iterable)((Iterable)instance.e.get())).containsExactly((Object[])new String[]{"A"});
        Assertions.assertThat((Iterable)((Iterable)instance.f.get())).containsExactly((Object[])new String[]{"A"});
        Assertions.assertThat((String)((String)((Provider)instance.g.get()).get())).isEqualTo("A");
        Assertions.assertThat((String)((String)((Provider)instance.h.get()).get())).isEqualTo("A");
    }

    public static class IntegerProviderInjected {
        @Inject
        @Opt
        Provider<Integer> b;
        @Inject
        Provider<List<Integer>> c;
        @Inject
        @Opt
        Provider<List<Integer>> d;
        @Inject
        Provider<Set<Integer>> e;
        @Inject
        @Opt
        Provider<Set<Integer>> f;
        @Inject
        @Opt
        Provider<Provider<Integer>> h;
    }

    public static class StringProviderInjected {
        @Inject
        Provider<String> a;
        @Inject
        @Opt
        Provider<String> b;
        @Inject
        Provider<List<String>> c;
        @Inject
        @Opt
        Provider<List<String>> d;
        @Inject
        Provider<Set<String>> e;
        @Inject
        @Opt
        Provider<Set<String>> f;
        @Inject
        Provider<Provider<String>> g;
        @Inject
        @Opt
        Provider<Provider<String>> h;
    }
}

