/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.core.Injectors;
import org.int4.dirk.core.test.injectables.BeanWithInjection;
import org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithEmptyAndAnnotatedConstructor;
import org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors;
import org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch;
import org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors;
import org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch;
import org.int4.dirk.core.test.injectables.SimpleBean;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.junit.jupiter.api.Test;

public class InjectorDiscoveryTest {
    private Injector injector = Injectors.autoDiscovering(new ScopeResolver[0]);

    @Test
    public void shouldDiscoverDependentTypes() throws Exception {
        this.injector.register(BeanWithInjection.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(BeanWithInjection.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(SimpleBean.class, new Object[0]));
    }

    @Test
    public void shouldNotDiscoverNewTypeWithoutAnyConstructorMatch() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SampleWithDependencyOnSampleWithoutConstructorMatch.class)).isExactlyInstanceOf(AutoDiscoveryException.class)).hasMessage("Unable to register [class org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch]\n    -> [org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch] required by [org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch], via Field [public org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch.sampleWithoutConstructorMatch], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor)").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasMessage("Missing dependency [org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch] required for Field [public org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch.sampleWithoutConstructorMatch]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithDependencyOnSampleWithoutConstructorMatch.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithoutConstructorMatch.class, new Object[0]));
    }

    @Test
    public void shouldNotDiscoverNewTypeWithMultipleConstructorMatch() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.class)).isExactlyInstanceOf(AutoDiscoveryException.class)).hasMessage("Unable to register [class org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors]\n    -> [org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors] required by [org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors], via Field [public org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.sample], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors] cannot have multiple Inject annotated constructors)").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasMessage("Missing dependency [org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors] required for Field [public org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors org.int4.dirk.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.sample]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithMultipleAnnotatedConstructors.class, new Object[0]));
    }

    @Test
    public void shouldThrowDefinitionExceptionWhenAddingClassWithoutConstructorMatch() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SampleWithoutConstructorMatch.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.test.injectables.SampleWithoutConstructorMatch] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
    }

    @Test
    public void shouldDiscoverNewTypeWithEmptyUnannotatedConstructorAndAnnotatedConstructor() throws Exception {
        this.injector.register(SampleWithDependencyOnSampleWithEmptyAndAnnotatedConstructor.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(SampleWithDependencyOnSampleWithEmptyAndAnnotatedConstructor.class, new Object[0]));
    }

    @Test
    public void autoDiscoveryShouldNotLeaveStoreInModifiedState() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(D.class)).isExactlyInstanceOf(AutoDiscoveryException.class)).hasMessage("Unable to register [class org.int4.dirk.core.InjectorDiscoveryTest$D] and the discovered types [Class [org.int4.dirk.core.InjectorDiscoveryTest$A], Class [org.int4.dirk.core.InjectorDiscoveryTest$B], Class [org.int4.dirk.core.InjectorDiscoveryTest$C]]\n    -> [org.int4.dirk.core.InjectorDiscoveryTest$E] required by [org.int4.dirk.core.InjectorDiscoveryTest$C] required by [org.int4.dirk.core.InjectorDiscoveryTest$D], via Field [org.int4.dirk.core.InjectorDiscoveryTest$E org.int4.dirk.core.InjectorDiscoveryTest$C.e], is not registered and cannot be discovered (reason: [interface org.int4.dirk.core.InjectorDiscoveryTest$E] cannot be abstract)\n    -> [org.int4.dirk.core.InjectorDiscoveryTest$F] required by [org.int4.dirk.core.InjectorDiscoveryTest$C] required by [org.int4.dirk.core.InjectorDiscoveryTest$D], via Field [org.int4.dirk.core.InjectorDiscoveryTest$F org.int4.dirk.core.InjectorDiscoveryTest$C.f], is not registered and cannot be discovered (reason: [interface org.int4.dirk.core.InjectorDiscoveryTest$F] cannot be abstract)").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasMessage("Missing dependency [org.int4.dirk.core.InjectorDiscoveryTest$E] required for Field [org.int4.dirk.core.InjectorDiscoveryTest$E org.int4.dirk.core.InjectorDiscoveryTest$C.e]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(A.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(B.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(C.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(D.class, new Object[0]));
    }

    @Test
    public void shouldThrowAutoDiscoveryExceptionWhenDiscoveredClassRequiresQualifiers() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(G.class)).isExactlyInstanceOf(AutoDiscoveryException.class)).hasMessage("Unable to register [class org.int4.dirk.core.InjectorDiscoveryTest$G]\n    -> [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.InjectorDiscoveryTest$A] required by [org.int4.dirk.core.InjectorDiscoveryTest$G], via Field [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.InjectorDiscoveryTest$A org.int4.dirk.core.InjectorDiscoveryTest$G.a], is not registered and cannot be discovered (reason: [class org.int4.dirk.core.InjectorDiscoveryTest$A] is missing the required qualifiers: [@org.int4.dirk.core.test.qualifiers.Red()])").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasMessage("Missing dependency [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.InjectorDiscoveryTest$A] required for Field [@org.int4.dirk.core.test.qualifiers.Red() org.int4.dirk.core.InjectorDiscoveryTest$A org.int4.dirk.core.InjectorDiscoveryTest$G.a]").hasNoCause();
    }

    @Test
    public void shouldReturnEmptyListWhenNoInstancesOfInterfaceKnown() throws CreationException {
        Assertions.assertThat((List)this.injector.getInstances(E.class, new Object[0])).isEmpty();
    }

    @Test
    public void shouldReturnEmptyListWhenNoInstancesOfDiscoverableClassKnown() throws CreationException {
        Assertions.assertThat((List)this.injector.getInstances(A.class, new Object[0])).isEmpty();
    }

    @Test
    public void registerShouldDiscoverNewTypes() throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.injector.register(B.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.contains(A.class, new Object[0]));
    }

    public static class G {
        @Red
        @Inject
        A a;
    }

    static interface F {
    }

    static interface E {
    }

    public static class D {
        @Inject
        B b;
        @Inject
        C c;
    }

    public static class C {
        @Inject
        A a;
        @Inject
        E e;
        @Inject
        F f;
    }

    public static class B {
        @Inject
        A a;
    }

    public static class A {
    }
}

