/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.ScopeConflictException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.Injectors;
import org.int4.dirk.core.test.scope.TestScope;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class InjectorScopeTest {
    @Test
    public void shouldKeepSameTypesWithDifferentQualifiersSeparated() throws Exception {
        TestScopeResolver scopeResolver = new TestScopeResolver();
        Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
        injector.register(Producers.class);
        Assertions.assertThat((List)injector.getInstances(String.class, new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"a", "b"});
    }

    @Singleton
    @TestScope
    public static class IllegalMultiScopedBean {
        @Inject
        TestScopedBean testScopedBean;
    }

    @Singleton
    public static class IllegalSingletonBean {
        @Inject
        TestScopedBean testScopedBean;
    }

    @TestScope
    public static class SomeUserBeanWithTestScope2 {
        @Inject
        UnscopedBean unscopedBean;
    }

    @TestScope
    public static class SomeUserBeanWithTestScope {
        @Inject
        TestScopedBean testScopedBean;
    }

    public static class SomeUserBean {
        @Inject
        Provider<TestScopedBean> testScopedBean;
    }

    public static class UnscopedBean {
    }

    @TestScope
    public static class TestScopedBean {
    }

    static class TestScopeResolver
    extends AbstractScopeResolver<String> {
        public String currentScope = "default";

        TestScopeResolver() {
        }

        public Annotation getAnnotation() {
            return Annotations.of(TestScope.class);
        }

        public String getCurrentScope() {
            return this.currentScope;
        }
    }

    public static class Producers {
        @Produces
        @TestScope
        @Named(value="a")
        static String a = "a";
        @Produces
        @TestScope
        @Named(value="b")
        static String b = "b";
    }

    public static class XProvider
    implements Provider<X> {
        public X get() {
            return null;
        }
    }

    @Singleton
    public static class SingletonBeanDependentOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    public static class PrototypeBeanDependantOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    @Singleton
    public static class SingletonBeanDependentOnX {
        @Inject
        X x;
    }

    public static class PrototypeBeanDependantOnX {
        @Inject
        X x;
    }

    public static class X {
    }

    @Singleton
    public static class S {
    }

    @Nested
    class Providers {
        Providers() {
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXWhenXIsProvidedAsSingleton() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnX.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsPrototype() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnX.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsSingleton() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnX.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXWhenXIsProvidedAsPrototype() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnX.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsSingleton() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnXProvider.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsPrototype() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnXProvider.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsSingleton() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnXProvider.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsPrototype() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnXProvider.class);
        }
    }

    @Nested
    class Classes {
        Classes() {
        }

        @Test
        public void shouldThrowScopeNotActiveExceptionWhenNoScopeActive() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            scopeResolver.currentScope = null;
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.getInstance(TestScopedBean.class, new Object[0])).isExactlyInstanceOf(ScopeNotActiveException.class)).hasMessage("Scope not active: @org.int4.dirk.core.test.scope.TestScope() for: Class [org.int4.dirk.core.InjectorScopeTest$TestScopedBean]").hasNoCause();
        }

        @Test
        public void shouldRemoveInstancesFromScopeResolver() throws Exception {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.register(S.class);
            S instance1 = (S)injector.getInstance(S.class, new Object[0]);
            S instance2 = (S)injector.getInstance(S.class, new Object[0]);
            Assertions.assertThat((Object)instance1).isEqualTo((Object)instance2);
            injector.remove(S.class);
            Assertions.assertThatThrownBy(() -> injector.getInstance(S.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
            injector.register(S.class);
            S instance3 = (S)injector.getInstance(S.class, new Object[0]);
            S instance4 = (S)injector.getInstance(S.class, new Object[0]);
            Assertions.assertThat((Object)instance3).isEqualTo((Object)instance4);
            Assertions.assertThat((Object)instance3).isNotEqualTo((Object)instance1);
        }

        @Test
        public void shouldKeepScopesSeparated() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            injector.register(SomeUserBeanWithTestScope.class);
            SomeUserBeanWithTestScope testScopedBean1 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            SomeUserBeanWithTestScope testScopedBean2 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "a";
            SomeUserBeanWithTestScope testScopedBean3 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "b";
            SomeUserBeanWithTestScope testScopedBean4 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "a";
            SomeUserBeanWithTestScope testScopedBean5 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean1, (Object)testScopedBean2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean3, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean3);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean4);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean3, (Object)testScopedBean4);
        }

        @Test
        public void shouldKeepScopesSeparatedInReferences() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            injector.register(SomeUserBean.class);
            TestScopedBean testScopedBean1 = (TestScopedBean)((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean.get();
            TestScopedBean testScopedBean2 = (TestScopedBean)((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean.get();
            scopeResolver.currentScope = "a";
            TestScopedBean testScopedBean3 = (TestScopedBean)((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean.get();
            scopeResolver.currentScope = "b";
            TestScopedBean testScopedBean4 = (TestScopedBean)((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean.get();
            scopeResolver.currentScope = "a";
            TestScopedBean testScopedBean5 = (TestScopedBean)((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean.get();
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean1, (Object)testScopedBean2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean3, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean3);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean4);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean3, (Object)testScopedBean4);
        }

        @Test
        public void shouldThrowExceptionWhenNarrowScopedBeansAreInjectedIntoBroaderScopedBeans() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            Assertions.assertThatThrownBy(() -> injector.register(IllegalSingletonBean.class)).isExactlyInstanceOf(ScopeConflictException.class);
        }

        @Test
        public void shouldAllowInjectingUnscopedInstancesAlways() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(UnscopedBean.class);
            injector.register(SomeUserBeanWithTestScope2.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(SomeUserBeanWithTestScope2.class, new Object[0]));
        }

        @Test
        public void shouldThrowExceptionWhenMultipleScopesDefinedOnBean() throws Exception {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.register(IllegalMultiScopedBean.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.InjectorScopeTest$IllegalMultiScopedBean] cannot have multiple scope annotations, but found: [@jakarta.inject.Singleton(), @org.int4.dirk.core.test.scope.TestScope()]").hasNoCause();
        }
    }
}

