/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.AmbiguousDependencyException;
import org.int4.dirk.api.definition.AmbiguousRequiredDependencyException;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.definition.DuplicateDependencyException;
import org.int4.dirk.api.definition.MissingDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedRequiredDependencyException;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.core.Injectors;
import org.int4.dirk.core.test.injectables.AbstractBean;
import org.int4.dirk.core.test.injectables.BeanWithBigInjection;
import org.int4.dirk.core.test.injectables.BeanWithBigRedInjection;
import org.int4.dirk.core.test.injectables.BeanWithCollection;
import org.int4.dirk.core.test.injectables.BeanWithCollectionProvider;
import org.int4.dirk.core.test.injectables.BeanWithDirectCollectionItemDependency;
import org.int4.dirk.core.test.injectables.BeanWithDirectRedCollectionItemDependency;
import org.int4.dirk.core.test.injectables.BeanWithInjection;
import org.int4.dirk.core.test.injectables.BeanWithInterfaceBasedInjection;
import org.int4.dirk.core.test.injectables.BeanWithOptionalConstructorDependency;
import org.int4.dirk.core.test.injectables.BeanWithOptionalDependency;
import org.int4.dirk.core.test.injectables.BeanWithPostConstruct;
import org.int4.dirk.core.test.injectables.BeanWithProvider;
import org.int4.dirk.core.test.injectables.BeanWithProviderWithoutMatch;
import org.int4.dirk.core.test.injectables.BeanWithUnregisteredParent;
import org.int4.dirk.core.test.injectables.BeanWithUnresolvedDependency;
import org.int4.dirk.core.test.injectables.BeanWithUnresolvedProviderDependency;
import org.int4.dirk.core.test.injectables.BeanWithUnsupportedOptionalProviderDependency;
import org.int4.dirk.core.test.injectables.BigBean;
import org.int4.dirk.core.test.injectables.BigRedBean;
import org.int4.dirk.core.test.injectables.ConstructorInjectionSample;
import org.int4.dirk.core.test.injectables.ConstructorInjectionSampleWithMultipleAnnotatedConstructors;
import org.int4.dirk.core.test.injectables.FieldInjectionSampleWithAnnotatedFinalField;
import org.int4.dirk.core.test.injectables.SampleWithAnnotatedFinalFields;
import org.int4.dirk.core.test.injectables.SampleWithMultipleAnnotatedConstructors;
import org.int4.dirk.core.test.injectables.SimpleBean;
import org.int4.dirk.core.test.injectables.SimpleChildBean;
import org.int4.dirk.core.test.injectables.SimpleCollectionItemImpl1;
import org.int4.dirk.core.test.injectables.SimpleCollectionItemImpl2;
import org.int4.dirk.core.test.injectables.SimpleCollectionItemImpl3;
import org.int4.dirk.core.test.injectables.SimpleCollectionItemInterface;
import org.int4.dirk.core.test.injectables.SimpleImpl;
import org.int4.dirk.core.test.injectables.SimpleInterface;
import org.int4.dirk.core.test.injectables.SubclassOfAbstractBean;
import org.int4.dirk.core.test.injectables.SubclassOfBeanWithInjection;
import org.int4.dirk.core.test.injectables.SubclassOfBeanWithInjectionWithSameNamedInjection;
import org.int4.dirk.core.test.injectables.UnavailableBean;
import org.int4.dirk.core.test.injectables.UnregisteredParentBean;
import org.int4.dirk.core.util.Nullable;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class InjectorTest {
    private Injector injector;

    @BeforeEach
    public void beforeEach() throws Exception {
        this.injector = Injectors.manual(new ScopeResolver[0]);
        this.injector.register(SimpleBean.class);
        this.injector.register(BeanWithInjection.class);
        this.injector.register(SimpleImpl.class);
        this.injector.register(BeanWithInterfaceBasedInjection.class);
        this.injector.register(BeanWithCollection.class);
        this.injector.register(BeanWithProvider.class);
        this.injector.register(BeanWithProviderWithoutMatch.class);
        this.injector.register(SimpleCollectionItemImpl1.class);
        this.injector.register(SimpleCollectionItemImpl2.class);
        this.injector.register(BeanWithUnregisteredParent.class);
    }

    @Test
    public void shouldGetSimpleBean() throws Exception {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(SimpleBean.class, new Object[0]));
    }

    @Test
    public void shouldThrowExceptionWhenGettingUnregisteredBean() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(ArrayList.class, new Object[0]));
    }

    @Test
    public void shouldThrowExceptionWhenBeanIsAmbiguous() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousResolutionException.class, () -> this.injector.getInstance(SimpleCollectionItemInterface.class, new Object[0]));
    }

    @Test
    public void shouldGetBeanWithInjection() throws Exception {
        BeanWithInjection bean = (BeanWithInjection)this.injector.getInstance(BeanWithInjection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.getInjectedValue());
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, bean.getInjectedValue().getClass());
    }

    @Test
    public void shouldGetBeanWithInterfaceBasedInjection() throws Exception {
        BeanWithInterfaceBasedInjection bean = (BeanWithInterfaceBasedInjection)this.injector.getInstance(BeanWithInterfaceBasedInjection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.getInjectedValue());
        org.junit.jupiter.api.Assertions.assertEquals(SimpleImpl.class, bean.getInjectedValue().getClass());
    }

    @Test
    public void shouldGetBeanWithProviderInjection() throws Exception {
        BeanWithProvider bean = (BeanWithProvider)this.injector.getInstance(BeanWithProvider.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.getSimpleBean());
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, bean.getSimpleBean().getClass());
    }

    @Test
    public void shouldGetBeanWithOptionalDependencyWhenProviderReturnsNull() throws Exception {
        this.injector.register(BeanWithOptionalDependency.class);
        this.injector.registerInstance((Object)new Provider<UnavailableBean>(){

            public UnavailableBean get() {
                return null;
            }
        }, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0]));
    }

    @Test
    public void shouldGetBeanWithOptionalDependencyWhenNoProviderAvailable() throws Exception {
        this.injector.register(BeanWithOptionalDependency.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0]));
    }

    @Test
    public void shouldLeaveDefaultFieldValuesIntactForOptionalDependencies() throws Exception {
        this.injector.register(OptionalDependent.class);
        OptionalDependent instance = (OptionalDependent)this.injector.getInstance(OptionalDependent.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)instance.string);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("A", "B", "C"), instance.stringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("A", "B", "C")), instance.stringSet);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), instance.nonOptionalStringList);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), instance.nonOptionalStringSet);
        this.injector.registerInstance((Object)"new", new Annotation[0]);
        instance = (OptionalDependent)this.injector.getInstance(OptionalDependent.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new", (Object)instance.string);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("new"), instance.stringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("new")), instance.stringSet);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("new"), instance.nonOptionalStringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("new")), instance.nonOptionalStringSet);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)"another-string", new Annotation[0])).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasMessage("Registering [Instance of [java.lang.String -> another-string]] would make existing required bindings ambiguous: [Field [private java.lang.String org.int4.dirk.core.InjectorTest$OptionalDependent.string]]; already satisfied by [Instance of [java.lang.String -> new]]").hasNoCause();
        this.injector.removeInstance((Object)"new", new Annotation[0]);
        instance = (OptionalDependent)this.injector.getInstance(OptionalDependent.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)instance.string);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("A", "B", "C"), instance.stringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("A", "B", "C")), instance.stringSet);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), instance.nonOptionalStringList);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), instance.nonOptionalStringSet);
        this.injector.registerInstance((Object)"another-string", new Annotation[0]);
        instance = (OptionalDependent)this.injector.getInstance(OptionalDependent.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"another-string", (Object)instance.string);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("another-string"), instance.stringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("another-string")), instance.stringSet);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("another-string"), instance.nonOptionalStringList);
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<String>(Arrays.asList("another-string")), instance.nonOptionalStringSet);
    }

    @Test
    public void shouldGetBeanWithOptionalConstructorDependencyWhenNoProviderAvailable() throws Exception {
        this.injector.register(BeanWithOptionalConstructorDependency.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithOptionalConstructorDependency.class, new Object[0]));
    }

    @Test
    public void shouldGetBeanWithOptionalProviderDependency() throws Exception {
        this.injector.registerInstance((Object)new Provider<UnavailableBean>(){

            public UnavailableBean get() {
                return null;
            }
        }, new Annotation[0]);
        this.injector.register(BeanWithUnsupportedOptionalProviderDependency.class);
        BeanWithUnsupportedOptionalProviderDependency instance = (BeanWithUnsupportedOptionalProviderDependency)this.injector.getInstance(BeanWithUnsupportedOptionalProviderDependency.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertNotNull(instance.getUnavailableBeanProvider());
        Assertions.assertThat((Object)((UnavailableBean)instance.getUnavailableBeanProvider().get())).isNull();
    }

    @Test
    public void shouldThrowExceptionWhenGettingUnavailableBean() throws Exception {
        this.injector.registerInstance((Object)new Provider<UnavailableBean>(){

            public UnavailableBean get() {
                return null;
            }
        }, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(UnavailableBean.class, new Object[0]));
    }

    @Test
    public void shouldRemoveBean() throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.injector.remove(BeanWithInjection.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithInjection.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRemovingInterface() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.remove(SimpleInterface.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface org.int4.dirk.core.test.injectables.SimpleInterface] cannot be abstract").hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRemovingUnregisteredBean() {
        org.junit.jupiter.api.Assertions.assertThrows(MissingDependencyException.class, () -> this.injector.remove(Exception.class));
    }

    @Test
    public void shouldThrowExceptionWhenRemovingBeanWouldViolateSingularDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> this.injector.remove(SimpleBean.class));
    }

    @Test
    public void shouldRepeatedlyThrowExceptionWhenRemovingBeanWouldViolateSingularDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> this.injector.remove(SimpleBean.class));
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> this.injector.remove(SimpleBean.class));
    }

    @Test
    public void shouldBeAbleToRemoveProviderWhichIsOnlyOptionallyDependedOn() throws Exception {
        Provider<UnavailableBean> provider = new Provider<UnavailableBean>(){

            public UnavailableBean get() {
                return new UnavailableBean();
            }
        };
        this.injector.registerInstance((Object)provider, new Annotation[0]);
        this.injector.register(BeanWithOptionalDependency.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((BeanWithOptionalDependency)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0])).getUnavailableBean());
        this.injector.removeInstance((Object)provider, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNull((Object)((BeanWithOptionalDependency)this.injector.getInstance(BeanWithOptionalDependency.class, new Object[0])).getUnavailableBean());
    }

    @Test
    public void shouldRegisterAndRemoveStringInstances() throws Exception {
        this.injector.registerInstance((Object)"a", new Annotation[0]);
        this.injector.registerInstance((Object)"b", new Annotation[0]);
        this.injector.registerInstance((Object)"c", new Annotation[0]);
        this.injector.registerInstance((Object)"d", new Annotation[0]);
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"a", "b", "c", "d"});
        this.injector.removeInstance((Object)"a", new Annotation[0]);
        this.injector.removeInstance((Object)"b", new Annotation[0]);
        this.injector.removeInstance((Object)"c", new Annotation[0]);
        this.injector.removeInstance((Object)"d", new Annotation[0]);
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).isEmpty();
    }

    @Test
    public void shouldRegisterAndRemoveSameStringInstancesWithDifferentQualifiers() throws Exception {
        this.injector.registerInstance((Object)"a", new Annotation[]{Annotations.of(Named.class, Map.of("value", "name-1"))});
        this.injector.registerInstance((Object)"a", new Annotation[]{Annotations.of(Named.class, Map.of("value", "name-2"))});
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"a", "a"});
        this.injector.removeInstance((Object)"a", new Annotation[]{Annotations.of(Named.class, Map.of("value", "name-1"))});
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"a"});
        this.injector.removeInstance((Object)"a", new Annotation[]{Annotations.of(Named.class, Map.of("value", "name-2"))});
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).isEmpty();
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringDuplicate() throws Exception {
        this.injector.register(String.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(String.class)).isExactlyInstanceOf(DuplicateDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringInterface() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(List.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface java.util.List] cannot be abstract").hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringBeanWithUnresolvedDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> this.injector.register(BeanWithUnresolvedDependency.class));
    }

    @Test
    @Disabled(value="Providers should be able to break circular dependencies...")
    public void shouldThrowExceptionWhenRegisteringBeanWithUnresolvedProviderDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> this.injector.register(BeanWithUnresolvedProviderDependency.class));
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringBeanWithAmbiguousDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousDependencyException.class, () -> this.injector.register(BeanWithDirectCollectionItemDependency.class));
    }

    @Test
    public void shouldRepeatedlyThrowExceptionWhenRegisteringBeanWithUnresolvedDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> this.injector.register(BeanWithUnresolvedDependency.class));
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> this.injector.register(BeanWithUnresolvedDependency.class));
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringBeanWouldViolateSingularDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> this.injector.register(SimpleChildBean.class));
    }

    @Test
    public void shouldRepeatedlyThrowExceptionWhenRegisteringBeanWouldViolateSingularDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> this.injector.register(SimpleChildBean.class));
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> this.injector.register(SimpleChildBean.class));
    }

    @Test
    public void shouldRespectSingletonAnnotation() throws Exception {
        SimpleBean bean1 = (SimpleBean)this.injector.getInstance(SimpleBean.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((bean1 == this.injector.getInstance(SimpleBean.class, new Object[0]) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((bean1 == ((BeanWithInjection)this.injector.getInstance(BeanWithInjection.class, new Object[0])).getInjectedValue() ? 1 : 0) != 0);
    }

    @Test
    public void shouldSupportQualifiers() throws Exception {
        this.injector.register(BigRedBean.class);
        this.injector.register(BeanWithBigInjection.class);
        this.injector.register(BeanWithBigRedInjection.class);
        this.injector.remove(BeanWithBigInjection.class);
        this.injector.remove(BeanWithBigRedInjection.class);
        this.injector.remove(BigRedBean.class);
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringDependentBeanWithNoMatchForAllQualifiers() throws Exception {
        this.injector.register(BigBean.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BeanWithBigRedInjection.class)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringBeanWithMoreQualifiersWhenItWouldViolateSingularDependencies() throws Exception {
        this.injector.register(BigBean.class);
        this.injector.register(BeanWithBigInjection.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BigRedBean.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldThrowExceptionWhenRemovingRequiredBeanWithMoreQualifiers() throws Exception {
        this.injector.register(BigRedBean.class);
        this.injector.register(BeanWithBigInjection.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.remove(BigRedBean.class)).isExactlyInstanceOf(UnsatisfiedRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldGetBeanWithInjectionWithMultipleTypeMatchesWhenDisambiguatedWithQualifier() throws Exception {
        this.injector.register(SimpleCollectionItemImpl3.class);
        this.injector.register(BeanWithDirectRedCollectionItemDependency.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithDirectRedCollectionItemDependency.class, new Object[0]));
    }

    @Test
    public void shouldCallPostConstruct() throws Exception {
        this.injector.registerInstance((Object)"Hello World", new Annotation[0]);
        this.injector.register(BeanWithPostConstruct.class);
        BeanWithPostConstruct instance = (BeanWithPostConstruct)this.injector.getInstance(BeanWithPostConstruct.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)instance.isPostConstructCalled());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)instance.isPrivatePostConstructCalled());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)instance.isPostConstructOrderCorrect());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)instance.isPrivatePostConstructOrderCorrect());
    }

    @Test
    public void shouldInjectCollection() throws Exception {
        BeanWithCollection bean = (BeanWithCollection)this.injector.getInstance(BeanWithCollection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull(bean.getInjectedValues());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getInjectedValues().size());
        this.injector.remove(SimpleCollectionItemImpl2.class);
        BeanWithCollection bean2 = (BeanWithCollection)this.injector.getInstance(BeanWithCollection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getInjectedValues().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)bean2.getInjectedValues().size());
    }

    @Test
    public void shouldInjectEmptyCollection() throws Exception {
        BeanWithCollection bean = (BeanWithCollection)this.injector.getInstance(BeanWithCollection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull(bean.getInjectedValues());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getInjectedValues().size());
        this.injector.remove(SimpleCollectionItemImpl1.class);
        this.injector.remove(SimpleCollectionItemImpl2.class);
        BeanWithCollection bean2 = (BeanWithCollection)this.injector.getInstance(BeanWithCollection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getInjectedValues().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)bean2.getInjectedValues().size());
    }

    @Test
    public void shouldInjectCollectionProvider() throws Exception {
        this.injector.register(BeanWithCollectionProvider.class);
        BeanWithCollectionProvider bean = (BeanWithCollectionProvider)this.injector.getInstance(BeanWithCollectionProvider.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull(bean.getInjectedValues());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getInjectedValues().size());
        this.injector.remove(SimpleCollectionItemImpl2.class);
        BeanWithCollectionProvider bean2 = (BeanWithCollectionProvider)this.injector.getInstance(BeanWithCollectionProvider.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)bean.getInjectedValues().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)bean2.getInjectedValues().size());
    }

    @Test
    public void shouldThrowExceptionWhenRemovingUnregisteredSuperClass() {
        org.junit.jupiter.api.Assertions.assertThrows(MissingDependencyException.class, () -> this.injector.remove(UnregisteredParentBean.class));
    }

    @Test
    public void shouldThrowExceptionWhenFinalFieldAnnotatedWithInject() throws SecurityException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(FieldInjectionSampleWithAnnotatedFinalField.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [private final org.int4.dirk.core.test.injectables.SimpleBean org.int4.dirk.core.test.injectables.FieldInjectionSampleWithAnnotatedFinalField.injectedValue] of [class org.int4.dirk.core.test.injectables.FieldInjectionSampleWithAnnotatedFinalField] cannot be final").hasNoCause();
    }

    @Test
    public void shouldInjectSetters() throws Exception {
        this.injector.register(List.of(A.class, B.class, C.class, D.class));
        A instance = (A)this.injector.getInstance(A.class, new Object[0]);
        Assertions.assertThat((Object)instance.b).isInstanceOf(B.class);
        Assertions.assertThat((Object)((C)instance.t)).isInstanceOf(C.class);
        Assertions.assertThat((Object)instance.d).isInstanceOf(D.class);
    }

    @Test
    public void shouldRejectSetterWithoutParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BadA.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [void org.int4.dirk.core.InjectorTest$BadA.setNothing()] of [class org.int4.dirk.core.InjectorTest$BadA] must have parameters").hasNoCause();
    }

    @Test
    public void shouldInjectConstructor() throws Exception {
        this.injector.register(ConstructorInjectionSample.class);
        ConstructorInjectionSample instance = (ConstructorInjectionSample)this.injector.getInstance(ConstructorInjectionSample.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        Assertions.assertThat((Object)instance.getInjectedValue()).isInstanceOf(SimpleBean.class);
    }

    @Test
    public void shouldThrowExceptionWhenMultipleConstructorsAnnotatedWithInject() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(ConstructorInjectionSampleWithMultipleAnnotatedConstructors.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.test.injectables.ConstructorInjectionSampleWithMultipleAnnotatedConstructors] cannot have multiple Inject annotated constructors").hasNoCause();
    }

    @Test
    public void shouldRegisterAndRemoveProviderInstance() throws Exception {
        Provider<String> provider = new Provider<String>(){

            public String get() {
                return "a string";
            }
        };
        this.injector.registerInstance((Object)provider, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a string", (Object)this.injector.getInstance(String.class, new Object[0]));
        this.injector.removeInstance((Object)provider, new Annotation[0]);
        Assertions.assertThatThrownBy(() -> this.injector.getInstance(String.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class);
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringProviderWouldViolateSingularDependencies() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> this.injector.registerInstance((Object)new Provider<SimpleChildBean>(){

            public SimpleChildBean get() {
                return new SimpleChildBean();
            }
        }, new Annotation[0]));
    }

    @Test
    public void shouldThrowExceptionWhenRemovingSimilarButNotSameProvider() throws Exception {
        this.injector.registerInstance((Object)new Provider<String>(){

            public String get() {
                return "a string";
            }
        }, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertThrows(MissingDependencyException.class, () -> this.injector.removeInstance((Object)new Provider<String>(){

            public String get() {
                return "a string";
            }
        }, new Annotation[0]));
    }

    @Test
    public void shouldThrowExceptionWhenRemovingProviderByClass() throws Exception {
        this.injector.registerInstance((Object)new Provider<String>(){

            public String get() {
                return "a string";
            }
        }, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertThrows(MissingDependencyException.class, () -> this.injector.remove(String.class));
    }

    @Test
    public void shouldRegisterAndRemoveInstance() throws Exception {
        this.injector.registerInstance((Object)new String("hello there!"), new Annotation[0]);
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).isNotEmpty();
        this.injector.removeInstance((Object)new String("hello there!"), new Annotation[0]);
        Assertions.assertThat((List)this.injector.getInstances(String.class, new Object[0])).isEmpty();
    }

    @Test
    public void shouldRegisterInstanceEvenWithBadAnnotations() throws Exception {
        SampleWithMultipleAnnotatedConstructors sample = new SampleWithMultipleAnnotatedConstructors();
        this.injector.registerInstance((Object)sample, new Annotation[0]);
        Assertions.assertThat((Object)((SampleWithMultipleAnnotatedConstructors)this.injector.getInstance(SampleWithMultipleAnnotatedConstructors.class, new Object[0]))).isEqualTo((Object)sample);
    }

    @Test
    public void shouldRegisterInstanceEvenWithAnnotatedFinalFields() throws Exception {
        SampleWithAnnotatedFinalFields sample = new SampleWithAnnotatedFinalFields();
        this.injector.registerInstance((Object)sample, new Annotation[0]);
        Assertions.assertThat((Object)((SampleWithAnnotatedFinalFields)this.injector.getInstance(SampleWithAnnotatedFinalFields.class, new Object[0]))).isEqualTo((Object)sample);
    }

    @Test
    public void shouldInjectSuperClass() throws Exception {
        this.injector.register(SubclassOfBeanWithInjection.class);
        SubclassOfBeanWithInjection bean = (SubclassOfBeanWithInjection)this.injector.getInstance(SubclassOfBeanWithInjection.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.injector.getInstance(SimpleBean.class, new Object[0]), (Object)bean.getInjectedValue());
    }

    @Test
    public void shouldInjectSuperAndSubClassEvenIfFieldsAreSameName() throws Exception {
        this.injector.register(SubclassOfBeanWithInjectionWithSameNamedInjection.class);
        SubclassOfBeanWithInjectionWithSameNamedInjection bean = (SubclassOfBeanWithInjectionWithSameNamedInjection)this.injector.getInstance(SubclassOfBeanWithInjectionWithSameNamedInjection.class, new Object[0]);
        SimpleBean simpleBean = (SimpleBean)this.injector.getInstance(SimpleBean.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)simpleBean, (Object)bean.getInjectedValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)simpleBean, (Object)bean.getInjectedValueInSubClass());
    }

    @Test
    public void shouldFindInstanceByAbstractSuperClass() throws Exception {
        this.injector.register(SubclassOfAbstractBean.class);
        List beans = this.injector.getInstances(AbstractBean.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)beans.size());
    }

    @Test
    public void shouldInjectSameSingletonEachTime() throws Exception {
        SimpleBean simpleBean = ((BeanWithInjection)this.injector.getInstance(BeanWithInjection.class, new Object[0])).getInjectedValue();
        org.junit.jupiter.api.Assertions.assertEquals((Object)simpleBean, (Object)((BeanWithInjection)this.injector.getInstance(BeanWithInjection.class, new Object[0])).getInjectedValue());
    }

    @Test
    public void shouldThrowConstructionExceptionWhenPostConstructHasACircularDependency() throws Exception {
        this.injector.register(BeanWithBadPostConstruct.class);
        this.injector.register(BeanDependentOnBeanWithBadPostConstruct.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithBadPostConstruct.class, new Object[0])).isExactlyInstanceOf(CreationException.class)).hasMessage("[class org.int4.dirk.core.InjectorTest$BeanWithBadPostConstruct] threw exception during post construction").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NullPointerException.class)).hasNoCause();
    }

    @Test
    @Disabled(value="This test is no longer valid; Providers are injected directly now (no indirection that could check their result) and so null instances can be part of the results if a Provider breaks its contract.")
    public void getInstancesShouldSilentlyIgnoreProvidersThatReturnNull() throws Exception {
        this.injector.registerInstance((Object)new Provider<String>(){

            public String get() {
                return null;
            }
        }, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)this.injector.getInstances(Object.class, new Object[0]).size());
    }

    @Test
    public void shouldNotAllowMultipleBeansProvidingSameInterfaceToBeRegisteredWhenThereIsABeanWithASingularDependencyOnSaidInterface() throws Exception {
        this.injector.register(Bean1.class);
        this.injector.register(BeanThatNeedsInterface.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(Bean2.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldNotAllowMultipleBeansProvidingSameInterfaceToBeRegisteredWhenThereIsABeanWithASingularDependencyOnSaidInterface_2() throws Exception {
        this.injector.register(Bean2.class);
        this.injector.register(BeanThatNeedsInterface.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(Bean1.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldNotAllowMultipleBeansProvidingSameInterfaceToBeRegisteredWhenThereIsABeanWithASingularDependencyOnSaidInterface_3() throws Exception {
        this.injector.register(Bean1.class);
        this.injector.register(BeanThatNeedsInterface.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(Bean3.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldNotAllowMultipleBeansProvidingSameInterfaceToBeRegisteredWhenThereIsABeanWithASingularDependencyOnSaidInterface_4() throws Exception {
        this.injector.register(Bean3.class);
        this.injector.register(BeanThatNeedsInterface.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(Bean1.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasNoCause();
    }

    @Test
    public void shouldInjectCorrectProvider() throws Exception {
        this.injector.register(Bean3.class);
        this.injector.register(BeanThatNeedsProviderOfSomeInterface.class);
        BeanThatNeedsProviderOfSomeInterface b = (BeanThatNeedsProviderOfSomeInterface)this.injector.getInstance(BeanThatNeedsProviderOfSomeInterface.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SomeInterface.class.isInstance(b.callProvider()));
    }

    @Test
    public void shouldInjectCorrectProvider2() throws Exception {
        this.injector.register(Bean3.class);
        this.injector.register(BeanThatNeedsProviderOfSomethingThatIsAlsoAProvider.class);
        BeanThatNeedsProviderOfSomethingThatIsAlsoAProvider b = (BeanThatNeedsProviderOfSomethingThatIsAlsoAProvider)this.injector.getInstance(BeanThatNeedsProviderOfSomethingThatIsAlsoAProvider.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Bean3.class.isInstance(b.callProvider()));
    }

    @Test
    public void postConstructShouldRejectReferringToObjectUnderConstruction() throws Exception {
        this.injector.register(BadPostConstruct.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BadPostConstruct.class, new Object[0])).isExactlyInstanceOf(CreationException.class)).hasMessage("[class org.int4.dirk.core.InjectorTest$BadPostConstruct] threw exception during post construction").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(CreationException.class)).hasMessage("[class org.int4.dirk.core.InjectorTest$BadPostConstruct] already under construction (dependency creation loop in setter, initializer or post-construct method?)").hasNoCause();
    }

    @Test
    public void shouldAutoCreateCollections() throws Exception {
        this.injector.registerInstance((Object)"A", new Annotation[0]);
        this.injector.registerInstance((Object)"B", new Annotation[0]);
        this.injector.registerInstance((Object)"C", new Annotation[0]);
        List list = (List)this.injector.getInstance((Type)Types.parameterize(List.class, (Type[])new Type[]{String.class}), new Object[0]);
        Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C"});
        Set set = (Set)this.injector.getInstance((Type)Types.parameterize(Set.class, (Type[])new Type[]{String.class}), new Object[0]);
        Assertions.assertThat((Iterable)set).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void shouldSkipNullsInCollections() throws Exception {
        this.injector.register(NullProducers.class);
        List list = (List)this.injector.getInstance((Type)Types.parameterize(List.class, (Type[])new Type[]{String.class}), new Object[0]);
        Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"B", "C"});
        Set set = (Set)this.injector.getInstance((Type)Types.parameterize(Set.class, (Type[])new Type[]{String.class}), new Object[0]);
        Assertions.assertThat((Iterable)set).containsExactlyInAnyOrder((Object[])new String[]{"B", "C"});
    }

    @Test
    void shouldRegisterParentAndSubclassWithSetterMethod() throws Exception {
        this.injector.registerInstance((Object)"A", new Annotation[0]);
        this.injector.registerInstance((Object)5, new Annotation[0]);
        this.injector.register(Parent.class);
        this.injector.register(Child.class);
    }

    public static class Child
    extends Parent {
    }

    public static class Parent {
        String x;
        Integer y;

        @Inject
        public void stuff(String x, Integer y) {
            this.x = x;
            this.y = y;
        }
    }

    static class NullProducers {
        @Produces
        String a = null;
        @Produces
        String b = "B";
        @Produces
        String c = "C";
    }

    public static class BadPostConstruct {
        @Inject
        Provider<BadPostConstruct> provider;

        @PostConstruct
        void postConstruct() {
            this.provider.get();
        }
    }

    public static class BeanThatNeedsProviderOfSomethingThatIsAlsoAProvider {
        @Inject
        Provider<Bean3> bean3;

        public Bean3 callProvider() {
            return (Bean3)this.bean3.get();
        }
    }

    public static class BeanThatNeedsProviderOfSomeInterface {
        @Inject
        Provider<SomeInterface> someInterface;

        public SomeInterface callProvider() {
            return (SomeInterface)this.someInterface.get();
        }
    }

    static class BeanThatNeedsInterface {
        @Inject
        SomeInterface someInterface;
    }

    public static class Bean3
    implements SomeInterfaceProvider {
        @Inject
        public Bean3() {
        }

        public SomeInterface get() {
            return new SomeInterface(){};
        }
    }

    static class Bean2
    implements Provider<SomeInterface> {
        @Inject
        public Bean2() {
        }

        public SomeInterface get() {
            return null;
        }
    }

    static class Bean1
    implements SomeInterface {
        @Inject
        public Bean1() {
        }
    }

    static interface SomeInterfaceProvider
    extends Provider<SomeInterface> {
    }

    static interface SomeInterface {
    }

    public static class BeanDependentOnBeanWithBadPostConstruct {
        @Inject
        private BeanWithBadPostConstruct dependency;
    }

    public static class BeanWithBadPostConstruct {
        private Provider<BeanDependentOnBeanWithBadPostConstruct> provider;

        @PostConstruct
        private void postConstruct() {
            this.provider.get();
        }
    }

    public static class BadA {
        @Inject
        void setNothing() {
        }
    }

    static class G<T> {
        T t;
        B b;

        G() {
        }

        @Inject
        private void setter(B b, T t) {
            this.b = b;
            this.t = t;
        }
    }

    public static class D {
    }

    public static class C {
    }

    public static class B {
    }

    public static class A
    extends G<C> {
        D d;
        String e;

        @Inject
        A fluentSetD(D d) {
            this.d = d;
            return this;
        }
    }

    public static class OptionalDependent {
        @Inject
        @Nullable
        private String string = "default";
        @Inject
        @Nullable
        private List<String> stringList = Arrays.asList("A", "B", "C");
        @Inject
        @Nullable
        private Set<String> stringSet = new HashSet<String>(Arrays.asList("A", "B", "C"));
        @Inject
        private List<String> nonOptionalStringList = Arrays.asList("A", "B", "C");
        @Inject
        private Set<String> nonOptionalStringSet = new HashSet<String>(Arrays.asList("A", "B", "C"));
    }
}

