/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.core.StandardInjector;
import org.int4.dirk.core.instantiation.InjectionTargetExtensions;
import org.int4.dirk.core.test.scope.Dependent;
import org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactory;
import org.int4.dirk.library.ConfigurableAnnotationStrategy;
import org.int4.dirk.library.DefaultInjectorStrategy;
import org.int4.dirk.library.NoProxyStrategy;
import org.int4.dirk.library.ProducesTypeRegistrationExtension;
import org.int4.dirk.library.ProviderTypeRegistrationExtension;
import org.int4.dirk.library.SimpleScopeStrategy;
import org.int4.dirk.library.SingletonScopeResolver;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.config.InjectorStrategy;
import org.int4.dirk.spi.config.LifeCycleCallbacksFactory;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.spi.discovery.TypeRegistrationExtension;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;

public class Injectors {
    private static final Singleton SINGLETON = (Singleton)Annotations.of(Singleton.class);
    private static final Dependent DEPENDENT = (Dependent)Annotations.of(Dependent.class);
    private static final AnnotationStrategy ANNOTATION_STRATEGY = new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, Opt.class);
    private static final Method PROVIDER_METHOD;

    public static Injector autoDiscovering(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(true, scopeResolvers);
    }

    public static Injector manual(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(false, scopeResolvers);
    }

    private static Injector createInjector(boolean autoDiscovering, ScopeResolver ... scopeResolvers) {
        AnnotationBasedLifeCycleCallbacksFactory lifeCycleCallbacksFactory = new AnnotationBasedLifeCycleCallbacksFactory(PostConstruct.class, PreDestroy.class);
        List<ScopeResolver> finalScopeResolvers = Arrays.stream(scopeResolvers).anyMatch(sr -> sr.getAnnotation().equals(SINGLETON)) ? Arrays.asList(scopeResolvers) : Stream.concat(Arrays.stream(scopeResolvers), Stream.of(new SingletonScopeResolver((Annotation)SINGLETON))).collect(Collectors.toList());
        return new StandardInjector(InjectionTargetExtensions.create(), Injectors.createTypeRegistrationExtensions(), finalScopeResolvers, (InjectorStrategy)new DefaultInjectorStrategy(ANNOTATION_STRATEGY, (ScopeStrategy)new SimpleScopeStrategy(Scope.class, (Annotation)DEPENDENT, (Annotation)SINGLETON, (Annotation)DEPENDENT), (ProxyStrategy)new NoProxyStrategy(), (LifeCycleCallbacksFactory)lifeCycleCallbacksFactory), autoDiscovering);
    }

    private static List<TypeRegistrationExtension> createTypeRegistrationExtensions() {
        ArrayList<TypeRegistrationExtension> extensions = new ArrayList<TypeRegistrationExtension>();
        extensions.add((TypeRegistrationExtension)new ProviderTypeRegistrationExtension(PROVIDER_METHOD));
        extensions.add((TypeRegistrationExtension)new ProducesTypeRegistrationExtension(Produces.class));
        return extensions;
    }

    static {
        try {
            PROVIDER_METHOD = Provider.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

