/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.Injector;
import org.int4.dirk.core.Injectors;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.junit.jupiter.api.Test;

public class LifeCycleTest {
    private static final List<Class<?>> POST_CONSTRUCTS = new ArrayList();
    private static final List<Class<?>> PRE_DESTROYS = new ArrayList();
    private final Injector injector = Injectors.manual(new ScopeResolver[0]);

    @Test
    void shouldManageLifeCycleForSingleton() throws Exception {
        this.injector.register(S.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.getInstance(S.class, new Object[0]);
        LifeCycleTest.assertPostConstructs(S.class);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.getInstance(S.class, new Object[0]);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.remove(S.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(S.class);
    }

    @Test
    void shouldManageLifeCycleForSingletonAndItsDependents() throws Exception {
        this.injector.register(G.class);
        this.injector.register(F.class);
        this.injector.register(E.class);
        this.injector.register(D.class);
        this.injector.register(DS.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.getInstance(DS.class, new Object[0]);
        LifeCycleTest.assertPostConstructs(G.class, F.class, E.class, D.class, DS.class);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.getInstance(DS.class, new Object[0]);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.remove(DS.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(DS.class, D.class, E.class);
        this.injector.remove(List.of(D.class, E.class));
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.remove(F.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(F.class, G.class);
    }

    @Test
    void shouldIgnoreExceptionsInDestroyMethods() throws Exception {
        this.injector.register(Z.class);
        this.injector.register(Y.class);
        this.injector.register(X.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.getInstance(X.class, new Object[0]);
        LifeCycleTest.assertPostConstructs(Z.class, Y.class, X.class);
        LifeCycleTest.assertPreDestroys(new Class[0]);
        this.injector.remove(X.class);
        LifeCycleTest.assertPostConstructs(new Class[0]);
        LifeCycleTest.assertPreDestroys(X.class, Y.class, Z.class);
    }

    private static void assertPostConstructs(Class<?> ... classes) {
        Assertions.assertThat(POST_CONSTRUCTS).containsExactly((Object[])classes);
        POST_CONSTRUCTS.clear();
    }

    private static void assertPreDestroys(Class<?> ... classes) {
        Assertions.assertThat(PRE_DESTROYS).containsExactly((Object[])classes);
        PRE_DESTROYS.clear();
    }

    public static class Z
    extends AbstractLifeCycleLogger {
        @PreDestroy
        void badPreDestroy() {
            throw new RuntimeException("oops Z");
        }
    }

    public static class Y
    extends AbstractLifeCycleLogger {
        @Inject
        Z z;

        @PreDestroy
        void badPreDestroy() {
            throw new RuntimeException("oops Y");
        }
    }

    @Singleton
    public static class X
    extends AbstractLifeCycleLogger {
        @Inject
        Y y;

        @PreDestroy
        void badPreDestroy() {
            throw new RuntimeException("oops X");
        }
    }

    public static class G
    extends AbstractLifeCycleLogger {
    }

    @Singleton
    public static class F
    extends AbstractLifeCycleLogger {
        @Inject
        G g;
    }

    public static class E
    extends AbstractLifeCycleLogger {
        @Inject
        F f;
    }

    public static class D
    extends AbstractLifeCycleLogger {
        @Inject
        E e;
    }

    @Singleton
    public static class DS
    extends AbstractLifeCycleLogger {
        @Inject
        D d;
    }

    @Singleton
    public static class S
    extends AbstractLifeCycleLogger {
    }

    public static abstract class AbstractLifeCycleLogger {
        @PostConstruct
        void postConstruct() {
            POST_CONSTRUCTS.add(this.getClass());
        }

        @PreDestroy
        void preDestroy() {
            PRE_DESTROYS.add(this.getClass());
        }
    }
}

