/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.ScopeConflictException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.InjectorBuilder;
import org.int4.dirk.core.test.scope.Dependent;
import org.int4.dirk.core.test.scope.TestScope;
import org.int4.dirk.extensions.proxy.ByteBuddyProxyStrategy;
import org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactory;
import org.int4.dirk.library.DefaultInjectorStrategy;
import org.int4.dirk.library.SimpleScopeStrategy;
import org.int4.dirk.spi.config.InjectorStrategy;
import org.int4.dirk.spi.config.LifeCycleCallbacksFactory;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Test;

public class ProxiedScopeTest {
    private String currentScope;
    private ScopeResolver scopeResolver = new AbstractScopeResolver<Object>(){

        public Annotation getAnnotation() {
            return Annotations.of(TestScope.class);
        }

        protected String getCurrentScope() {
            return ProxiedScopeTest.this.currentScope;
        }
    };
    private Injector injector = InjectorBuilder.builder().injectorStrategy((InjectorStrategy)new DefaultInjectorStrategy(InjectableFactories.ANNOTATION_STRATEGY, (ScopeStrategy)new SimpleScopeStrategy(Scope.class, Annotations.of(Dependent.class), Annotations.of(Singleton.class), Annotations.of(Dependent.class)), (ProxyStrategy)new ByteBuddyProxyStrategy(), (LifeCycleCallbacksFactory)new AnnotationBasedLifeCycleCallbacksFactory(PostConstruct.class, PreDestroy.class))).scopeResolvers(context -> List.of(this.scopeResolver)).autoDiscovering().defaultDiscoveryExtensions().build();

    @Test
    void getInstanceShouldNotReturnProxies() throws Exception {
        this.injector.register(B.class);
        Assertions.assertThatThrownBy(() -> this.injector.getInstance(B.class, new Object[0])).isExactlyInstanceOf(ScopeNotActiveException.class);
        this.currentScope = "A";
        B b = (B)this.injector.getInstance(B.class, new Object[0]);
        Assertions.assertThat((Object)b).isNotNull();
        Assertions.assertThat((String)b.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$B");
    }

    @Test
    void shouldCreateProxy() throws Exception {
        this.injector.register(A.class);
        A a = (A)this.injector.getInstance(A.class, new Object[0]);
        Assertions.assertThat((Object)a).isNotNull();
        Assertions.assertThatThrownBy(() -> a.b.hello()).isExactlyInstanceOf(ScopeNotActiveException.class);
        this.currentScope = "A";
        ((B)this.injector.getInstance(B.class, new Object[0])).setHelloText("Hi");
        this.currentScope = "B";
        Assertions.assertThat((String)a.b.hello()).isEqualTo("Hello");
        this.currentScope = "A";
        Assertions.assertThat((String)a.b.hello()).isEqualTo("Hi");
    }

    @Test
    void providerShouldNeverReturnProxies() throws Exception {
        this.injector.register(C.class);
        C c = (C)this.injector.getInstance(C.class, new Object[0]);
        Assertions.assertThatThrownBy(() -> c.b.get()).isExactlyInstanceOf(ScopeNotActiveException.class);
        this.currentScope = "A";
        B b = (B)c.b.get();
        Assertions.assertThat((Object)b).isNotNull();
        this.currentScope = null;
        Assertions.assertThat((String)b.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$B");
        Assertions.assertThat((String)b.hello()).isEqualTo("Hello");
    }

    @Test
    void shouldNotProxyNestedObjectWithSameScope() throws Exception {
        this.currentScope = "A";
        this.injector.register(D.class);
        D d = (D)this.injector.getInstance(D.class, new Object[0]);
        Assertions.assertThat((String)d.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$D");
        Assertions.assertThat((String)d.b.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$B");
    }

    @Test
    void shouldProxyNestedObjectWithinSingletonParent() throws Exception {
        this.currentScope = "A";
        this.injector.register(E.class);
        E e = (E)this.injector.getInstance(E.class, new Object[0]);
        Assertions.assertThat((String)e.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$E");
        Assertions.assertThat((String)e.b.getClass().getName()).doesNotEndWith((CharSequence)"ProxiedScopeTest$B");
    }

    @Test
    void shouldProxyNestedObjectWithinUnscopedParent() throws Exception {
        this.currentScope = "A";
        this.injector.register(F.class);
        F f = (F)this.injector.getInstance(F.class, new Object[0]);
        Assertions.assertThat((String)f.getClass().getName()).endsWith((CharSequence)"ProxiedScopeTest$F");
        Assertions.assertThat((String)f.b.getClass().getName()).doesNotEndWith((CharSequence)"ProxiedScopeTest$B");
    }

    @Test
    void shouldRejectProxyingFinalClass() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(G.class)).isExactlyInstanceOf(ScopeConflictException.class)).hasMessage("Type [class org.int4.dirk.core.ProxiedScopeTest$G] with scope [@org.int4.dirk.core.test.scope.Dependent()] is dependent on [class org.int4.dirk.core.ProxiedScopeTest$H] with normal scope [@org.int4.dirk.core.test.scope.TestScope()]; this requires the use of a provider or proxy").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Could not create type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot subclass primitive, array or final types: class org.int4.dirk.core.ProxiedScopeTest$H").hasNoCause();
    }

    @Test
    void exceptionsThrownByProxiedObjectShouldWorkNormally() throws Exception {
        this.injector.register(A.class);
        A a = (A)this.injector.getInstance(A.class, new Object[0]);
        this.currentScope = "A";
        Assertions.assertThatThrownBy(() -> a.b.exception()).isExactlyInstanceOf(NoSuchElementException.class);
        Assertions.assertThatThrownBy(() -> a.b.checkedException()).isExactlyInstanceOf(IOException.class);
    }

    @TestScope
    public static final class H {
    }

    public static class G {
        @Inject
        public H h;
    }

    public static class F {
        @Inject
        public B b;
    }

    @Singleton
    public static class E {
        @Inject
        public B b;
    }

    @TestScope
    public static class D {
        @Inject
        public B b;
    }

    @Singleton
    public static class C {
        @Inject
        public Provider<B> b;
    }

    @TestScope
    public static class B {
        private String text = "Hello";

        public void setHelloText(String text) {
            this.text = text;
        }

        protected String hello() {
            return this.text;
        }

        public String exception() {
            throw new NoSuchElementException("5");
        }

        public String checkedException() throws IOException {
            throw new IOException();
        }
    }

    @Singleton
    public static class A {
        @Inject
        public B b;
    }
}

