/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.InjectionTargetExtensionStores;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.BindingProvider;
import org.int4.dirk.core.test.qualifiers.Big;
import org.int4.dirk.core.test.qualifiers.Green;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.library.ConfigurableAnnotationStrategy;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class BindingProviderTest {
    private static final Annotation RED = Annotations.of(Red.class);
    private static final Annotation GREEN = Annotations.of(Green.class);
    private BindingProvider bindingProvider = new BindingProvider((AnnotationStrategy)new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, null), InjectionTargetExtensionStores.create());

    @Test
    public void ofMembersShouldBindToGenericFieldInSubclass() throws Exception {
        List bindings = this.bindingProvider.ofMembers(Subclass.class);
        Assertions.assertThat((List)bindings).extracting(new Function[]{Binding::getAccessibleObject, Binding::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ClassWithGenericFields.class.getDeclaredField("fieldA"), String.class}), Tuple.tuple((Object[])new Object[]{ClassWithGenericFields.class.getDeclaredMethod("setterB", Object.class), Integer.class})});
    }

    @Test
    public void ofMethodShouldCreateCorrectBindings() throws Exception {
        List bindings = this.bindingProvider.ofMethod(Subclass.class.getDeclaredMethod("create", Integer.class, Double.class), Subclass.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)bindings.size());
        org.junit.jupiter.api.Assertions.assertEquals(Integer.class, (Object)((Binding)bindings.get(0)).getType());
        org.junit.jupiter.api.Assertions.assertEquals(Double.class, (Object)((Binding)bindings.get(1)).getType());
        org.junit.jupiter.api.Assertions.assertEquals(Subclass.class, (Object)((Binding)bindings.get(2)).getType());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of((Big)Annotations.of(Big.class)), (Object)((Binding)bindings.get(0)).getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(), (Object)((Binding)bindings.get(1)).getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(), (Object)((Binding)bindings.get(2)).getQualifiers());
    }

    @Test
    public void ofMethodShouldTakeNonStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofMethod(MethodHolder.class.getDeclaredMethod("create", Double.class), MethodHolder.class)).extracting(Binding::getType).containsExactly((Object[])new Type[]{Double.class, MethodHolder.class});
    }

    @Test
    public void ofMethodShouldTakeStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofMethod(MethodHolder.class.getDeclaredMethod("createStatic", Double.class), MethodHolder.class)).extracting(Binding::getType).containsExactly((Object[])new Type[]{Double.class});
    }

    @Test
    public void ofFieldShouldTakeNonStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofField(FieldHolder.class.getDeclaredField("b"), FieldHolder.class)).extracting(Binding::getType).containsExactly((Object[])new Type[]{FieldHolder.class});
    }

    @Test
    public void ofFieldShouldTakeStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofField(FieldHolder.class.getDeclaredField("a"), FieldHolder.class)).isEmpty();
    }

    @Test
    public void getConstructorShouldFindInjectAnnotatedConstructor() throws Exception {
        Assertions.assertThat((Object)this.bindingProvider.getConstructor(ClassA.class)).isEqualTo(ClassA.class.getDeclaredConstructor(ClassB.class));
    }

    @Test
    public void getConstructorShouldFindDefaultConstructor() throws Exception {
        Assertions.assertThat((Object)this.bindingProvider.getConstructor(ClassB.class)).isEqualTo(ClassB.class.getConstructor(new Class[0]));
    }

    @Test
    public void getConstructorShouldRejectClassWithoutPublicDefaultConstructor() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.getConstructor(ClassC.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.BindingProviderTest$ClassC] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
    }

    @Test
    public void getConstructorShouldRejectClassWithMultipleAnnotatedConstructors() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.getConstructor(ClassD.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.BindingProviderTest$ClassD] cannot have multiple Inject annotated constructors").hasNoCause();
    }

    @Test
    public void ofMembersShouldRejectFinalField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.ofMembers(ClassF.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [final java.lang.String org.int4.dirk.core.definition.BindingProviderTest$ClassF.x] of [class org.int4.dirk.core.definition.BindingProviderTest$ClassF] cannot be final").hasNoCause();
    }

    @Test
    public void ofConstructorAndMembersShouldFindAllBindings() throws Exception {
        List bindings = this.bindingProvider.ofConstructorAndMembers(ClassA.class.getDeclaredConstructor(ClassB.class), ClassA.class);
        Assertions.assertThat((List)bindings).extracting(new Function[]{Binding::getType, Binding::getQualifiers}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ClassB.class, Set.of()}), Tuple.tuple((Object[])new Object[]{String.class, Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Provider.class, (Type[])new Type[]{Integer.class}), Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(List.class, (Type[])new Type[]{Double.class}), Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Set.class, (Type[])new Type[]{String.class}), Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(List.class, (Type[])new Type[]{Double.class}), Set.of(RED)}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Set.class, (Type[])new Type[]{String.class}), Set.of(RED)}), Tuple.tuple((Object[])new Object[]{Types.parameterize(List.class, (Type[])new Type[]{Double.class}), Set.of(GREEN)}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Set.class, (Type[])new Type[]{String.class}), Set.of(GREEN)}), Tuple.tuple((Object[])new Object[]{Long.class, Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Provider.class, (Type[])new Type[]{Short.class}), Set.of()}), Tuple.tuple((Object[])new Object[]{Types.parameterize(Provider.class, (Type[])new Type[]{Short.class}), Set.of()})});
    }

    @Test
    @Disabled
    public void shouldNotCreateBindingForOverridenParentMethod() throws Exception {
        List bindings = this.bindingProvider.ofMembers(SpecializedChild.class);
        Assertions.assertThat((List)bindings).hasSize(2);
    }

    @Test
    public void bindingsOfChildShouldNotMatchBindingsOfParent() throws Exception {
        List parentBindings = this.bindingProvider.ofMembers(Parent.class);
        List childBindings = this.bindingProvider.ofMembers(Child.class);
        Assertions.assertThat((List)childBindings).doesNotContainAnyElementsOf((Iterable)parentBindings);
    }

    public static class SpecializedChild
    extends Parent {
        @Override
        @Inject
        public void setDescription(String x) {
            super.setDescription(x);
        }
    }

    public static class Child
    extends Parent {
    }

    public static class Parent {
        @Inject
        String y;
        String x;
        String d;

        @Inject
        public void setText(String x) {
            this.x = x;
        }

        @Inject
        public void setDescription(String d) {
            this.d = d;
        }
    }

    public static class ClassF {
        @Inject
        final String x = "";
    }

    public static class ClassE {
        @Inject
        Provider<Provider<String>> x;

        @Inject
        ClassE(Provider<Provider<String>> provider) {
        }
    }

    public static class ClassD {
        @Inject
        ClassD() {
        }

        @Inject
        ClassD(int a, int b, int c) {
        }
    }

    public static class ClassC {
        ClassC() {
        }
    }

    public static class ClassB {
    }

    public static class ClassA {
        ClassB classB;
        @Inject
        String x;
        @Inject
        Provider<Integer> y;
        @Inject
        List<Double> doubles;
        @Inject
        Set<String> strings;
        @Inject
        @Opt
        @Red
        List<Double> optionalRedDoubles;
        @Inject
        @Opt
        @Red
        Set<String> optoinalRedStrings;
        @Inject
        @Green
        List<Double> emptyGreenDoubles;
        @Inject
        @Green
        Set<String> emptyGreenStrings;
        @Inject
        @Opt
        long z = 15L;
        @Inject
        Provider<Short> p;
        @Inject
        @Opt
        Provider<Short> q;

        @Inject
        ClassA(ClassB classB) {
            this.classB = classB;
        }

        ClassA(int a, int b, int c) {
        }
    }

    public static class FieldHolder {
        public static String a;
        public String b;
    }

    public static class MethodHolder {
        public static String createStatic(Double x) {
            return "" + x;
        }

        public String create(Double x) {
            return "" + x;
        }
    }

    private static class Subclass
    extends ClassWithGenericFields<String, Integer> {
        private Subclass() {
        }

        public String create(@Big Integer dep1, Double dep2) {
            return null;
        }
    }

    private static class ClassWithGenericFields<A, B> {
        @Inject
        private A fieldA;
        private B fieldB;

        private ClassWithGenericFields() {
        }

        @Inject
        void setterB(B b) {
            this.fieldB = b;
        }
    }
}

