/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.Bindings;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.core.test.scope.Dependent;
import org.int4.dirk.core.test.scope.TestScope;
import org.int4.dirk.core.util.Nullable;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Test;

public class ClassInjectableFactoryTest {
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final ClassInjectableFactory factory = this.injectableFactories.forClass();

    @Test
    public void createShouldAcceptValidParameters() throws Exception {
        Injectable injectable = this.factory.create(SimpleClass.class);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleClass.class, (Object)injectable.getType());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)injectable.getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Annotations.of(Singleton.class), (Object)injectable.getScopeResolver().getAnnotation());
        Assertions.assertThat((List)injectable.getBindings()).hasSize(0);
        Injectable injectable2 = this.factory.create(ClassWithDependencies.class);
        org.junit.jupiter.api.Assertions.assertEquals(ClassWithDependencies.class, (Object)injectable2.getType());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton(ClassWithDependencies.class.getAnnotation(Red.class)), (Object)injectable2.getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Annotations.of(Dependent.class), (Object)injectable2.getScopeResolver().getAnnotation());
        Assertions.assertThat((List)injectable2.getBindings()).hasSize(4);
        ClassWithDependencies instance = (ClassWithDependencies)injectable2.create(Bindings.resolve(injectable2.getBindings(), 2, 4L, null, "a string"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a string", (Object)instance.s);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance.a);
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)instance.b);
        org.junit.jupiter.api.Assertions.assertNull((Object)instance.bd);
        instance = (ClassWithDependencies)injectable2.create(Bindings.resolve(injectable2.getBindings(), 2, 4L, new BigDecimal(5), "a string"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new BigDecimal(5), (Object)instance.bd);
    }

    @Test
    public void createShouldRejectNullInjectableClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create((Type)null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("type cannot be null").hasNoCause();
    }

    @Test
    public void createShouldRejectInterfaceAsInjectableClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(SimpleInterface.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface org.int4.dirk.core.definition.ClassInjectableFactoryTest$SimpleInterface] cannot be abstract").hasNoCause();
    }

    @Test
    public void createShouldRejectAbstractClassAsInjectableClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(SimpleAbstractClass.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.ClassInjectableFactoryTest$SimpleAbstractClass] cannot be abstract").hasNoCause();
    }

    @Test
    public void createShouldRejectInjectableClassWithoutConstructors() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(ClassWithoutPublicConstructors.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.ClassInjectableFactoryTest$ClassWithoutPublicConstructors] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
    }

    @Test
    public void createShouldRejectInjectableClassWithMultipleAnnotatedConstructors() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(ClassWithTooManyAnnotatedConstructors.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.ClassInjectableFactoryTest$ClassWithTooManyAnnotatedConstructors] cannot have multiple Inject annotated constructors").hasNoCause();
    }

    @Test
    public void createShouldRejectInjectableClassWithAnnotatedFinalFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(ClassWithAnnotatedFinalField.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [private final java.lang.String org.int4.dirk.core.definition.ClassInjectableFactoryTest$ClassWithAnnotatedFinalField.a] of [class org.int4.dirk.core.definition.ClassInjectableFactoryTest$ClassWithAnnotatedFinalField] cannot be final").hasNoCause();
    }

    @Test
    public void createShouldRejectInjectableClassWithMultipleScopes() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(ClassWithMultipleScopes.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.ClassInjectableFactoryTest$ClassWithMultipleScopes] cannot have multiple scope annotations, but found: [@jakarta.inject.Singleton(), @org.int4.dirk.core.test.scope.TestScope()]").hasNoCause();
    }

    @Test
    public void createShouldRejectInjectableClassWithTypeParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(GenericClass.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class org.int4.dirk.core.definition.ClassInjectableFactoryTest$GenericClass] cannot have unresolvable type variables: [T]").hasNoCause();
    }

    public static class GenericClass<T> {
        T t;
    }

    @TestScope
    @Singleton
    public static class ClassWithMultipleScopes {
    }

    public static class ClassWithAnnotatedFinalField {
        @Inject
        private final String a = "";
    }

    public static class ClassWithTooManyAnnotatedConstructors {
        @Inject
        public ClassWithTooManyAnnotatedConstructors(String a) {
        }

        @Inject
        public ClassWithTooManyAnnotatedConstructors(String b, String c) {
        }
    }

    private static class ClassWithoutPublicConstructors {
        private ClassWithoutPublicConstructors() {
        }
    }

    public static abstract class SimpleAbstractClass {
    }

    public static interface SimpleInterface {
    }

    @Red
    public static class ClassWithDependencies {
        @Inject
        String s;
        int a;
        long b;
        BigDecimal bd;

        @Inject
        public ClassWithDependencies(Integer a, Long b, @Nullable BigDecimal bd) {
            this.a = a;
            this.b = b;
            this.bd = bd;
        }
    }

    @Singleton
    public static class SimpleClass {
    }
}

