/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Queue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Bindings;
import org.int4.dirk.core.definition.FieldInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.junit.jupiter.api.Test;

public class FieldInjectableFactoryTest {
    private final FieldInjectableFactory factory = new InjectableFactories().forField();

    @Test
    void createShouldRejectNullField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(null, A.class)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("field cannot be null").hasNoCause();
    }

    @Test
    void createShouldRejectNullOwnerType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredField("a"), null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType cannot be null").hasNoCause();
    }

    @Test
    void createShouldRejectIncompatibleOwnerType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredField("a"), B.class)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType must be assignable to member's declaring class: class org.int4.dirk.core.definition.FieldInjectableFactoryTest$B; declaring class: class org.int4.dirk.core.definition.FieldInjectableFactoryTest$A").hasNoCause();
    }

    @Test
    void createShouldRejectFieldWithUnresolvableReturnType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(B.class.getDeclaredField("b"), B.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [public java.lang.Object org.int4.dirk.core.definition.FieldInjectableFactoryTest$B.b] has unresolvable return type").hasNoCause();
    }

    @Test
    void createShouldRejectFieldWithUnresolvableTypeVariables() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(B.class.getDeclaredField("d"), B.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [public java.util.Queue org.int4.dirk.core.definition.FieldInjectableFactoryTest$B.d] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.Queue<T>] cannot have unresolvable type variables or wild cards").hasNoCause();
    }

    @Test
    void createShouldRejectFieldAnnotatedWithInject() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredField("c"), A.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [java.lang.String org.int4.dirk.core.definition.FieldInjectableFactoryTest$A.c] should not have an inject annotation, but found: [@jakarta.inject.Inject()]").hasNoCause();
    }

    @Test
    void createShouldAcceptValidParameters() throws NoSuchFieldException, SecurityException, DefinitionException {
        Injectable injectable = this.factory.create(C.class.getField("b"), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
    }

    @Test
    void createShouldReturnCorrectInjectableForNonStaticField() throws Exception {
        Injectable injectable = this.factory.create(C.class.getField("b"), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
        Assertions.assertThat((List)injectable.getBindings()).extracting(Object::toString).containsExactly((Object[])new String[]{"Owner Type [class org.int4.dirk.core.definition.FieldInjectableFactoryTest$C]"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bye", (Object)injectable.create(Bindings.resolve(injectable.getBindings(), new C())));
    }

    @Test
    void createShouldReturnCorrectInjectableForStaticField() throws Exception {
        Injectable injectable = this.factory.create(C.class.getField("e"), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
        Assertions.assertThat((List)injectable.getBindings()).isEmpty();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello", (Object)injectable.create(Bindings.resolve(injectable.getBindings(), new Object[0])));
    }

    static class C
    extends B<String> {
        public static String e = "Hello";

        C() {
        }
    }

    static class B<T> {
        public T b = "Bye";
        public Queue<T> d;

        B() {
        }
    }

    static class A {
        String a;
        @Inject
        String c;

        A() {
        }
    }
}

