/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.InstanceInjectableFactory;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Test;

public class InstanceInjectableFactoryTest {
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final InstanceInjectableFactory factory = this.injectableFactories.forInstance();

    @Test
    void createShouldRejectNullField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(null, new Annotation[0])).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("instance cannot be null").hasNoCause();
    }

    @Test
    void createShouldReturnInjectable() throws Exception {
        Injectable injectable = this.factory.create((Object)"Hello World", new Annotation[0]);
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(String.class);
        Assertions.assertThat((List)injectable.getBindings()).isEmpty();
        Assertions.assertThat((Object)injectable.getScopeResolver().getAnnotation()).isEqualTo((Object)Annotations.of(Singleton.class));
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("Hello World");
    }
}

