/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;

public class KeyTest {
    @Test
    void constructorShouldAcceptValidParameters() {
        Key key = new Key(String.class);
        Assertions.assertThat((Object)key.getType()).isEqualTo(String.class);
        Assertions.assertThat((Iterable)key.getQualifiers()).isEmpty();
        Assertions.assertThat((String)key.toString()).isEqualTo("java.lang.String");
        key = new Key((Type)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class)));
        Assertions.assertThat((Object)key.getType()).isEqualTo((Object)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Iterable)key.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((String)key.toString()).isEqualTo("@org.int4.dirk.core.definition.KeyTest$Green() @org.int4.dirk.core.definition.KeyTest$Red() java.util.function.Supplier<java.lang.String>");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Key(null, Set.of(Annotations.of(Red.class)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("type cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Key(String.class, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiers cannot be null").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() {
        EqualsVerifier.forClass(Key.class).withNonnullFields(new String[]{"type", "qualifiers"}).verify();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface Green {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface Red {
    }
}

