/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Inject;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Bindings;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.junit.jupiter.api.Test;

public class MethodInjectableFactoryTest {
    private final MethodInjectableFactory factory = new InjectableFactories().forMethod();

    @Test
    void createShouldRejectNullMethod() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(null, A.class)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("method cannot be null").hasNoCause();
    }

    @Test
    void createShouldRejectNullOwnerType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredMethod("a", new Class[0]), null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType cannot be null").hasNoCause();
    }

    @Test
    void createShouldRejectIncompatibleOwnerType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredMethod("a", new Class[0]), B.class)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType must be assignable to declaring class: class org.int4.dirk.core.definition.MethodInjectableFactoryTest$B; declaring class: class org.int4.dirk.core.definition.MethodInjectableFactoryTest$A").hasNoCause();
    }

    @Test
    void createShouldRejectMethodWithUnresolvableReturnType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(B.class.getDeclaredMethod("b", new Class[0]), B.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [public java.lang.Object org.int4.dirk.core.definition.MethodInjectableFactoryTest$B.b()] has unresolvable return type").hasNoCause();
    }

    @Test
    void createShouldRejectMethodWithUnresolvableTypeVariables() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(B.class.getDeclaredMethod("d", new Class[0]), B.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [public java.util.Queue org.int4.dirk.core.definition.MethodInjectableFactoryTest$B.d()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.Queue<T>] cannot have unresolvable type variables or wild cards").hasNoCause();
    }

    @Test
    void createShouldRejectVoidMethod() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredMethod("a", new Class[0]), A.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [void org.int4.dirk.core.definition.MethodInjectableFactoryTest$A.a()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.lang.Void] cannot be void or Void").hasNoCause();
    }

    @Test
    void createShouldRejectMethodAnnotatedWithInject() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(A.class.getDeclaredMethod("c", new Class[0]), A.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [java.lang.String org.int4.dirk.core.definition.MethodInjectableFactoryTest$A.c()] should not have an inject annotation, but found: [@jakarta.inject.Inject()]").hasNoCause();
    }

    @Test
    void createShouldAcceptValidParameters() throws Exception {
        Injectable injectable = this.factory.create(C.class.getMethod("b", new Class[0]), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
    }

    @Test
    void createShouldReturnCorrectInjectableForNonStaticMethod() throws Exception {
        Injectable injectable = this.factory.create(C.class.getMethod("b", new Class[0]), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
        Assertions.assertThat((List)injectable.getBindings()).extracting(Object::toString).containsExactly((Object[])new String[]{"Owner Type [class org.int4.dirk.core.definition.MethodInjectableFactoryTest$C]"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bye", (Object)injectable.create(Bindings.resolve(injectable.getBindings(), new C())));
    }

    @Test
    void createShouldReturnCorrectInjectableForStaticMethodWithOneParameter() throws Exception {
        Injectable injectable = this.factory.create(C.class.getMethod("e", D.class), C.class);
        org.junit.jupiter.api.Assertions.assertEquals(String.class, (Object)injectable.getType());
        Assertions.assertThat((List)injectable.getBindings()).extracting(Object::toString).containsExactly((Object[])new String[]{"Parameter 0 [class org.int4.dirk.core.definition.MethodInjectableFactoryTest$D] of [public static java.lang.String org.int4.dirk.core.definition.MethodInjectableFactoryTest$C.e(org.int4.dirk.core.definition.MethodInjectableFactoryTest$D)]"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello D", (Object)injectable.create(Bindings.resolve(injectable.getBindings(), new D())));
    }

    static class D {
        D() {
        }
    }

    static class C
    extends B<String> {
        C() {
        }

        public static String e(D d) {
            return "Hello " + d.getClass().getSimpleName();
        }
    }

    static class B<T> {
        B() {
        }

        public T b() {
            return (T)"Bye";
        }

        public Queue<T> d() {
            return new ArrayDeque();
        }
    }

    static class A {
        A() {
        }

        void a() {
        }

        @Inject
        String c() {
            return "";
        }
    }
}

