/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.QualifiedType;
import org.int4.dirk.core.test.qualifiers.Green;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.Test;

public class QualifiedTypeTest {
    @Test
    void constructorShouldAcceptValidParameters() throws BadQualifiedTypeException {
        QualifiedType key = new QualifiedType(String.class);
        Assertions.assertThat((Object)key.getType()).isEqualTo(String.class);
        Assertions.assertThat((Iterable)key.getQualifiers()).isEmpty();
        Assertions.assertThat((String)key.toString()).isEqualTo("java.lang.String");
        key = new QualifiedType((Type)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class)));
        Assertions.assertThat((Object)key.getType()).isEqualTo((Object)Types.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Iterable)key.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((String)key.toString()).isEqualTo("@org.int4.dirk.core.test.qualifiers.Green() @org.int4.dirk.core.test.qualifiers.Red() java.util.function.Supplier<java.lang.String>");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(null, Set.of(Annotations.of(Red.class)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("type cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(String.class, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiers cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(Void.TYPE, Set.of(Annotations.of(Singleton.class)))).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[@jakarta.inject.Singleton() java.lang.Void] cannot be void or Void").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(List.class)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.List] cannot have unresolvable type variables or wild cards").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType((Type)Types.wildcardExtends((Type[])new Type[]{String.class}))).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[? extends java.lang.String] cannot have unresolvable type variables or wild cards").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() {
        EqualsVerifier.forClass(QualifiedType.class).withNonnullFields(new String[]{"type", "qualifiers"}).verify();
    }
}

