/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.store;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.api.definition.AmbiguousDependencyException;
import org.int4.dirk.api.definition.AmbiguousRequiredDependencyException;
import org.int4.dirk.api.definition.CyclicDependencyException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedRequiredDependencyException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.store.InjectableStore;
import org.int4.dirk.core.test.scope.TestScope;
import org.int4.dirk.core.util.Nullable;
import org.int4.dirk.spi.scope.UnknownScopeException;
import org.int4.dirk.test.util.ReplaceCamelCaseDisplayNameGenerator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=ReplaceCamelCaseDisplayNameGenerator.class)
public class InjectableStoreConsistencyTest {
    private final ClassInjectableFactory classInjectableFactory = new InjectableFactories().forClass();
    private Injectable<A> a;
    private Injectable<B> b;
    private Injectable<C> c;
    private Injectable<D> d;
    private Injectable<E> e;
    private Injectable<F> f;
    private Injectable<G> g;
    private Injectable<H> h;
    private Injectable<I> i;
    private Injectable<J> j;
    private Injectable<L> l;
    private Injectable<M> m;
    private Injectable<N> n;
    private Injectable<O> o;
    private InjectableStore store = new InjectableStore(InjectableFactories.PROXY_STRATEGY);

    @BeforeEach
    void beforeEach() throws DefinitionException {
        this.a = this.classInjectableFactory.create(A.class);
        this.b = this.classInjectableFactory.create(B.class);
        this.c = this.classInjectableFactory.create(C.class);
        this.d = this.classInjectableFactory.create(D.class);
        this.e = this.classInjectableFactory.create(E.class);
        this.f = this.classInjectableFactory.create(F.class);
        this.g = this.classInjectableFactory.create(G.class);
        this.h = this.classInjectableFactory.create(H.class);
        this.i = this.classInjectableFactory.create(I.class);
        this.j = this.classInjectableFactory.create(J.class);
        this.l = this.classInjectableFactory.create(L.class);
        this.m = this.classInjectableFactory.create(M.class);
        this.n = this.classInjectableFactory.create(N.class);
        this.o = this.classInjectableFactory.create(O.class);
    }

    @Test
    void shouldThrowExceptionWhenClassInjectableAddedWithUnknownScope() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.store.putAll(Set.of(this.classInjectableFactory.create(K.class)))).isExactlyInstanceOf(UnknownScopeException.class)).hasNoCause();
    }

    @Test
    void addAllShouldRejectInjectablesWithCyclicDependency() {
        org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.e, this.b, this.c, this.d)));
    }

    @Test
    void addBShouldFailAsItHasUnresolvableDependency() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> this.store.putAll(List.of(this.b)));
    }

    @Test
    void addAAndBAndHShouldFailsAsThereAreMultipleCandidatesOfZForB() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousDependencyException.class, () -> this.store.putAll(List.of(this.a, this.b, this.h)));
    }

    @Test
    void addAAndBAndHShouldFailsAsItThereAreMultipleCandidatesOfZForB2() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousDependencyException.class, () -> this.store.putAll(List.of(this.b, this.a, this.h)));
    }

    @Test
    void addAAndBAndHShouldFailsAsItThereAreMultipleCandidatesOfZForB3() {
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousDependencyException.class, () -> this.store.putAll(List.of(this.a, this.h, this.b)));
    }

    @Test
    void addIShouldFail() {
        org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.i)));
    }

    @Test
    void addJShouldFail() {
        org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.j)));
    }

    @Test
    void addLShouldWork() throws DependencyException {
        this.store.putAll(List.of(this.l));
    }

    @Test
    void addLAndAShouldWork() throws DependencyException {
        this.store.putAll(List.of(this.l, this.a));
    }

    public static class O {
        @Inject
        M m;
    }

    public static class N {
        @Inject
        M m;
    }

    public static class M {
        @Inject
        Provider<N> n;
        @Inject
        @Opt
        Provider<O> o;
    }

    public static class L {
        @Inject
        @Nullable
        Z z;
    }

    @TestScope
    public static class K {
    }

    public static class J
    implements Z {
        @Inject
        Z z;
    }

    public static class I {
        @Inject
        I i;
    }

    public static class H
    implements Z {
    }

    public static class G {
        @Inject
        F f;
    }

    public static class F {
        @Inject
        B b;
        @Inject
        C c;
    }

    public static class D {
        @Inject
        C c;
    }

    public static class C {
        @Inject
        B b;
        @Inject
        @Opt
        Provider<D> d;
    }

    public static class B {
        @Inject
        Z z;
    }

    public static class E
    extends A {
        @Inject
        D d;
    }

    public static class A
    implements Z {
    }

    static interface Z {
    }

    @Nested
    class WhenClassesMAndNAndOAreAdded {
        WhenClassesMAndNAndOAreAdded() {
        }

        @BeforeEach
        void beforeEach() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.m, InjectableStoreConsistencyTest.this.n, InjectableStoreConsistencyTest.this.o));
        }

        @Test
        void removeMShouldFailAsRequiredByN() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.m)));
        }

        @Test
        void removeNShouldFailAsRequiredByM() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.n)));
        }

        @Test
        void removeOShouldWorkAsMOnlyDependsOnItOptionally() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.o));
        }
    }

    @Nested
    class WhenClassesAAndBAndCAndDAreAdded {
        WhenClassesAAndBAndCAndDAreAdded() {
        }

        @BeforeEach
        void beforeEach() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.b, InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeAllShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.b, InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeAShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.a)));
        }

        @Test
        void removeBShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.b)));
        }

        @Test
        void removeCShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c)));
        }

        @Test
        void removeAAndCAndDShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.d)));
        }

        @Test
        void removeDShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeCAndDShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void addEShouldFailAsEWouldCreateCyclicDependency() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.e)));
        }

        @Test
        void addGAndFAndEShouldFailAsEWouldCreateCyclicDependency() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.f, InjectableStoreConsistencyTest.this.e)));
        }

        @Test
        void addFShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.f));
        }

        @Test
        void addGAndFShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.f));
        }

        @Test
        void addHShouldFailAsZWouldBeProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.h)));
        }

        @Test
        void addGAndFAndHShouldFailAsZWouldBeProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.h, InjectableStoreConsistencyTest.this.f)));
        }

        @Test
        void addLShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l));
        }
    }

    @Nested
    class When_L_IsAdded {
        When_L_IsAdded() {
        }

        @BeforeEach
        void beforeEach() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l));
        }

        @Test
        void remove_L_ShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.l));
        }

        @Test
        void add_A_ShouldWork() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a));
        }

        @Test
        void add_A_and_H_ShouldFailBecause_Z_IsProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.h)));
        }
    }

    @Nested
    class WhenClasses_A_And_H_AreAdded {
        WhenClasses_A_And_H_AreAdded() {
        }

        @BeforeEach
        void beforeEach() throws DependencyException {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.h));
        }

        @Test
        void add_L_ShouldFailBecause_Z_IsProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(AmbiguousDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l)));
        }
    }
}

