/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.store;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.definition.QualifiedType;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.store.InjectableStore;
import org.int4.dirk.core.util.Nullable;
import org.int4.dirk.spi.instantiation.TypeTrait;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InjectorStoreConsistencyPolicyLargeGraphTest {
    private final Random rnd = new Random(4L);

    @Test
    void largeGraphTest() throws BadQualifiedTypeException, DependencyException {
        InjectableStore store = new InjectableStore(InjectableFactories.PROXY_STRATEGY);
        ArrayList<1> knownInjectables = new ArrayList<1>();
        List<Class> classes = List.of(String.class, Integer.class, A.class, B.class, C.class, D.class, E.class, F.class, G.class, H.class, I.class, J.class);
        final ExtendedScopeResolver scopeResolver = (ExtendedScopeResolver)Mockito.mock(ExtendedScopeResolver.class);
        for (int i = 0; i < 10000; ++i) {
            store.checkInvariants();
            int randomBindings = Math.min(this.rnd.nextInt(4), knownInjectables.size());
            final ArrayList<SimpleBinding> bindings = new ArrayList<SimpleBinding>();
            for (int j = 0; j < randomBindings; ++j) {
                Injectable target = (Injectable)knownInjectables.get(this.rnd.nextInt(knownInjectables.size()));
                bindings.add(new SimpleBinding(new Key(target.getType(), (Collection)target.getQualifiers())));
            }
            final QualifiedType qualifiedType = new QualifiedType((Type)classes.get(this.rnd.nextInt(classes.size())), Set.of(Annotations.of(Named.class, Map.of("value", "instance-" + i))));
            Injectable<Object> injectable = new Injectable<Object>(){

                public Type getType() {
                    return qualifiedType.getType();
                }

                public Set<Type> getTypes() {
                    return Set.of(qualifiedType.getType());
                }

                public Set<Annotation> getQualifiers() {
                    return qualifiedType.getQualifiers();
                }

                public List<Binding> getBindings() {
                    return bindings;
                }

                public ExtendedScopeResolver getScopeResolver() {
                    return scopeResolver;
                }

                public Object create(List<Injection> injections) {
                    return null;
                }

                public void destroy(Object instance) {
                }
            };
            store.putAll(List.of(injectable));
            knownInjectables.add(injectable);
        }
    }

    public static class K
    implements Z {
        @Inject
        A a;
    }

    public static class J {
        @Inject
        Provider<Z> h;
    }

    public static class I {
        @Inject
        Z z;
        @Inject
        E e;
    }

    public static class H
    implements Z {
    }

    public static class G {
        @Inject
        K k;
    }

    public static class F {
        @Inject
        B b;
        @Inject
        C c;
        @Inject
        @Nullable
        Z z;
    }

    public static class D
    implements Z {
        @Inject
        C c;
    }

    public static class C {
        @Inject
        B b;
        @Inject
        @Opt
        Provider<D> d;
    }

    public static class B {
        @Inject
        Z z;
    }

    public static class E
    extends A {
    }

    public static class A {
    }

    static interface Z {
    }

    private static class SimpleBinding
    implements Binding {
        private final Key key;

        public SimpleBinding(Key key) {
            this.key = key;
        }

        public Type getType() {
            return this.key.getType();
        }

        public boolean isOptional() {
            return false;
        }

        public AccessibleObject getAccessibleObject() {
            return null;
        }

        public Parameter getParameter() {
            return null;
        }

        public Key getElementKey() {
            return this.key;
        }

        public Set<TypeTrait> getTypeTraits() {
            return Set.of();
        }

        public <T> T associateIfAbsent(String key, Supplier<T> valueSupplier) {
            return null;
        }
    }
}

