/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.store;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DuplicateDependencyException;
import org.int4.dirk.api.definition.MissingDependencyException;
import org.int4.dirk.core.InjectableFactories;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.FieldInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.InstanceInjectableFactory;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.int4.dirk.core.store.QualifiedTypeStore;
import org.int4.dirk.core.test.injectables.BeanWithBigRedInjection;
import org.int4.dirk.core.test.injectables.BigRedBean;
import org.int4.dirk.core.test.qualifiers.Big;
import org.int4.dirk.core.test.qualifiers.Red;
import org.int4.dirk.core.test.qualifiers.Small;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.TypeReference;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QualifiedTypeStoreTest {
    private static final Annotation RED = Annotations.of(Red.class);
    private static final Annotation BIG = Annotations.of(Big.class);
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();
    private final FieldInjectableFactory fieldInjectableFactory = this.injectableFactories.forField();
    private final InstanceInjectableFactory instanceInjectableFactory = this.injectableFactories.forInstance();
    private QualifiedTypeStore<Injectable<?>> store;

    @BeforeEach
    public void beforeEach() {
        this.store = new QualifiedTypeStore(i -> new Key(i.getType(), (Collection)i.getQualifiers()), Injectable::getTypes);
    }

    @Test
    public void shouldStore() throws Exception {
        this.store.put((Object)this.classInjectableFactory.create(BeanWithBigRedInjection.class));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(Object.class, Set.of(BIG, RED)))).isEmpty();
        this.store.put((Object)this.classInjectableFactory.create(BigRedBean.class));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(Object.class, Set.of(BIG, RED)))).hasSize(1);
    }

    @Test
    public void shouldNotAllowRemovingInjectablesThatWereNeverAdded() throws Exception {
        this.store.put((Object)this.classInjectableFactory.create(Y.class));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(Y.class))).isNotNull();
        Assertions.assertThat((Iterable)this.store.resolve(new Key(X.class))).isNotNull();
        org.junit.jupiter.api.Assertions.assertThrows(MissingDependencyException.class, () -> this.store.remove((Object)this.classInjectableFactory.create(X.class)));
    }

    @Test
    public void shouldStoreWithQualifier() throws Exception {
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-b")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"c", new Annotation[]{QualifiedTypeStoreTest.named("parameter-c")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"d", new Annotation[]{QualifiedTypeStoreTest.named("parameter-c")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"f", new Annotation[]{QualifiedTypeStoreTest.named("parameter-e")}));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class))).hasSize(5);
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-a"))))).hasSize(1);
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-b"))))).hasSize(1);
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-c"))))).hasSize(2);
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-d"))))).hasSize(0);
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-e"))))).hasSize(1);
    }

    @Test
    public void shouldStoreMultipleOfSameType() throws Exception {
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"b", new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"c", new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"d", new Annotation[0]));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(String.class))).hasSize(4);
    }

    @Test
    public void shouldThrowExceptionWhenStoringSameInstanceWithSameQualifier() throws Exception {
        this.store.put((Object)this.instanceInjectableFactory.create((Object)new String("a"), new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.store.put((Object)this.instanceInjectableFactory.create((Object)new String("a"), new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}))).isExactlyInstanceOf(DuplicateDependencyException.class)).hasMessage("[@jakarta.inject.Named(value=parameter-a) java.lang.String] already exists").hasNoCause();
    }

    @Test
    public void shouldRemoveWithQualifier() throws Exception {
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-b")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"c", new Annotation[]{QualifiedTypeStoreTest.named("parameter-c")}));
        this.store.remove((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}));
        this.store.remove((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-b")}));
        this.store.remove((Object)this.instanceInjectableFactory.create((Object)"c", new Annotation[]{QualifiedTypeStoreTest.named("parameter-c")}));
    }

    private void setupStore() throws Exception {
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-a")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"a", new Annotation[]{QualifiedTypeStoreTest.named("parameter-b"), Annotations.of(Red.class)}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)"c", new Annotation[]{QualifiedTypeStoreTest.named("parameter-c")}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)4L, new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)2, new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)6L, new Annotation[]{Annotations.of(Red.class)}));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)8, new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)new Random(), new Annotation[0]));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)new ComparableButNotSerializable(), new Annotation[]{Annotations.of(Red.class)}));
        this.store.put((Object)this.classInjectableFactory.create(ComparableButNotSerializable.class));
    }

    @Test
    public void shouldResolve() throws Exception {
        this.setupStore();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.store.resolve(new Key(String.class)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.store.resolve(new Key(String.class, Set.of(QualifiedTypeStoreTest.named("parameter-b")))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.store.resolve(new Key(Number.class)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)this.store.resolve(new Key(Object.class)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.store.resolve(new Key(Object.class, Set.of(RED))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.store.resolve(new Key(Number.class, Set.of(RED))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)this.store.resolve(new Key(Serializable.class)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)this.store.resolve(new Key(Comparable.class)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.store.resolve(new Key(new TypeReference<Comparable<Long>>(){}.getType())).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.store.resolve(new Key((Type)Types.wildcardExtends((Type[])new Type[]{Serializable.class, new TypeReference<Comparable<String>>(){}.getType()}))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.store.resolve(new Key((Type)Types.wildcardExtends((Type[])new Type[]{Serializable.class, new TypeReference<Comparable<String>>(){}.getType()}), Set.of(RED))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.store.resolve(new Key(new TypeReference<Comparable<String>>(){}.getType())).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.store.resolve(new Key(new TypeReference<Comparable<String>>(){}.getType(), Set.of(RED))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.store.resolve(new Key((Type)Types.wildcardExtends((Type[])new Type[]{Serializable.class, RandomAccess.class}))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.store.resolve(new Key((Type)Types.wildcardExtends((Type[])new Type[]{new TypeReference<Comparable<Integer>>(){}.getType()}))).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.store.resolve(new Key((Type)Types.wildcardExtends((Type[])new Type[]{CharSequence.class, Number.class}))).size());
    }

    @Test
    public void resolveShouldFindInjectablesWhenCriteriaIsAnAnnotationClass() throws Exception {
        this.setupStore();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.store.resolve(new Key(Object.class, Set.of(RED))).size());
    }

    @Test
    public void putShouldThrowExceptionWhenInjectableIsNull() {
        Assertions.assertThatThrownBy(() -> this.store.put(null)).isExactlyInstanceOf(NullPointerException.class);
    }

    @Test
    public void removeShouldThrowExceptionWhenInjectableIsNull() {
        Assertions.assertThatThrownBy(() -> this.store.remove(null)).isExactlyInstanceOf(NullPointerException.class);
    }

    @Test
    public void putShouldRejectDuplicateBeans() throws DefinitionException {
        try {
            this.store.put((Object)this.classInjectableFactory.create(A.class));
            this.store.put((Object)this.classInjectableFactory.create(A.class));
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (DuplicateDependencyException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(A.class)));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.store.resolve(new Key(A.class)).size());
        }
    }

    @Test
    public void putAllShouldRejectDuplicateBeans() throws DefinitionException {
        try {
            this.store.putAll(List.of(this.classInjectableFactory.create(A.class), this.classInjectableFactory.create(A.class)));
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (DuplicateDependencyException e) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(A.class)));
        }
    }

    @Test
    public void putAllShouldRejectDuplicateBeansWhenOnePresentAlready() throws DefinitionException {
        try {
            this.store.put((Object)this.classInjectableFactory.create(A.class));
            this.store.putAll(List.of(this.classInjectableFactory.create(B.class), this.classInjectableFactory.create(A.class)));
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (DuplicateDependencyException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(A.class)));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(B.class)));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.store.resolve(new Key(A.class)).size());
        }
    }

    @Test
    public void containsShouldWork() throws Exception {
        this.store.put((Object)this.classInjectableFactory.create(A.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(A.class, Set.of(BIG))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(A.class, Set.of(RED))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(A.class, Set.of(BIG, RED))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(B.class, Set.of(BIG, RED))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(A.class, Set.of(Annotations.of(Small.class), RED))));
        this.store.put((Object)this.classInjectableFactory.create(StringProvider.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.store.contains(new Key(StringProvider.class)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key((Type)Types.parameterize(Provider.class, (Type[])new Type[]{String.class}))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(new TypeReference<Provider<String>>(){}.getType())));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.store.contains(new Key(new TypeReference<Provider<Long>>(){}.getType())));
    }

    @Test
    public void shouldAllowRegistrationOfMethodsAndFieldsThatProvideTheExactSameType() throws Exception {
        this.store.put((Object)this.fieldInjectableFactory.create(P.class.getDeclaredField("a"), P.class));
        this.store.put((Object)this.fieldInjectableFactory.create(P.class.getDeclaredField("b"), P.class));
        this.store.put((Object)this.methodInjectableFactory.create(P.class.getDeclaredMethod("a", new Class[0]), P.class));
        this.store.put((Object)this.methodInjectableFactory.create(P.class.getDeclaredMethod("b", new Class[0]), P.class));
        Assertions.assertThat((Iterable)this.store.resolve(new Key(A.class))).hasSize(4);
    }

    private static Annotation named(String name) {
        return Annotations.of(Named.class, Map.of("value", name));
    }

    public static interface Z {
    }

    public static class Y
    extends X
    implements Z {
    }

    public static class X {
    }

    public static class P {
        public A a = new A();
        public A b = new A();

        public A a() {
            return new A();
        }

        public A b() {
            return new A();
        }
    }

    public static class StringProvider
    implements Supplier<String> {
        @Override
        public String get() {
            return "string";
        }
    }

    static interface StringProviderInterface
    extends Supplier<String> {
    }

    public static class H {
        @Inject
        D injection1;
        @Inject
        F injection2;
        @Inject
        G injection3;
    }

    public static class G {
        @Inject
        @Big
        Object injection1;
        @Inject
        C injection2;
    }

    public static class F {
        @Inject
        C injection1;
        @Inject
        E injection2;
    }

    public static class E {
        @Inject
        B injection;
    }

    public static class D {
        @Inject
        C injection;
    }

    public static class C {
        @Inject
        A injection1;
        @Inject
        B injection2;
    }

    public static class B {
        @Inject
        @Big
        @Red
        Object injection;
    }

    @Big
    @Red
    public static class A {
    }

    public static class ComparableButNotSerializable
    implements Comparable<String> {
        @Override
        public int compareTo(String o) {
            return 0;
        }
    }
}

