/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DuplicateDependencyException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.FieldInjectableFactory;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.int4.dirk.core.discovery.Discoverer;
import org.int4.dirk.core.discovery.DiscovererFactory;
import org.int4.dirk.core.store.QualifiedTypeStore;
import org.int4.dirk.core.store.Resolver;
import org.int4.dirk.spi.discovery.TypeRegistrationExtension;
import org.int4.dirk.util.Types;

class DefaultDiscovererFactory
implements DiscovererFactory {
    private final Map<Type, List<WeakReference<Injectable<?>>>> derivedInjectables = new WeakHashMap();
    private final boolean autoDiscovery;
    private final Collection<TypeRegistrationExtension> extensions;
    private final ClassInjectableFactory classInjectableFactory;
    private final MethodInjectableFactory methodInjectableFactory;
    private final FieldInjectableFactory fieldInjectableFactory;

    public DefaultDiscovererFactory(boolean autoDiscovery, Collection<TypeRegistrationExtension> extensions, ClassInjectableFactory classInjectableFactory, MethodInjectableFactory methodInjectableFactory, FieldInjectableFactory fieldInjectableFactory) {
        this.autoDiscovery = autoDiscovery;
        this.extensions = extensions;
        this.classInjectableFactory = classInjectableFactory;
        this.methodInjectableFactory = methodInjectableFactory;
        this.fieldInjectableFactory = fieldInjectableFactory;
    }

    @Override
    public Discoverer create(Resolver<Injectable<?>> resolver, Collection<Type> types) {
        return new SimpleDiscoverer(resolver, types);
    }

    @Override
    public Discoverer create(Resolver<Injectable<?>> resolver, Injectable<?> injectable) {
        return new SimpleDiscoverer(resolver, injectable);
    }

    private static class IncludingResolver
    implements Resolver<Injectable<?>> {
        final Resolver<Injectable<?>> base;
        final Resolver<Injectable<?>> include;

        IncludingResolver(Resolver<Injectable<?>> base, Resolver<Injectable<?>> include) {
            this.base = base;
            this.include = include;
        }

        @Override
        public Set<Injectable<?>> resolve(Key key) {
            HashSet set = new HashSet(this.base.resolve(key));
            set.addAll(this.include.resolve(key));
            return set;
        }
    }

    private class DerivedRegistry
    implements TypeRegistrationExtension.Registry {
        final List<Injectable<?>> derivedInjectables = new ArrayList();

        private DerivedRegistry() {
        }

        public void add(Field field, Type ownerType) throws DefinitionException {
            this.derivedInjectables.add(DefaultDiscovererFactory.this.fieldInjectableFactory.create(field, ownerType));
        }

        public void add(Method method, Type ownerType) throws DefinitionException {
            this.derivedInjectables.add(DefaultDiscovererFactory.this.methodInjectableFactory.create(method, ownerType));
        }

        public void add(Type type) throws DefinitionException {
            this.derivedInjectables.add(DefaultDiscovererFactory.this.classInjectableFactory.create(type));
        }
    }

    private class SimpleDiscoverer
    implements Discoverer {
        private final QualifiedTypeStore<Injectable<?>> tempStore = new QualifiedTypeStore<Injectable>(i -> new Key(i.getType(), i.getQualifiers()), i -> i.getTypes());
        private final Map<Key, Binding> unresolvedBindings = new LinkedHashMap<Key, Binding>();
        private final List<Key> requiredKeys = new ArrayList<Key>();
        private final Map<Key, Key> via = new HashMap<Key, Key>();
        private final Set<Type> visitedTypes = new HashSet<Type>();
        private final Set<Type> visitTypes = new HashSet<Type>();
        private final List<String> encounteredProblems = new ArrayList<String>();
        private final IncludingResolver includingResolver;
        private boolean discoveryCompleted;

        SimpleDiscoverer(Resolver<Injectable<?>> resolver, Collection<Type> types) {
            this.includingResolver = new IncludingResolver(resolver::resolve, this.tempStore);
            for (Key key : types.stream().map(Key::new).collect(Collectors.toList())) {
                this.visitTypes.add(key.getType());
                this.requiredKeys.add(key);
            }
        }

        SimpleDiscoverer(Resolver<Injectable<?>> resolver, Injectable<?> injectable) {
            try {
                this.includingResolver = new IncludingResolver(resolver::resolve, this.tempStore);
                this.tempStore.put(injectable);
                this.visitTypes.add(injectable.getType());
            }
            catch (DuplicateDependencyException e) {
                throw new IllegalStateException("Assertion error", e);
            }
        }

        @Override
        public List<String> getProblems() {
            if (!this.discoveryCompleted) {
                throw new IllegalStateException("Call discover first");
            }
            return this.encounteredProblems;
        }

        @Override
        public Set<Injectable<?>> discover() throws DefinitionException {
            if (!this.discoveryCompleted) {
                this.discoveryCompleted = true;
                while (this.discoverViaExtensions() || this.discoverInputTypes() || this.discoverBindings()) {
                }
            }
            return this.tempStore.toSet();
        }

        private boolean addInjectables(List<Injectable<?>> injectables) {
            if (injectables.isEmpty()) {
                return false;
            }
            try {
                this.tempStore.putAll(injectables);
            }
            catch (DuplicateDependencyException e) {
                throw new IllegalStateException("Assertion error", e);
            }
            for (Injectable<?> injectable : injectables) {
                Key injectableKey = new Key(injectable.getType(), injectable.getQualifiers());
                this.visitTypes.add(injectable.getType());
                for (Binding binding : injectable.getBindings()) {
                    Key elementKey = binding.getElementKey();
                    if (!this.includingResolver.resolve(elementKey).isEmpty()) continue;
                    this.via.put(elementKey, injectableKey);
                    this.visitTypes.add(elementKey.getType());
                    if (!DefaultDiscovererFactory.this.autoDiscovery) continue;
                    this.unresolvedBindings.put(elementKey, binding);
                }
            }
            return true;
        }

        private boolean discoverViaExtensions() throws DefinitionException {
            ArrayList extensionDiscoveries = new ArrayList();
            for (Type type : this.visitTypes) {
                if (!this.visitedTypes.add(type)) continue;
                List<Injectable<?>> injectables = this.getFromCache(type);
                if (injectables == null) {
                    DerivedRegistry registry = new DerivedRegistry();
                    for (TypeRegistrationExtension extension : DefaultDiscovererFactory.this.extensions) {
                        extension.deriveTypes((TypeRegistrationExtension.Registry)registry, type);
                    }
                    injectables = registry.derivedInjectables;
                    this.putInCache(type, injectables);
                }
                extensionDiscoveries.addAll(injectables);
            }
            this.visitTypes.clear();
            return this.addInjectables(extensionDiscoveries);
        }

        private boolean discoverInputTypes() throws DefinitionException {
            ArrayList injectables = new ArrayList();
            DefinitionException throwable = null;
            for (Key key : this.requiredKeys) {
                boolean alreadyDerived = this.tempStore.contains(key);
                try {
                    injectables.add(this.attemptCreateInjectable(key));
                }
                catch (DefinitionException e) {
                    if (alreadyDerived) continue;
                    if (throwable == null) {
                        throwable = e;
                        continue;
                    }
                    throwable.addSuppressed((Throwable)e);
                }
            }
            if (throwable == null) {
                this.requiredKeys.clear();
                return this.addInjectables(injectables);
            }
            throw throwable;
        }

        private boolean discoverBindings() {
            Iterator<Map.Entry<Key, Binding>> iterator = this.unresolvedBindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Key, Binding> entry = iterator.next();
                Key key = entry.getKey();
                iterator.remove();
                if (!this.includingResolver.resolve(key).isEmpty()) continue;
                try {
                    return this.addInjectables(List.of(this.attemptCreateInjectable(key)));
                }
                catch (Exception e) {
                    this.encounteredProblems.add(this.toChain(key) + ", via " + entry.getValue() + ", is not registered and cannot be discovered (reason: " + e.getMessage() + (String)(e.getCause() != null ? " because " + e.getCause().getMessage() : "") + ")");
                }
            }
            return false;
        }

        private Injectable<?> attemptCreateInjectable(Key key) throws DefinitionException {
            Type type = key.getType();
            Injectable injectable = DefaultDiscovererFactory.this.classInjectableFactory.create(type);
            if (!injectable.getQualifiers().containsAll(key.getQualifiers())) {
                throw new DefinitionException((AnnotatedElement)Types.raw((Type)type), "is missing the required qualifiers: " + key.getQualifiers());
            }
            return injectable;
        }

        private String toChain(Key key) {
            if (this.via.containsKey(key)) {
                return "[" + key + "] required by " + this.toChain(this.via.get(key));
            }
            return "[" + key + "]";
        }

        private List<Injectable<?>> getFromCache(Type type) {
            List<WeakReference<Injectable<?>>> list = DefaultDiscovererFactory.this.derivedInjectables.get(type);
            if (list == null) {
                return null;
            }
            ArrayList hardReferences = new ArrayList();
            for (WeakReference<Injectable<?>> weakRef : list) {
                Injectable injectable = (Injectable)weakRef.get();
                if (injectable == null) {
                    return null;
                }
                hardReferences.add(injectable);
            }
            return hardReferences;
        }

        private void putInCache(Type type, List<Injectable<?>> injectables) {
            ArrayList list = new ArrayList();
            for (Injectable<?> injectable : injectables) {
                list.add(new WeakReference(injectable));
            }
            DefaultDiscovererFactory.this.derivedInjectables.put(type, list);
        }
    }
}

