/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.QualifiedType;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.core.definition.injection.Injection;

final class DefaultInjectable<T>
implements Injectable<T> {
    private final Type ownerType;
    private final Set<Type> types;
    private final QualifiedType qualifiedType;
    private final List<Binding> bindings;
    private final ExtendedScopeResolver scopeResolver;
    private final AnnotatedElement discriminator;
    private final Constructable<T> constructable;
    private final int hashCode;

    DefaultInjectable(Type ownerType, Set<Type> types, QualifiedType qualifiedType, List<Binding> bindings, ExtendedScopeResolver scopeResolver, AnnotatedElement discriminator, Constructable<T> constructable) {
        if (ownerType == null) {
            throw new IllegalArgumentException("ownerType cannot be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("types cannot be null");
        }
        if (qualifiedType == null) {
            throw new IllegalArgumentException("qualifiedType cannot be null");
        }
        if (bindings == null) {
            throw new IllegalArgumentException("bindings cannot be null");
        }
        if (scopeResolver == null) {
            throw new IllegalArgumentException("scopeResolver cannot be null");
        }
        if (constructable == null) {
            throw new IllegalArgumentException("constructable cannot be null");
        }
        if (discriminator == null) {
            throw new IllegalArgumentException("discriminator cannot be null");
        }
        if (!types.contains(qualifiedType.getType())) {
            throw new IllegalArgumentException("types must contain base type: " + qualifiedType.getType());
        }
        this.ownerType = ownerType;
        this.types = Collections.unmodifiableSet(new HashSet<Type>(types));
        this.qualifiedType = qualifiedType;
        this.bindings = Collections.unmodifiableList(new ArrayList<Binding>(bindings));
        this.scopeResolver = scopeResolver;
        this.discriminator = discriminator;
        this.constructable = constructable;
        this.hashCode = this.calculateHash();
    }

    private int calculateHash() {
        return Objects.hash(this.qualifiedType, this.ownerType, this.discriminator);
    }

    @Override
    public Type getType() {
        return this.qualifiedType.getType();
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiedType.getQualifiers();
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public ExtendedScopeResolver getScopeResolver() {
        return this.scopeResolver;
    }

    @Override
    public T create(List<Injection> injections) throws CreationException {
        return this.constructable.create(injections);
    }

    @Override
    public void destroy(T instance) {
        this.constructable.destroy(instance);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultInjectable other = (DefaultInjectable)obj;
        return this.qualifiedType.equals(other.qualifiedType) && this.ownerType.equals(other.ownerType) && this.discriminator.equals(other.discriminator);
    }

    public String toString() {
        String qualifiers = this.getQualifiers().stream().map(Object::toString).sorted().collect(Collectors.joining(", ")) + (this.getQualifiers().isEmpty() ? "" : " ");
        if (this.discriminator instanceof AccessibleObject) {
            return "Producer [" + qualifiers + this.discriminator + "]";
        }
        if (this.discriminator instanceof Class) {
            return "Class [" + qualifiers + ((Class)this.discriminator).getName() + "]";
        }
        return "Instance of [" + this.qualifiedType + " -> " + this.discriminator + "]";
    }
}

