/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.DefaultInjectable;
import org.int4.dirk.core.ScopeResolverManager;
import org.int4.dirk.core.definition.BadQualifiedTypeException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.InjectableFactory;
import org.int4.dirk.core.definition.QualifiedType;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Types;

class DefaultInjectableFactory
implements InjectableFactory {
    private final ScopeResolverManager scopeResolverManager;
    private final AnnotationStrategy annotationStrategy;
    private final ScopeStrategy scopeStrategy;
    private final Set<Class<?>> extendedTypes;

    DefaultInjectableFactory(ScopeResolverManager scopeResolverManager, AnnotationStrategy annotationStrategy, ScopeStrategy scopeStrategy, Set<Class<?>> extendedTypes) {
        this.scopeResolverManager = Objects.requireNonNull(scopeResolverManager, "scopeResolverManager cannot be null");
        this.annotationStrategy = Objects.requireNonNull(annotationStrategy, "annotationStrategy cannot be null");
        this.scopeStrategy = Objects.requireNonNull(scopeStrategy, "scopeStrategy cannot be null");
        this.extendedTypes = Objects.requireNonNull(extendedTypes, "extendedTypes cannot be null");
    }

    @Override
    public <T> Injectable<T> create(Type ownerType, Member member, AnnotatedElement element, List<Binding> bindings, Constructable<T> constructable) throws DefinitionException {
        try {
            Type type;
            if (ownerType == null) {
                throw new IllegalArgumentException("ownerType cannot be null");
            }
            if (element == null) {
                throw new IllegalArgumentException("element cannot be null");
            }
            if (bindings == null) {
                throw new IllegalArgumentException("bindings cannot be null");
            }
            if (constructable == null) {
                throw new IllegalArgumentException("constructable cannot be null");
            }
            Set injectAnnotations = this.annotationStrategy.getInjectAnnotations(element);
            if (!injectAnnotations.isEmpty()) {
                throw new DefinitionException(element, "should not have an inject annotation, but found: " + injectAnnotations.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
            }
            for (Binding binding : bindings) {
                if (binding.getAnnotatedElement() == null || this.scopeStrategy.getScope(binding.getAnnotatedElement()) == null) continue;
                throw new DefinitionException(binding.getAnnotatedElement(), "should not have a scope annotation, but found: " + this.scopeStrategy.getScope(binding.getAnnotatedElement()));
            }
            Type type2 = type = member == null ? ownerType : DefaultInjectableFactory.extractType(ownerType, member, element);
            if (this.extendedTypes.contains(Types.raw((Type)type))) {
                throw new DefinitionException(element, "cannot be registered as it conflicts with an InjectionTargetExtension for type: " + Types.raw((Type)type));
            }
            Annotation scope = this.scopeStrategy.getScope(element);
            ScopeResolver scopeResolver = this.scopeResolverManager.getScopeResolver(scope == null ? this.scopeStrategy.getDefaultAnnotation() : scope);
            boolean isPseudoScope = this.scopeStrategy.isPseudoScope(scopeResolver.getAnnotation());
            ExtendedScopeResolver extendedScopeResolver = new ExtendedScopeResolver(scopeResolver, isPseudoScope, scopeResolver.getAnnotation().equals(this.scopeStrategy.getDependentAnnotation()));
            return new DefaultInjectable<T>(ownerType, Types.getGenericSuperTypes((Type)type).stream().filter(t -> !this.extendedTypes.contains(Types.raw((Type)t))).collect(Collectors.toSet()), new QualifiedType(type, this.annotationStrategy.getQualifiers(element)), bindings, extendedScopeResolver, element, constructable);
        }
        catch (BadQualifiedTypeException e) {
            throw new DefinitionException(element, "has unsuitable type", (Throwable)e);
        }
    }

    private static Type extractType(Type ownerType, Member member, AnnotatedElement element) throws DefinitionException {
        Map typeArguments = Types.getTypeArguments((Type)ownerType, member.getDeclaringClass());
        if (typeArguments == null) {
            throw new IllegalArgumentException("ownerType must be assignable to member's declaring class: " + ownerType + "; declaring class: " + member.getDeclaringClass());
        }
        Type returnType = Types.resolveVariables((Map)typeArguments, (Type)(member instanceof Method ? ((Method)member).getGenericReturnType() : ((Field)member).getGenericType()));
        if (returnType == null) {
            throw new DefinitionException(element, "has unresolvable return type");
        }
        return returnType;
    }
}

