/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.reflect.Type;
import java.util.List;
import org.int4.dirk.api.InstanceResolver;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.InstantiationContextFactory;
import org.int4.dirk.core.KeyFactory;
import org.int4.dirk.core.definition.Key;

class DefaultInstanceResolver
implements InstanceResolver {
    private final InstantiationContextFactory instantiationContextFactory;

    DefaultInstanceResolver(InstantiationContextFactory instantiationContextFactory) {
        this.instantiationContextFactory = instantiationContextFactory;
    }

    public synchronized <T> T getInstance(Type type, Object ... qualifiers) throws UnsatisfiedResolutionException, AmbiguousResolutionException, CreationException, ScopeNotActiveException {
        return this.getInstance(KeyFactory.of(type, qualifiers));
    }

    public synchronized <T> T getInstance(Class<T> cls, Object ... qualifiers) throws UnsatisfiedResolutionException, AmbiguousResolutionException, CreationException, ScopeNotActiveException {
        return this.getInstance((Type)cls, qualifiers);
    }

    public synchronized <T> List<T> getInstances(Type type, Object ... qualifiers) throws CreationException {
        return this.getInstances(KeyFactory.of(type, qualifiers));
    }

    public synchronized <T> List<T> getInstances(Class<T> cls, Object ... qualifiers) throws CreationException {
        return this.getInstances((Type)cls, qualifiers);
    }

    private <T> T getInstance(Key key) throws UnsatisfiedResolutionException, AmbiguousResolutionException, CreationException, ScopeNotActiveException {
        return (T)this.instantiationContextFactory.createContext(key, false).create();
    }

    private <T> List<T> getInstances(Key key) throws CreationException {
        return this.instantiationContextFactory.createContext(key, false).createAll();
    }
}

