/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.int4.dirk.api.CandidateRegistry;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.core.KeyFactory;
import org.int4.dirk.core.definition.InstanceInjectableFactory;
import org.int4.dirk.core.discovery.Discoverer;
import org.int4.dirk.core.discovery.DiscovererFactory;
import org.int4.dirk.core.store.InjectableStore;

class InjectableStoreCandidateRegistry
implements CandidateRegistry {
    private final InjectableStore store;
    private final DiscovererFactory discovererFactory;
    private final InstanceInjectableFactory instanceInjectableFactory;

    public InjectableStoreCandidateRegistry(InjectableStore store, DiscovererFactory discovererFactory, InstanceInjectableFactory instanceInjectableFactory) {
        this.store = store;
        this.discovererFactory = discovererFactory;
        this.instanceInjectableFactory = instanceInjectableFactory;
    }

    public boolean contains(Type type, Object ... qualifiers) {
        return this.store.contains(KeyFactory.of(type, qualifiers));
    }

    public void register(Type type) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registerInternal(List.of(type));
    }

    public void register(Collection<Type> types) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registerInternal(types);
    }

    public void registerInstance(Object instance, Annotation ... qualifiers) throws DefinitionException, DependencyException {
        this.store.putAll(this.discovererFactory.create(this.store, this.instanceInjectableFactory.create(instance, qualifiers)).discover());
    }

    public void remove(Type type) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.removeInternal(List.of(type));
    }

    public void remove(Collection<Type> types) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.removeInternal(types);
    }

    public void removeInstance(Object instance, Annotation ... qualifiers) throws DefinitionException, DependencyException {
        this.store.removeAll(this.discovererFactory.create(this.store, this.instanceInjectableFactory.create(instance, qualifiers)).discover());
    }

    private void registerInternal(Collection<Type> types) throws AutoDiscoveryException, DefinitionException, DependencyException {
        Discoverer discoverer = this.discovererFactory.create(this.store, types);
        try {
            this.store.putAll(discoverer.discover());
        }
        catch (Exception e) {
            if (discoverer.getProblems().isEmpty()) {
                throw e;
            }
            List discoveredTypes = discoverer.discover().stream().filter(i -> !types.contains(i.getType())).map(Object::toString).sorted().collect(Collectors.toList());
            throw new AutoDiscoveryException("Unable to register " + types + (String)(discoveredTypes.isEmpty() ? "" : " and the discovered types " + discoveredTypes) + discoverer.getProblems().stream().collect(Collectors.joining("\n    -> ", "\n    -> ", "")), (Throwable)e);
        }
    }

    private void removeInternal(Collection<Type> types) throws AutoDiscoveryException, DefinitionException, DependencyException {
        Discoverer discoverer = this.discovererFactory.create(this.store, types);
        try {
            this.store.removeAll(discoverer.discover());
        }
        catch (Exception e) {
            if (discoverer.getProblems().isEmpty()) {
                throw e;
            }
            throw new AutoDiscoveryException("Unable to register " + types + discoverer.getProblems().stream().collect(Collectors.joining("\n    -> ", "\n    -> ", "")), (Throwable)e);
        }
    }
}

