/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.InjectionTargetExtensionStore;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.store.Resolver;
import org.int4.dirk.org.apache.commons.lang3.reflect.TypeUtils;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.instantiation.InstantiationContext;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.util.Types;

class InstantiationContextFactory {
    private static final Logger LOGGER = Logger.getLogger(InstantiationContextFactory.class.getName());
    private final Deque<LazyCreationalContext<?>> stack = new ArrayDeque();
    private final Resolver<Injectable<?>> resolver;
    private final AnnotationStrategy annotationStrategy;
    private final ProxyStrategy proxyStrategy;
    private final InjectionTargetExtensionStore injectionTargetExtensionStore;

    public InstantiationContextFactory(Resolver<Injectable<?>> resolver, AnnotationStrategy annotationStrategy, ProxyStrategy proxyStrategy, InjectionTargetExtensionStore injectionTargetExtensionStore) {
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.annotationStrategy = Objects.requireNonNull(annotationStrategy, "annotationStrategy");
        this.proxyStrategy = Objects.requireNonNull(proxyStrategy, "proxyStrategy");
        this.injectionTargetExtensionStore = Objects.requireNonNull(injectionTargetExtensionStore, "injectionTargetExtensionStore");
    }

    public <T> InstantiationContext<T> createContext(Binding binding) {
        return binding.associateIfAbsent("instantiationContext", () -> new SimpleInstantationContext(new Key(binding.getType(), binding.getQualifiers()), binding.isOptional()));
    }

    public <T> InstantiationContext<T> createContext(Key key, boolean optional) {
        return new SimpleInstantationContext(key, optional);
    }

    private class LazyReference<T>
    implements CreationalContext.Reference<T> {
        private final T instance;
        private final LazyCreationalContext<T> creationalContext;

        LazyReference(LazyCreationalContext<T> creationalContext, T instance) {
            this.instance = instance;
            this.creationalContext = creationalContext;
        }

        public T get() {
            if (this.creationalContext.dependents == null) {
                throw new IllegalStateException("context was already released");
            }
            return this.instance;
        }

        public void release() {
            if (this.creationalContext.dependents != null) {
                this.creationalContext.dependents.forEach(Runnable::run);
                this.creationalContext.dependents = null;
            }
        }
    }

    private class LazyCreationalContext<T>
    implements CreationalContext<T> {
        private final Injectable<T> injectable;
        private final LazyCreationalContext<?> parent;
        private Deque<Runnable> dependents = new ArrayDeque<Runnable>();
        private List<Injection> injections;

        LazyCreationalContext(LazyCreationalContext<?> parent, Injectable<T> injectable) {
            this.parent = injectable.getScopeResolver().isDependentScope() ? parent : null;
            this.injectable = injectable;
        }

        public CreationalContext.Reference<T> create() throws CreationException, AmbiguousResolutionException, UnsatisfiedResolutionException {
            return new LazyReference(this, this.injectable.create(this.getInjections()));
        }

        private List<Injection> getInjections() throws CreationException, AmbiguousResolutionException, UnsatisfiedResolutionException {
            try {
                if (this.injections == null) {
                    ArrayList<Injection> injections = new ArrayList<Injection>();
                    for (Binding binding : this.injectable.getBindings()) {
                        injections.add(new Injection(binding.getAccessibleObject(), InstantiationContextFactory.this.createContext(binding).create()));
                    }
                    this.injections = injections;
                }
                return this.injections;
            }
            catch (ScopeException e) {
                throw new AssertionError("Unexpected scope problem", e);
            }
        }

        <U> void add(Injectable<U> injectable, U instance) {
            if (this.dependents == null) {
                throw new IllegalStateException("context was already released");
            }
            if (this.parent == null) {
                this.dependents.addFirst(() -> injectable.destroy(instance));
            } else {
                this.parent.add(injectable, instance);
            }
        }
    }

    class SimpleInstantationContext<T>
    implements InstantiationContext<T> {
        private final InjectionTargetExtension<T, Object> injectionTargetExtension;
        private final InstantiationContext<Object> subcontext;
        private final Key key;
        private final boolean optional;

        SimpleInstantationContext(Key key, boolean optional) {
            this.key = key;
            this.optional = optional;
            Type type = key.getType();
            this.injectionTargetExtension = InstantiationContextFactory.this.injectionTargetExtensionStore.getExtension(Types.raw((Type)type));
            Type elementType = this.injectionTargetExtension == null ? null : this.injectionTargetExtension.getElementType(type);
            this.subcontext = elementType == null ? null : InstantiationContextFactory.this.createContext(new Key(elementType, key.getQualifiers()), optional);
        }

        public synchronized T create() throws CreationException, UnsatisfiedResolutionException, AmbiguousResolutionException, ScopeNotActiveException {
            if (this.subcontext == null) {
                T instance;
                Set<Injectable<?>> injectables = InstantiationContextFactory.this.resolver.resolve(this.key);
                if (injectables.size() > 1) {
                    throw new AmbiguousResolutionException("Multiple matching instances: [" + this.key + "]: " + injectables);
                }
                T t = instance = injectables.size() == 0 ? null : (T)this.createInstance(injectables.iterator().next());
                if (instance == null && !this.optional) {
                    throw new UnsatisfiedResolutionException("No such instance: [" + this.key + "]");
                }
                return instance;
            }
            return (T)this.injectionTargetExtension.getInstance(this.subcontext);
        }

        public synchronized List<T> createAll() throws CreationException {
            if (this.subcontext == null) {
                ArrayList instances = new ArrayList();
                Set<Injectable<?>> injectables = InstantiationContextFactory.this.resolver.resolve(this.key);
                for (Injectable<?> injectable : injectables) {
                    Object instance = this.createInstanceInScope(injectable);
                    if (instance == null) continue;
                    instances.add(instance);
                }
                if (instances.isEmpty() && this.optional) {
                    return null;
                }
                return instances;
            }
            return List.of();
        }

        public InstantiationContext<T> select(Annotation ... qualifiers) {
            return this.select(this.key.getType(), qualifiers);
        }

        public <U extends T> InstantiationContext<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return this.select(subtype, qualifiers);
        }

        public <U extends T> InstantiationContext<U> select(Type subtype, Annotation ... qualifiers) {
            if (!TypeUtils.isAssignable((Type)subtype, (Type)this.key.getType())) {
                throw new IllegalArgumentException("subtype must be a subtype of: " + this.key.getType());
            }
            Arrays.stream(qualifiers).filter(annotation -> !InstantiationContextFactory.this.annotationStrategy.isQualifier(annotation)).findFirst().ifPresent(annotation -> {
                throw new IllegalArgumentException(annotation + " is not a qualifier annotation");
            });
            Key subkey = new Key(subtype, Stream.concat(this.key.getQualifiers().stream(), Arrays.stream(qualifiers)).collect(Collectors.toSet()));
            return InstantiationContextFactory.this.createContext(subkey, this.optional);
        }

        private T createInstanceInScope(Injectable<T> injectable) throws CreationException {
            try {
                return injectable.getScopeResolver().isActive() ? (T)this.createInstance(injectable) : null;
            }
            catch (ScopeNotActiveException e) {
                LOGGER.warning("Scope " + injectable.getScopeResolver().getAnnotation() + " should have been active: " + e.getMessage());
                return null;
            }
        }

        private T createInstance(Injectable<T> injectable) throws CreationException, ScopeNotActiveException {
            ExtendedScopeResolver scopeResolver = injectable.getScopeResolver();
            LazyCreationalContext<?> parentCreationalContext = InstantiationContextFactory.this.stack.isEmpty() ? null : InstantiationContextFactory.this.stack.getLast();
            LazyCreationalContext creationalContext = new LazyCreationalContext(parentCreationalContext, injectable);
            InstantiationContextFactory.this.stack.addLast(creationalContext);
            try {
                Annotation parentScopeAnnotation = parentCreationalContext == null ? null : parentCreationalContext.injectable.getScopeResolver().getAnnotation();
                boolean needsProxy = !scopeResolver.isPseudoScope() && parentScopeAnnotation != null && !scopeResolver.getAnnotation().equals(parentScopeAnnotation);
                T instance = needsProxy ? InstantiationContextFactory.this.proxyStrategy.createProxyFactory(Types.raw((Type)injectable.getType())).apply(() -> scopeResolver.get(injectable, creationalContext)) : scopeResolver.get(injectable, creationalContext);
                creationalContext.add(injectable, instance);
                T t = instance;
                return t;
            }
            catch (CreationException | ScopeNotActiveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CreationException("[" + injectable.getType() + "] could not be created", (Throwable)e);
            }
            finally {
                InstantiationContextFactory.this.stack.removeLast();
            }
        }
    }
}

