/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.spi.scope.UnknownScopeException;

class ScopeResolverManager {
    private final Map<Annotation, ScopeResolver> scopeResolversByAnnotation = new HashMap<Annotation, ScopeResolver>();

    public ScopeResolverManager(List<ScopeResolver> scopeResolvers, Annotation dependentAnnotation) {
        for (ScopeResolver scopeResolver : scopeResolvers) {
            if (scopeResolver.getAnnotation() == null) {
                throw new IllegalArgumentException("scopeResolvers cannot have a null annotation: " + scopeResolver);
            }
            ScopeResolver resolver = this.scopeResolversByAnnotation.put(scopeResolver.getAnnotation(), scopeResolver);
            if (resolver == null) continue;
            throw new IllegalArgumentException("scopeResolvers should not contain multiple resolvers with the same annotation: " + resolver.getAnnotation());
        }
        this.scopeResolversByAnnotation.put(Objects.requireNonNull(dependentAnnotation, "dependentAnnotationClass"), new DependentScopeResolver(dependentAnnotation));
    }

    public ScopeResolver getScopeResolver(Annotation scope) {
        ScopeResolver scopeResolver = this.scopeResolversByAnnotation.get(scope);
        if (scopeResolver == null) {
            throw new UnknownScopeException("Unknown scope encountered: " + scope);
        }
        return scopeResolver;
    }

    private static class DependentScopeResolver
    implements ScopeResolver {
        private final Annotation dependentAnnotation;

        DependentScopeResolver(Annotation dependentAnnotation) {
            this.dependentAnnotation = dependentAnnotation;
        }

        public Annotation getAnnotation() {
            return this.dependentAnnotation;
        }

        public boolean isActive() {
            return true;
        }

        public <T> T get(Object key, CreationalContext<T> creationalContext) throws Exception {
            return (T)creationalContext.create().get();
        }

        public void remove(Object key) {
        }
    }
}

