/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.int4.dirk.api.CandidateRegistry;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.InstanceResolver;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.core.DefaultDiscovererFactory;
import org.int4.dirk.core.DefaultInjectableFactory;
import org.int4.dirk.core.DefaultInstanceResolver;
import org.int4.dirk.core.InjectableStoreCandidateRegistry;
import org.int4.dirk.core.InstantiationContextFactory;
import org.int4.dirk.core.ScopeResolverManager;
import org.int4.dirk.core.definition.BindingProvider;
import org.int4.dirk.core.definition.ClassInjectableFactory;
import org.int4.dirk.core.definition.FieldInjectableFactory;
import org.int4.dirk.core.definition.InjectionTargetExtensionStore;
import org.int4.dirk.core.definition.InstanceInjectableFactory;
import org.int4.dirk.core.definition.MethodInjectableFactory;
import org.int4.dirk.core.store.InjectableStore;
import org.int4.dirk.spi.config.InjectorStrategy;
import org.int4.dirk.spi.discovery.TypeRegistrationExtension;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.scope.ScopeResolver;

public class StandardInjector
implements Injector {
    private final InstanceResolver instanceResolver;
    private final CandidateRegistry registry;

    public StandardInjector(Collection<InjectionTargetExtension<?, ?>> injectionTargetExtensions, Collection<TypeRegistrationExtension> typeRegistrationExtensions, List<ScopeResolver> scopeResolvers, InjectorStrategy strategy, boolean autoDiscovery) {
        Objects.requireNonNull(injectionTargetExtensions, "injectionTargetExtensions cannot be null");
        Objects.requireNonNull(typeRegistrationExtensions, "typeRegistrationExtensions cannot be null");
        Objects.requireNonNull(scopeResolvers, "scopeResolvers cannot be null");
        Objects.requireNonNull(strategy, "strategy cannot be null");
        DefaultInjectableFactory injectableFactory = new DefaultInjectableFactory(new ScopeResolverManager(scopeResolvers, strategy.getScopeStrategy().getDependentAnnotation()), strategy.getAnnotationStrategy(), strategy.getScopeStrategy(), injectionTargetExtensions.stream().map(InjectionTargetExtension::getTargetClass).collect(Collectors.toSet()));
        InjectionTargetExtensionStore injectionTargetExtensionStore = new InjectionTargetExtensionStore(injectionTargetExtensions);
        BindingProvider bindingProvider = new BindingProvider(strategy.getAnnotationStrategy(), injectionTargetExtensionStore);
        DefaultDiscovererFactory discovererFactory = new DefaultDiscovererFactory(autoDiscovery, typeRegistrationExtensions, new ClassInjectableFactory(bindingProvider, injectableFactory, strategy.getLifeCycleCallbacksFactory()), new MethodInjectableFactory(bindingProvider, injectableFactory), new FieldInjectableFactory(bindingProvider, injectableFactory));
        InjectableStore store = new InjectableStore(strategy.getProxyStrategy());
        InstantiationContextFactory instantiationContextFactory = new InstantiationContextFactory(store, strategy.getAnnotationStrategy(), strategy.getProxyStrategy(), injectionTargetExtensionStore);
        InstanceInjectableFactory instanceInjectableFactory = new InstanceInjectableFactory(injectableFactory, strategy.getScopeStrategy().getSingletonAnnotation());
        this.registry = new InjectableStoreCandidateRegistry(store, discovererFactory, instanceInjectableFactory);
        this.instanceResolver = new DefaultInstanceResolver(instantiationContextFactory);
    }

    public InstanceResolver getInstanceResolver() {
        return this.instanceResolver;
    }

    public CandidateRegistry getCandidateRegistry() {
        return this.registry;
    }

    public <T> T getInstance(Type type, Object ... qualifiers) throws UnsatisfiedResolutionException, AmbiguousResolutionException, CreationException, ScopeNotActiveException {
        return (T)this.instanceResolver.getInstance(type, qualifiers);
    }

    public <T> T getInstance(Class<T> cls, Object ... qualifiers) throws UnsatisfiedResolutionException, AmbiguousResolutionException, CreationException, ScopeNotActiveException {
        return (T)this.instanceResolver.getInstance(cls, qualifiers);
    }

    public <T> List<T> getInstances(Type type, Object ... qualifiers) throws CreationException {
        return this.instanceResolver.getInstances(type, qualifiers);
    }

    public <T> List<T> getInstances(Class<T> cls, Object ... qualifiers) throws CreationException {
        return this.instanceResolver.getInstances(cls, qualifiers);
    }

    public boolean contains(Type type, Object ... qualifiers) {
        return this.registry.contains(type, qualifiers);
    }

    public void register(Type concreteType) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registry.register(concreteType);
    }

    public void register(Collection<Type> concreteTypes) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registry.register(concreteTypes);
    }

    public void registerInstance(Object instance, Annotation ... qualifiers) throws DefinitionException, DependencyException {
        this.registry.registerInstance(instance, qualifiers);
    }

    public void remove(Type concreteType) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registry.remove(concreteType);
    }

    public void remove(Collection<Type> concreteTypes) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.registry.remove(concreteTypes);
    }

    public void removeInstance(Object instance, Annotation ... qualifiers) throws DefinitionException, DependencyException {
        this.registry.removeInstance(instance, qualifiers);
    }
}

