/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.GenericBindingProvider;
import org.int4.dirk.core.definition.InjectionTargetExtensionStore;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.instantiation.TypeTrait;
import org.int4.dirk.util.Primitives;
import org.int4.dirk.util.Types;

public class BindingProvider {
    private static final EnumSet<TypeTrait> REQUIRES_EXACTLY_ONE = EnumSet.of(TypeTrait.REQUIRES_AT_LEAST_ONE, TypeTrait.REQUIRES_AT_MOST_ONE);
    private final InjectionTargetExtensionStore injectionTargetExtensionStore;
    private final GenericBindingProvider<Binding> delegate;

    public BindingProvider(AnnotationStrategy annotationStrategy, InjectionTargetExtensionStore injectionTargetExtensionStore) {
        this.injectionTargetExtensionStore = injectionTargetExtensionStore;
        this.delegate = new GenericBindingProvider<Binding>(annotationStrategy, (type, annotatedElement) -> {
            Parameter parameter = annotatedElement instanceof Parameter ? (Parameter)annotatedElement : null;
            return new DefaultBinding(type, annotatedElement == null ? Set.of() : annotationStrategy.getQualifiers(annotatedElement), annotatedElement == null ? false : annotationStrategy.isOptional(annotatedElement), parameter == null ? (AccessibleObject)annotatedElement : parameter.getDeclaringExecutable(), parameter);
        });
    }

    public List<Binding> ofConstructorAndMembers(Constructor<?> constructor, Class<?> cls) throws DefinitionException {
        return this.delegate.ofConstructorAndMembers(constructor, cls);
    }

    public List<Binding> ofConstructor(Constructor<?> constructor) throws DefinitionException {
        return this.delegate.ofConstructor(constructor);
    }

    public List<Binding> ofMembers(Class<?> cls) throws DefinitionException {
        return this.delegate.ofMembers(cls);
    }

    public List<Binding> ofMethod(Method method, Type ownerType) throws DefinitionException {
        return this.delegate.ofMethod(method, ownerType);
    }

    public List<Binding> ofField(Field field, Type ownerType) throws DefinitionException {
        return this.delegate.ofField(field, ownerType);
    }

    public Constructor<?> getAnnotatedConstructor(Class<?> cls) throws DefinitionException {
        return this.delegate.getAnnotatedConstructor(cls);
    }

    public <T> Constructor<T> getConstructor(Class<T> cls) throws DefinitionException {
        return this.delegate.getConstructor(cls);
    }

    private InjectionType constructData(Type inputType) {
        Type type = inputType;
        HashSet<TypeTrait> typeTraits = null;
        boolean mergeTraits = true;
        while (true) {
            InjectionTargetExtension extension = this.injectionTargetExtensionStore.getExtension(Types.raw((Type)type));
            if (typeTraits == null) {
                if (extension == null) {
                    return null;
                }
                typeTraits = new HashSet<TypeTrait>();
            }
            if (mergeTraits) {
                Set<Object> traits = extension == null ? REQUIRES_EXACTLY_ONE : extension.getTypeTraits();
                typeTraits.addAll(traits);
                if (!traits.contains(TypeTrait.LAZY)) {
                    mergeTraits = false;
                }
            }
            if (extension == null) {
                return new InjectionType(type, typeTraits);
            }
            type = extension.getElementType(type);
        }
    }

    public static class InjectionType {
        final Type elementType;
        final Set<TypeTrait> typeTraits;

        public InjectionType(Type elementType, Set<TypeTrait> typeTraits) {
            this.elementType = elementType;
            this.typeTraits = typeTraits;
        }

        public Type getElementType() {
            return this.elementType;
        }

        public Set<TypeTrait> getTypeTraits() {
            return this.typeTraits;
        }
    }

    private class DefaultBinding
    implements Binding {
        private final Type type;
        private final Set<Annotation> qualifiers;
        private final Key elementKey;
        private final boolean optional;
        private final Set<TypeTrait> typeTraits;
        private final AccessibleObject accessibleObject;
        private final Parameter parameter;
        private final Map<String, Object> data = new HashMap<String, Object>();

        public DefaultBinding(Type type, Set<Annotation> qualifiers, boolean optional, AccessibleObject accessibleObject, Parameter parameter) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null");
            }
            if (qualifiers == null) {
                throw new IllegalArgumentException("qualifiers cannot be null");
            }
            if (accessibleObject instanceof Executable && parameter == null) {
                throw new IllegalArgumentException("parameter cannot be null when accessibleObject is an instance of Executable");
            }
            if (!(accessibleObject instanceof Executable) && parameter != null) {
                throw new IllegalArgumentException("parameter must be null when accessibleObject is not an instance of Executable");
            }
            InjectionType injectionType = BindingProvider.this.constructData(type);
            this.type = Primitives.toBoxed((Type)type);
            this.qualifiers = Collections.unmodifiableSet(qualifiers);
            this.elementKey = new Key(injectionType == null ? type : injectionType.getElementType(), qualifiers);
            this.optional = optional;
            this.typeTraits = injectionType == null ? REQUIRES_EXACTLY_ONE : Collections.unmodifiableSet(injectionType.getTypeTraits());
            this.accessibleObject = accessibleObject;
            this.parameter = parameter;
            if (accessibleObject != null) {
                accessibleObject.setAccessible(true);
            }
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public Key getElementKey() {
            return this.elementKey;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public Set<TypeTrait> getTypeTraits() {
            return this.typeTraits;
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.accessibleObject;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public <T> T associateIfAbsent(String key, Supplier<T> valueSupplier) {
            return (T)this.data.computeIfAbsent(key, k -> valueSupplier.get());
        }

        public String toString() {
            if (this.accessibleObject instanceof Executable) {
                int index = Arrays.asList(((Executable)this.accessibleObject).getParameters()).indexOf(this.parameter);
                return "Parameter " + index + " [" + this.type + "] of [" + this.accessibleObject + "]";
            }
            if (this.accessibleObject != null) {
                return "Field [" + (String)(this.getQualifiers().isEmpty() ? "" : this.getQualifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " ") + ((Field)this.accessibleObject).toGenericString() + "]";
            }
            return "Owner Type [" + this.type + "]";
        }
    }
}

