/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.BindingProvider;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.InjectableFactory;
import org.int4.dirk.core.definition.factory.ClassObjectFactory;
import org.int4.dirk.spi.config.LifeCycleCallbacksFactory;
import org.int4.dirk.util.Types;

public class ClassInjectableFactory {
    private final BindingProvider bindingProvider;
    private final InjectableFactory injectableFactory;
    private final LifeCycleCallbacksFactory lifeCycleCallbacksFactory;

    public ClassInjectableFactory(BindingProvider bindingProvider, InjectableFactory injectableFactory, LifeCycleCallbacksFactory lifeCycleCallbacksFactory) {
        this.bindingProvider = bindingProvider;
        this.injectableFactory = injectableFactory;
        this.lifeCycleCallbacksFactory = lifeCycleCallbacksFactory;
    }

    public <T> Injectable<T> create(Type type) throws DefinitionException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class cls = Types.raw((Type)type);
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new DefinitionException((AnnotatedElement)cls, "cannot be abstract");
        }
        if (Types.containsTypeVariables((Type)type)) {
            throw new DefinitionException((AnnotatedElement)cls, "cannot have unresolvable type variables: " + Arrays.toString(cls.getTypeParameters()));
        }
        Constructor constructor = this.bindingProvider.getConstructor(cls);
        List<Binding> bindings = this.bindingProvider.ofConstructorAndMembers(constructor, cls);
        return this.injectableFactory.create(type, null, cls, bindings, new ClassObjectFactory(constructor, this.lifeCycleCallbacksFactory.create(cls)));
    }
}

